/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<FunctionReference> CODEC = RecordCodecBuilder.mapCodec(p_335341_ -> FunctionReference.commonFields(p_335341_).and((App)ResourceKey.codec(Registries.ITEM_MODIFIER).fieldOf("name").forGetter(p_335337_ -> p_335337_.name)).apply((Applicative)p_335341_, FunctionReference::new));
    private final ResourceKey<LootItemFunction> name;

    private FunctionReference(List<LootItemCondition> p_298661_, ResourceKey<LootItemFunction> p_335440_) {
        super(p_298661_);
        this.name = p_335440_;
    }

    public LootItemFunctionType<FunctionReference> getType() {
        return LootItemFunctions.REFERENCE;
    }

    @Override
    public void validate(ValidationContext p_279281_) {
        if (!p_279281_.allowsReferences()) {
            p_279281_.reportProblem(new ValidationContext.ReferenceNotAllowedProblem(this.name));
            return;
        }
        if (p_279281_.hasVisitedElement(this.name)) {
            p_279281_.reportProblem(new ValidationContext.RecursiveReferenceProblem(this.name));
            return;
        }
        super.validate(p_279281_);
        p_279281_.resolver().get(this.name).ifPresentOrElse(p_421469_ -> ((LootItemFunction)p_421469_.value()).validate(p_279281_.enterElement(new ProblemReporter.ElementReferencePathElement(this.name), this.name)), () -> p_279281_.reportProblem(new ValidationContext.MissingReferenceProblem(this.name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ItemStack run(ItemStack p_279458_, LootContext p_279370_) {
        LootItemFunction $$2 = p_279370_.getResolver().get(this.name).map(Holder::value).orElse(null);
        if ($$2 == null) {
            LOGGER.warn("Unknown function: {}", (Object)this.name.location());
            return p_279458_;
        }
        LootContext.VisitedEntry<LootItemFunction> $$3 = LootContext.createVisitedEntry($$2);
        if (p_279370_.pushVisitedElement($$3)) {
            try {
                ItemStack itemStack = (ItemStack)$$2.apply(p_279458_, p_279370_);
                return itemStack;
            }
            finally {
                p_279370_.popVisitedElement($$3);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return p_279458_;
    }

    public static LootItemConditionalFunction.Builder<?> functionReference(ResourceKey<LootItemFunction> p_335382_) {
        return FunctionReference.simpleBuilder(p_335336_ -> new FunctionReference((List<LootItemCondition>)p_335336_, p_335382_));
    }
}

