/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;

public interface ContainerComponentManipulators {
    public static final ContainerComponentManipulator<ItemContainerContents> CONTAINER = new ContainerComponentManipulator<ItemContainerContents>(){

        @Override
        public DataComponentType<ItemContainerContents> type() {
            return DataComponents.CONTAINER;
        }

        @Override
        public Stream<ItemStack> getContents(ItemContainerContents p_340963_) {
            return p_340963_.stream();
        }

        @Override
        public ItemContainerContents empty() {
            return ItemContainerContents.EMPTY;
        }

        @Override
        public ItemContainerContents setContents(ItemContainerContents p_341159_, Stream<ItemStack> p_340907_) {
            return ItemContainerContents.fromItems(p_340907_.toList());
        }

        @Override
        public /* synthetic */ Object empty() {
            return this.empty();
        }
    };
    public static final ContainerComponentManipulator<BundleContents> BUNDLE_CONTENTS = new ContainerComponentManipulator<BundleContents>(){

        @Override
        public DataComponentType<BundleContents> type() {
            return DataComponents.BUNDLE_CONTENTS;
        }

        @Override
        public BundleContents empty() {
            return BundleContents.EMPTY;
        }

        @Override
        public Stream<ItemStack> getContents(BundleContents p_341255_) {
            return p_341255_.itemCopyStream();
        }

        @Override
        public BundleContents setContents(BundleContents p_341134_, Stream<ItemStack> p_341127_) {
            BundleContents.Mutable $$2 = new BundleContents.Mutable(p_341134_).clearItems();
            p_341127_.forEach($$2::tryInsert);
            return $$2.toImmutable();
        }

        @Override
        public /* synthetic */ Object empty() {
            return this.empty();
        }
    };
    public static final ContainerComponentManipulator<ChargedProjectiles> CHARGED_PROJECTILES = new ContainerComponentManipulator<ChargedProjectiles>(){

        @Override
        public DataComponentType<ChargedProjectiles> type() {
            return DataComponents.CHARGED_PROJECTILES;
        }

        @Override
        public ChargedProjectiles empty() {
            return ChargedProjectiles.EMPTY;
        }

        @Override
        public Stream<ItemStack> getContents(ChargedProjectiles p_341086_) {
            return p_341086_.getItems().stream();
        }

        @Override
        public ChargedProjectiles setContents(ChargedProjectiles p_341319_, Stream<ItemStack> p_341213_) {
            return ChargedProjectiles.of(p_341213_.toList());
        }

        @Override
        public /* synthetic */ Object empty() {
            return this.empty();
        }
    };
    public static final Map<DataComponentType<?>, ContainerComponentManipulator<?>> ALL_MANIPULATORS = Stream.of(CONTAINER, BUNDLE_CONTENTS, CHARGED_PROJECTILES).collect(Collectors.toMap(ContainerComponentManipulator::type, p_340858_ -> p_340858_));
    public static final Codec<ContainerComponentManipulator<?>> CODEC = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().comapFlatMap(p_341089_ -> {
        ContainerComponentManipulator<?> $$1 = ALL_MANIPULATORS.get(p_341089_);
        return $$1 != null ? DataResult.success($$1) : DataResult.error(() -> "No items in component");
    }, ContainerComponentManipulator::type);
}

