/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueInputContextHelper;

public class TagValueInput
implements ValueInput {
    private final ProblemReporter problemReporter;
    private final ValueInputContextHelper context;
    private final CompoundTag input;

    private TagValueInput(ProblemReporter p_421784_, ValueInputContextHelper p_422152_, CompoundTag p_421946_) {
        this.problemReporter = p_421784_;
        this.context = p_422152_;
        this.input = p_421946_;
    }

    public static ValueInput create(ProblemReporter p_422128_, HolderLookup.Provider p_421808_, CompoundTag p_421841_) {
        return new TagValueInput(p_422128_, new ValueInputContextHelper(p_421808_, NbtOps.INSTANCE), p_421841_);
    }

    public static ValueInput.ValueInputList create(ProblemReporter p_422238_, HolderLookup.Provider p_421977_, List<CompoundTag> p_422016_) {
        return new CompoundListWrapper(p_422238_, new ValueInputContextHelper(p_421977_, NbtOps.INSTANCE), p_422016_);
    }

    @Override
    public <T> Optional<T> read(String p_422121_, Codec<T> p_421846_) {
        Tag $$2 = this.input.get(p_422121_);
        if ($$2 == null) {
            return Optional.empty();
        }
        DataResult dataResult = p_421846_.parse(this.context.ops(), (Object)$$2);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DataResult.Success $$3 = (DataResult.Success)dataResult2;
                yield Optional.of($$3.value());
            }
            case 1 -> {
                DataResult.Error $$4 = (DataResult.Error)dataResult2;
                this.problemReporter.report(new DecodeFromFieldFailedProblem(p_422121_, $$2, $$4));
                yield $$4.partialValue();
            }
        };
    }

    @Override
    public <T> Optional<T> read(MapCodec<T> p_422606_) {
        DynamicOps<Tag> $$1 = this.context.ops();
        DataResult dataResult = $$1.getMap((Object)this.input).flatMap(p_422400_ -> p_422606_.decode($$1, p_422400_));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DataResult.Success $$2 = (DataResult.Success)dataResult2;
                yield Optional.of($$2.value());
            }
            case 1 -> {
                DataResult.Error $$3 = (DataResult.Error)dataResult2;
                this.problemReporter.report(new DecodeFromMapFailedProblem($$3));
                yield $$3.partialValue();
            }
        };
    }

    @Nullable
    private <T extends Tag> T getOptionalTypedTag(String p_421947_, TagType<T> p_421665_) {
        Tag $$2 = this.input.get(p_421947_);
        if ($$2 == null) {
            return null;
        }
        TagType<?> $$3 = $$2.getType();
        if ($$3 != p_421665_) {
            this.problemReporter.report(new UnexpectedTypeProblem(p_421947_, p_421665_, $$3));
            return null;
        }
        return (T)$$2;
    }

    @Nullable
    private NumericTag getNumericTag(String p_421843_) {
        Tag $$1 = this.input.get(p_421843_);
        if ($$1 == null) {
            return null;
        }
        if ($$1 instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)$$1;
            return $$2;
        }
        this.problemReporter.report(new UnexpectedNonNumberProblem(p_421843_, $$1.getType()));
        return null;
    }

    @Override
    public Optional<ValueInput> child(String p_422520_) {
        CompoundTag $$1 = this.getOptionalTypedTag(p_422520_, CompoundTag.TYPE);
        return $$1 != null ? Optional.of(this.wrapChild(p_422520_, $$1)) : Optional.empty();
    }

    @Override
    public ValueInput childOrEmpty(String p_422555_) {
        CompoundTag $$1 = this.getOptionalTypedTag(p_422555_, CompoundTag.TYPE);
        return $$1 != null ? this.wrapChild(p_422555_, $$1) : this.context.empty();
    }

    @Override
    public Optional<ValueInput.ValueInputList> childrenList(String p_421700_) {
        ListTag $$1 = this.getOptionalTypedTag(p_421700_, ListTag.TYPE);
        return $$1 != null ? Optional.of(this.wrapList(p_421700_, this.context, $$1)) : Optional.empty();
    }

    @Override
    public ValueInput.ValueInputList childrenListOrEmpty(String p_422523_) {
        ListTag $$1 = this.getOptionalTypedTag(p_422523_, ListTag.TYPE);
        return $$1 != null ? this.wrapList(p_422523_, this.context, $$1) : this.context.emptyList();
    }

    @Override
    public <T> Optional<ValueInput.TypedInputList<T>> list(String p_422068_, Codec<T> p_421633_) {
        ListTag $$2 = this.getOptionalTypedTag(p_422068_, ListTag.TYPE);
        return $$2 != null ? Optional.of(this.wrapTypedList(p_422068_, $$2, p_421633_)) : Optional.empty();
    }

    @Override
    public <T> ValueInput.TypedInputList<T> listOrEmpty(String p_422509_, Codec<T> p_422700_) {
        ListTag $$2 = this.getOptionalTypedTag(p_422509_, ListTag.TYPE);
        return $$2 != null ? this.wrapTypedList(p_422509_, $$2, p_422700_) : this.context.emptyTypedList();
    }

    @Override
    public boolean getBooleanOr(String p_422592_, boolean p_422347_) {
        NumericTag $$2 = this.getNumericTag(p_422592_);
        return $$2 != null ? $$2.byteValue() != 0 : p_422347_;
    }

    @Override
    public byte getByteOr(String p_422035_, byte p_422310_) {
        NumericTag $$2 = this.getNumericTag(p_422035_);
        return $$2 != null ? $$2.byteValue() : p_422310_;
    }

    @Override
    public int getShortOr(String p_421616_, short p_421751_) {
        NumericTag $$2 = this.getNumericTag(p_421616_);
        return $$2 != null ? $$2.shortValue() : p_421751_;
    }

    @Override
    public Optional<Integer> getInt(String p_421813_) {
        NumericTag $$1 = this.getNumericTag(p_421813_);
        return $$1 != null ? Optional.of($$1.intValue()) : Optional.empty();
    }

    @Override
    public int getIntOr(String p_422549_, int p_422510_) {
        NumericTag $$2 = this.getNumericTag(p_422549_);
        return $$2 != null ? $$2.intValue() : p_422510_;
    }

    @Override
    public long getLongOr(String p_422010_, long p_421867_) {
        NumericTag $$2 = this.getNumericTag(p_422010_);
        return $$2 != null ? $$2.longValue() : p_421867_;
    }

    @Override
    public Optional<Long> getLong(String p_422244_) {
        NumericTag $$1 = this.getNumericTag(p_422244_);
        return $$1 != null ? Optional.of($$1.longValue()) : Optional.empty();
    }

    @Override
    public float getFloatOr(String p_421957_, float p_422667_) {
        NumericTag $$2 = this.getNumericTag(p_421957_);
        return $$2 != null ? $$2.floatValue() : p_422667_;
    }

    @Override
    public double getDoubleOr(String p_422065_, double p_421551_) {
        NumericTag $$2 = this.getNumericTag(p_422065_);
        return $$2 != null ? $$2.doubleValue() : p_421551_;
    }

    @Override
    public Optional<String> getString(String p_421854_) {
        StringTag $$1 = this.getOptionalTypedTag(p_421854_, StringTag.TYPE);
        return $$1 != null ? Optional.of($$1.value()) : Optional.empty();
    }

    @Override
    public String getStringOr(String p_422061_, String p_421849_) {
        StringTag $$2 = this.getOptionalTypedTag(p_422061_, StringTag.TYPE);
        return $$2 != null ? $$2.value() : p_421849_;
    }

    @Override
    public Optional<int[]> getIntArray(String p_422301_) {
        IntArrayTag $$1 = this.getOptionalTypedTag(p_422301_, IntArrayTag.TYPE);
        return $$1 != null ? Optional.of($$1.getAsIntArray()) : Optional.empty();
    }

    @Override
    public HolderLookup.Provider lookup() {
        return this.context.lookup();
    }

    private ValueInput wrapChild(String p_422021_, CompoundTag p_422689_) {
        return p_422689_.isEmpty() ? this.context.empty() : new TagValueInput(this.problemReporter.forChild(new ProblemReporter.FieldPathElement(p_422021_)), this.context, p_422689_);
    }

    static ValueInput wrapChild(ProblemReporter p_422473_, ValueInputContextHelper p_421819_, CompoundTag p_422675_) {
        return p_422675_.isEmpty() ? p_421819_.empty() : new TagValueInput(p_422473_, p_421819_, p_422675_);
    }

    private ValueInput.ValueInputList wrapList(String p_422657_, ValueInputContextHelper p_421936_, ListTag p_422099_) {
        return p_422099_.isEmpty() ? p_421936_.emptyList() : new ListWrapper(this.problemReporter, p_422657_, p_421936_, p_422099_);
    }

    private <T> ValueInput.TypedInputList<T> wrapTypedList(String p_422691_, ListTag p_422064_, Codec<T> p_422638_) {
        return p_422064_.isEmpty() ? this.context.emptyTypedList() : new TypedListWrapper<T>(this.problemReporter, p_422691_, this.context, p_422638_, p_422064_);
    }

    static class CompoundListWrapper
    implements ValueInput.ValueInputList {
        private final ProblemReporter problemReporter;
        private final ValueInputContextHelper context;
        private final List<CompoundTag> list;

        public CompoundListWrapper(ProblemReporter p_421583_, ValueInputContextHelper p_421580_, List<CompoundTag> p_421702_) {
            this.problemReporter = p_421583_;
            this.context = p_421580_;
            this.list = p_421702_;
        }

        ValueInput wrapChild(int p_422192_, CompoundTag p_422256_) {
            return TagValueInput.wrapChild(this.problemReporter.forChild(new ProblemReporter.IndexedPathElement(p_422192_)), this.context, p_422256_);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Stream<ValueInput> stream() {
            return Streams.mapWithIndex(this.list.stream(), (p_422311_, p_421760_) -> this.wrapChild((int)p_421760_, (CompoundTag)p_422311_));
        }

        @Override
        public Iterator<ValueInput> iterator() {
            final ListIterator<CompoundTag> $$0 = this.list.listIterator();
            return new AbstractIterator<ValueInput>(){

                @Nullable
                protected ValueInput computeNext() {
                    if ($$0.hasNext()) {
                        int $$02 = $$0.nextIndex();
                        CompoundTag $$1 = (CompoundTag)$$0.next();
                        return this.wrapChild($$02, $$1);
                    }
                    return (ValueInput)this.endOfData();
                }

                @Nullable
                protected /* synthetic */ Object computeNext() {
                    return this.computeNext();
                }
            };
        }
    }

    public record DecodeFromFieldFailedProblem(String name, Tag tag, DataResult.Error<?> error) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Failed to decode value '" + String.valueOf(this.tag) + "' from field '" + this.name + "': " + this.error.message();
        }
    }

    public record DecodeFromMapFailedProblem(DataResult.Error<?> error) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Failed to decode from map: " + this.error.message();
        }
    }

    public record UnexpectedTypeProblem(String name, TagType<?> expected, TagType<?> actual) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Expected field '" + this.name + "' to contain value of type " + this.expected.getName() + ", but got " + this.actual.getName();
        }
    }

    public record UnexpectedNonNumberProblem(String name, TagType<?> actual) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Expected field '" + this.name + "' to contain number, but got " + this.actual.getName();
        }
    }

    static class ListWrapper
    implements ValueInput.ValueInputList {
        private final ProblemReporter problemReporter;
        private final String name;
        final ValueInputContextHelper context;
        private final ListTag list;

        ListWrapper(ProblemReporter p_422557_, String p_422571_, ValueInputContextHelper p_422196_, ListTag p_421709_) {
            this.problemReporter = p_422557_;
            this.name = p_422571_;
            this.context = p_422196_;
            this.list = p_421709_;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        ProblemReporter reporterForChild(int p_421507_) {
            return this.problemReporter.forChild(new ProblemReporter.IndexedFieldPathElement(this.name, p_421507_));
        }

        void reportIndexUnwrapProblem(int p_422314_, Tag p_422447_) {
            this.problemReporter.report(new UnexpectedListElementTypeProblem(this.name, p_422314_, CompoundTag.TYPE, p_422447_.getType()));
        }

        @Override
        public Stream<ValueInput> stream() {
            return Streams.mapWithIndex(this.list.stream(), (p_421560_, p_421602_) -> {
                if (p_421560_ instanceof CompoundTag) {
                    CompoundTag $$2 = (CompoundTag)p_421560_;
                    return TagValueInput.wrapChild(this.reporterForChild((int)p_421602_), this.context, $$2);
                }
                this.reportIndexUnwrapProblem((int)p_421602_, (Tag)p_421560_);
                return null;
            }).filter(Objects::nonNull);
        }

        @Override
        public Iterator<ValueInput> iterator() {
            final Iterator $$0 = this.list.iterator();
            return new AbstractIterator<ValueInput>(){
                private int index;

                @Nullable
                protected ValueInput computeNext() {
                    while ($$0.hasNext()) {
                        int $$1;
                        Tag $$02 = (Tag)$$0.next();
                        ++this.index;
                        if ($$02 instanceof CompoundTag) {
                            CompoundTag $$2 = (CompoundTag)$$02;
                            return TagValueInput.wrapChild(this.reporterForChild($$1), context, $$2);
                        }
                        this.reportIndexUnwrapProblem($$1, $$02);
                    }
                    return (ValueInput)this.endOfData();
                }

                @Nullable
                protected /* synthetic */ Object computeNext() {
                    return this.computeNext();
                }
            };
        }
    }

    static class TypedListWrapper<T>
    implements ValueInput.TypedInputList<T> {
        private final ProblemReporter problemReporter;
        private final String name;
        final ValueInputContextHelper context;
        final Codec<T> codec;
        private final ListTag list;

        TypedListWrapper(ProblemReporter p_422552_, String p_421835_, ValueInputContextHelper p_422408_, Codec<T> p_421508_, ListTag p_422365_) {
            this.problemReporter = p_422552_;
            this.name = p_421835_;
            this.context = p_422408_;
            this.codec = p_421508_;
            this.list = p_422365_;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        void reportIndexUnwrapProblem(int p_422123_, Tag p_421922_, DataResult.Error<?> p_422537_) {
            this.problemReporter.report(new DecodeFromListFailedProblem(this.name, p_422123_, p_421922_, p_422537_));
        }

        @Override
        public Stream<T> stream() {
            return Streams.mapWithIndex(this.list.stream(), (p_421803_, p_422239_) -> {
                DataResult dataResult = this.codec.parse(this.context.ops(), p_421803_);
                Objects.requireNonNull(dataResult);
                DataResult $$2 = dataResult;
                int $$3 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)$$2, $$3)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        DataResult.Success $$4 = (DataResult.Success)$$2;
                        yield $$4.value();
                    }
                    case 1 -> {
                        DataResult.Error $$5 = (DataResult.Error)$$2;
                        this.reportIndexUnwrapProblem((int)p_422239_, (Tag)p_421803_, (DataResult.Error<?>)$$5);
                        yield $$5.partialValue().orElse(null);
                    }
                };
            }).filter(Objects::nonNull);
        }

        @Override
        public Iterator<T> iterator() {
            final ListIterator $$0 = this.list.listIterator();
            return new AbstractIterator<T>(){

                @Nullable
                protected T computeNext() {
                    while ($$0.hasNext()) {
                        DataResult dataResult;
                        int $$02 = $$0.nextIndex();
                        Tag $$1 = (Tag)$$0.next();
                        Objects.requireNonNull(codec.parse(context.ops(), (Object)$$1));
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                DataResult.Success $$2 = (DataResult.Success)dataResult;
                                return $$2.value();
                            }
                            case 1: 
                        }
                        DataResult.Error $$3 = (DataResult.Error)dataResult;
                        this.reportIndexUnwrapProblem($$02, $$1, $$3);
                        if (!$$3.partialValue().isPresent()) continue;
                        return $$3.partialValue().get();
                    }
                    return this.endOfData();
                }
            };
        }
    }

    public record UnexpectedListElementTypeProblem(String name, int index, TagType<?> expected, TagType<?> actual) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Expected list '" + this.name + "' to contain at index " + this.index + " value of type " + this.expected.getName() + ", but got " + this.actual.getName();
        }
    }

    public record DecodeFromListFailedProblem(String name, int index, Tag tag, DataResult.Error<?> error) implements ProblemReporter.Problem
    {
        @Override
        public String description() {
            return "Failed to decode value '" + String.valueOf(this.tag) + "' from field '" + this.name + "' at index " + this.index + "': " + this.error.message();
        }
    }
}

