/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess p_78430_, DataFixer p_78431_) {
        this.fixerUpper = p_78431_;
        this.playerDir = p_78430_.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player p_78434_) {
        try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector(p_78434_.problemPath(), LOGGER);){
            TagValueOutput $$2 = TagValueOutput.createWithContext($$1, p_78434_.registryAccess());
            p_78434_.saveWithoutId($$2);
            Path $$3 = this.playerDir.toPath();
            Path $$4 = Files.createTempFile($$3, p_78434_.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            CompoundTag $$5 = $$2.buildResult();
            NbtIo.writeCompressed($$5, $$4);
            Path $$6 = $$3.resolve(p_78434_.getStringUUID() + ".dat");
            Path $$7 = $$3.resolve(p_78434_.getStringUUID() + ".dat_old");
            Util.safeReplaceFile($$6, $$4, $$7);
        }
        catch (Exception $$8) {
            LOGGER.warn("Failed to save player data for {}", (Object)p_78434_.getName().getString());
        }
    }

    private void backup(Player p_316529_, String p_316776_) {
        Path $$2 = this.playerDir.toPath();
        Path $$3 = $$2.resolve(p_316529_.getStringUUID() + p_316776_);
        Path $$4 = $$2.resolve(p_316529_.getStringUUID() + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + p_316776_);
        if (!Files.isRegularFile($$3, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy($$3, $$4, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception $$5) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)p_316529_.getName().getString(), (Object)$$5);
        }
    }

    private Optional<CompoundTag> load(Player p_316534_, String p_316666_) {
        File $$2 = new File(this.playerDir, p_316534_.getStringUUID() + p_316666_);
        if ($$2.exists() && $$2.isFile()) {
            try {
                return Optional.of(NbtIo.readCompressed($$2.toPath(), NbtAccounter.unlimitedHeap()));
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to load player data for {}", (Object)p_316534_.getName().getString());
            }
        }
        return Optional.empty();
    }

    public Optional<ValueInput> load(Player p_78436_, ProblemReporter p_421744_) {
        Optional<CompoundTag> $$2 = this.load(p_78436_, ".dat");
        if ($$2.isEmpty()) {
            this.backup(p_78436_, ".dat");
        }
        return $$2.or(() -> this.load(p_78436_, ".dat_old")).map(p_427223_ -> {
            int $$3 = NbtUtils.getDataVersion(p_427223_, -1);
            p_427223_ = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (CompoundTag)p_427223_, $$3);
            ValueInput $$4 = TagValueInput.create(p_421744_, (HolderLookup.Provider)p_78436_.registryAccess(), p_427223_);
            p_78436_.load($$4);
            return $$4;
        });
    }
}

