/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;

public abstract class RedstoneWireEvaluator {
    protected final RedStoneWireBlock wireBlock;

    protected RedstoneWireEvaluator(RedStoneWireBlock p_363590_) {
        this.wireBlock = p_363590_;
    }

    public abstract void updatePowerStrength(Level var1, BlockPos var2, BlockState var3, @Nullable Orientation var4, boolean var5);

    protected int getBlockSignal(Level p_362603_, BlockPos p_364469_) {
        return this.wireBlock.getBlockSignal(p_362603_, p_364469_);
    }

    protected int getWireSignal(BlockPos p_362787_, BlockState p_363583_) {
        return p_363583_.is(this.wireBlock) ? p_363583_.getValue(RedStoneWireBlock.POWER) : 0;
    }

    protected int getIncomingWireSignal(Level p_361456_, BlockPos p_363935_) {
        int $$2 = 0;
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BlockPos $$4 = p_363935_.relative($$3);
            BlockState $$5 = p_361456_.getBlockState($$4);
            $$2 = Math.max($$2, this.getWireSignal($$4, $$5));
            BlockPos $$6 = p_363935_.above();
            if ($$5.isRedstoneConductor(p_361456_, $$4) && !p_361456_.getBlockState($$6).isRedstoneConductor(p_361456_, $$6)) {
                BlockPos $$7 = $$4.above();
                $$2 = Math.max($$2, this.getWireSignal($$7, p_361456_.getBlockState($$7)));
                continue;
            }
            if ($$5.isRedstoneConductor(p_361456_, $$4)) continue;
            BlockPos $$8 = $$4.below();
            $$2 = Math.max($$2, this.getWireSignal($$8, p_361456_.getBlockState($$8)));
        }
        return Math.max(0, $$2 - 1);
    }
}

