/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.RedstoneWireOrientationsDebugPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;

public class ExperimentalRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    private final Deque<BlockPos> wiresToTurnOff = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> wiresToTurnOn = new ArrayDeque<BlockPos>();
    private final Object2IntMap<BlockPos> updatedWires = new Object2IntLinkedOpenHashMap();

    public ExperimentalRedstoneWireEvaluator(RedStoneWireBlock p_364859_) {
        super(p_364859_);
    }

    @Override
    public void updatePowerStrength(Level p_364203_, BlockPos p_362182_, BlockState p_361454_, @Nullable Orientation p_363673_, boolean p_366757_) {
        Orientation $$5 = ExperimentalRedstoneWireEvaluator.getInitialOrientation(p_364203_, p_363673_);
        this.calculateCurrentChanges(p_364203_, p_362182_, $$5);
        ObjectIterator $$6 = this.updatedWires.object2IntEntrySet().iterator();
        boolean $$7 = true;
        while ($$6.hasNext()) {
            Object2IntMap.Entry $$8 = (Object2IntMap.Entry)$$6.next();
            BlockPos $$9 = (BlockPos)$$8.getKey();
            int $$10 = $$8.getIntValue();
            int $$11 = ExperimentalRedstoneWireEvaluator.unpackPower($$10);
            BlockState $$12 = p_364203_.getBlockState($$9);
            if ($$12.is(this.wireBlock) && !$$12.getValue(RedStoneWireBlock.POWER).equals($$11)) {
                int $$13 = 2;
                if (!p_366757_ || !$$7) {
                    $$13 |= 0x80;
                }
                p_364203_.setBlock($$9, (BlockState)$$12.setValue(RedStoneWireBlock.POWER, $$11), $$13);
            } else {
                $$6.remove();
            }
            $$7 = false;
        }
        this.causeNeighborUpdates(p_364203_);
    }

    private void causeNeighborUpdates(Level p_362391_) {
        this.updatedWires.forEach((p_364111_, p_365025_) -> {
            Orientation $$3 = ExperimentalRedstoneWireEvaluator.unpackOrientation(p_365025_);
            BlockState $$4 = p_362391_.getBlockState((BlockPos)p_364111_);
            for (Direction $$5 : $$3.getDirections()) {
                if (!ExperimentalRedstoneWireEvaluator.isConnected($$4, $$5)) continue;
                BlockPos $$6 = p_364111_.relative($$5);
                BlockState $$7 = p_362391_.getBlockState($$6);
                Orientation $$8 = $$3.withFrontPreserveUp($$5);
                p_362391_.neighborChanged($$7, $$6, this.wireBlock, $$8, false);
                if (!$$7.isRedstoneConductor(p_362391_, $$6)) continue;
                for (Direction $$9 : $$8.getDirections()) {
                    if ($$9 == $$5.getOpposite()) continue;
                    p_362391_.neighborChanged($$6.relative($$9), this.wireBlock, $$8.withFrontPreserveUp($$9));
                }
            }
        });
    }

    private static boolean isConnected(BlockState p_363855_, Direction p_362257_) {
        EnumProperty<RedstoneSide> $$2 = RedStoneWireBlock.PROPERTY_BY_DIRECTION.get(p_362257_);
        if ($$2 == null) {
            return p_362257_ == Direction.DOWN;
        }
        return p_363855_.getValue($$2).isConnected();
    }

    private static Orientation getInitialOrientation(Level p_363526_, @Nullable Orientation p_363389_) {
        Orientation $$3;
        if (p_363389_ != null) {
            Orientation $$2 = p_363389_;
        } else {
            $$3 = Orientation.random(p_363526_.random);
        }
        return $$3.withUp(Direction.UP).withSideBias(Orientation.SideBias.LEFT);
    }

    private void calculateCurrentChanges(Level p_361794_, BlockPos p_363346_, Orientation p_362683_) {
        BlockState $$3 = p_361794_.getBlockState(p_363346_);
        if ($$3.is(this.wireBlock)) {
            this.setPower(p_363346_, $$3.getValue(RedStoneWireBlock.POWER), p_362683_);
            this.wiresToTurnOff.add(p_363346_);
        } else {
            this.propagateChangeToNeighbors(p_361794_, p_363346_, 0, p_362683_, true);
        }
        while (!this.wiresToTurnOff.isEmpty()) {
            int $$12;
            int $$9;
            BlockPos $$4 = this.wiresToTurnOff.removeFirst();
            int $$5 = this.updatedWires.getInt((Object)$$4);
            Orientation $$6 = ExperimentalRedstoneWireEvaluator.unpackOrientation($$5);
            int $$7 = ExperimentalRedstoneWireEvaluator.unpackPower($$5);
            int $$8 = this.getBlockSignal(p_361794_, $$4);
            int $$10 = Math.max($$8, $$9 = this.getIncomingWireSignal(p_361794_, $$4));
            if ($$10 < $$7) {
                if ($$8 > 0 && !this.wiresToTurnOn.contains($$4)) {
                    this.wiresToTurnOn.add($$4);
                }
                boolean $$11 = false;
            } else {
                $$12 = $$10;
            }
            if ($$12 != $$7) {
                this.setPower($$4, $$12, $$6);
            }
            this.propagateChangeToNeighbors(p_361794_, $$4, $$12, $$6, $$7 > $$10);
        }
        while (!this.wiresToTurnOn.isEmpty()) {
            BlockPos $$13 = this.wiresToTurnOn.removeFirst();
            int $$14 = this.updatedWires.getInt((Object)$$13);
            int $$15 = ExperimentalRedstoneWireEvaluator.unpackPower($$14);
            int $$16 = this.getBlockSignal(p_361794_, $$13);
            int $$17 = this.getIncomingWireSignal(p_361794_, $$13);
            int $$18 = Math.max($$16, $$17);
            Orientation $$19 = ExperimentalRedstoneWireEvaluator.unpackOrientation($$14);
            if ($$18 > $$15) {
                this.setPower($$13, $$18, $$19);
            } else if ($$18 < $$15) {
                throw new IllegalStateException("Turning off wire while trying to turn it on. Should not happen.");
            }
            this.propagateChangeToNeighbors(p_361794_, $$13, $$18, $$19, false);
        }
    }

    private static int packOrientationAndPower(Orientation p_363227_, int p_364958_) {
        return p_363227_.getIndex() << 4 | p_364958_;
    }

    private static Orientation unpackOrientation(int p_361592_) {
        return Orientation.fromIndex(p_361592_ >> 4);
    }

    private static int unpackPower(int p_360709_) {
        return p_360709_ & 0xF;
    }

    private void setPower(BlockPos p_364897_, int p_364699_, Orientation p_364501_) {
        this.updatedWires.compute((Object)p_364897_, (p_362131_, p_363114_) -> {
            if (p_363114_ == null) {
                return ExperimentalRedstoneWireEvaluator.packOrientationAndPower(p_364501_, p_364699_);
            }
            return ExperimentalRedstoneWireEvaluator.packOrientationAndPower(ExperimentalRedstoneWireEvaluator.unpackOrientation(p_363114_), p_364699_);
        });
    }

    private void propagateChangeToNeighbors(Level p_363529_, BlockPos p_364797_, int p_360356_, Orientation p_361821_, boolean p_363868_) {
        for (Direction $$5 : p_361821_.getHorizontalDirections()) {
            BlockPos $$6 = p_364797_.relative($$5);
            this.enqueueNeighborWire(p_363529_, $$6, p_360356_, p_361821_.withFront($$5), p_363868_);
        }
        for (Direction $$7 : p_361821_.getVerticalDirections()) {
            BlockPos $$8 = p_364797_.relative($$7);
            boolean $$9 = p_363529_.getBlockState($$8).isRedstoneConductor(p_363529_, $$8);
            for (Direction $$10 : p_361821_.getHorizontalDirections()) {
                BlockPos $$11 = p_364797_.relative($$10);
                if ($$7 == Direction.UP && !$$9) {
                    BlockPos $$12 = $$8.relative($$10);
                    this.enqueueNeighborWire(p_363529_, $$12, p_360356_, p_361821_.withFront($$10), p_363868_);
                    continue;
                }
                if ($$7 != Direction.DOWN || p_363529_.getBlockState($$11).isRedstoneConductor(p_363529_, $$11)) continue;
                BlockPos $$13 = $$8.relative($$10);
                this.enqueueNeighborWire(p_363529_, $$13, p_360356_, p_361821_.withFront($$10), p_363868_);
            }
        }
    }

    private void enqueueNeighborWire(Level p_361921_, BlockPos p_361620_, int p_361312_, Orientation p_364781_, boolean p_363545_) {
        BlockState $$5 = p_361921_.getBlockState(p_361620_);
        if ($$5.is(this.wireBlock)) {
            int $$6 = this.getWireSignal(p_361620_, $$5);
            if ($$6 < p_361312_ - 1 && !this.wiresToTurnOn.contains(p_361620_)) {
                this.wiresToTurnOn.add(p_361620_);
                this.setPower(p_361620_, $$6, p_364781_);
            }
            if (p_363545_ && $$6 > p_361312_ && !this.wiresToTurnOff.contains(p_361620_)) {
                this.wiresToTurnOff.add(p_361620_);
                this.setPower(p_361620_, $$6, p_364781_);
            }
        }
    }

    @Override
    protected int getWireSignal(BlockPos p_360845_, BlockState p_363778_) {
        int $$2 = this.updatedWires.getOrDefault((Object)p_360845_, -1);
        if ($$2 != -1) {
            return ExperimentalRedstoneWireEvaluator.unpackPower($$2);
        }
        return super.getWireSignal(p_360845_, p_363778_);
    }

    private static /* synthetic */ void lambda$causeNeighborUpdates$1(List p_363387_, BlockPos p_361051_, Integer p_361983_) {
        Orientation $$3 = ExperimentalRedstoneWireEvaluator.unpackOrientation(p_361983_);
        p_363387_.add(new RedstoneWireOrientationsDebugPayload.Wire(p_361051_, $$3));
    }
}

