/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;

public class PortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBehaviour.StatePredicate FRAME = (p_77720_, p_77721_, p_77722_) -> p_77720_.is(Blocks.OBSIDIAN);
    private static final float SAFE_TRAVEL_MAX_ENTITY_XY = 4.0f;
    private static final double SAFE_TRAVEL_MAX_VERTICAL_DELTA = 1.0;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private final int numPortalBlocks;
    private final BlockPos bottomLeft;
    private final int height;
    private final int width;

    private PortalShape(Direction.Axis p_77697_, int p_374222_, Direction p_374407_, BlockPos p_77696_, int p_374218_, int p_374477_) {
        this.axis = p_77697_;
        this.numPortalBlocks = p_374222_;
        this.rightDir = p_374407_;
        this.bottomLeft = p_77696_;
        this.width = p_374218_;
        this.height = p_374477_;
    }

    public static Optional<PortalShape> findEmptyPortalShape(LevelAccessor p_77709_, BlockPos p_77710_, Direction.Axis p_77711_) {
        return PortalShape.findPortalShape(p_77709_, p_77710_, p_77727_ -> p_77727_.isValid() && p_77727_.numPortalBlocks == 0, p_77711_);
    }

    public static Optional<PortalShape> findPortalShape(LevelAccessor p_77713_, BlockPos p_77714_, Predicate<PortalShape> p_77715_, Direction.Axis p_77716_) {
        Optional<PortalShape> $$4 = Optional.of(PortalShape.findAnyShape(p_77713_, p_77714_, p_77716_)).filter(p_77715_);
        if ($$4.isPresent()) {
            return $$4;
        }
        Direction.Axis $$5 = p_77716_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(PortalShape.findAnyShape(p_77713_, p_77714_, $$5)).filter(p_77715_);
    }

    public static PortalShape findAnyShape(BlockGetter p_374054_, BlockPos p_374346_, Direction.Axis p_374516_) {
        Direction $$3 = p_374516_ == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        BlockPos $$4 = PortalShape.calculateBottomLeft(p_374054_, $$3, p_374346_);
        if ($$4 == null) {
            return new PortalShape(p_374516_, 0, $$3, p_374346_, 0, 0);
        }
        int $$5 = PortalShape.calculateWidth(p_374054_, $$4, $$3);
        if ($$5 == 0) {
            return new PortalShape(p_374516_, 0, $$3, $$4, 0, 0);
        }
        MutableInt $$6 = new MutableInt();
        int $$7 = PortalShape.calculateHeight(p_374054_, $$4, $$3, $$5, $$6);
        return new PortalShape(p_374516_, $$6.getValue(), $$3, $$4, $$5, $$7);
    }

    @Nullable
    private static BlockPos calculateBottomLeft(BlockGetter p_374347_, Direction p_374365_, BlockPos p_77734_) {
        int $$3 = Math.max(p_374347_.getMinY(), p_77734_.getY() - 21);
        while (p_77734_.getY() > $$3 && PortalShape.isEmpty(p_374347_.getBlockState(p_77734_.below()))) {
            p_77734_ = p_77734_.below();
        }
        Direction $$4 = p_374365_.getOpposite();
        int $$5 = PortalShape.getDistanceUntilEdgeAboveFrame(p_374347_, p_77734_, $$4) - 1;
        if ($$5 < 0) {
            return null;
        }
        return p_77734_.relative($$4, $$5);
    }

    private static int calculateWidth(BlockGetter p_374528_, BlockPos p_374039_, Direction p_374180_) {
        int $$3 = PortalShape.getDistanceUntilEdgeAboveFrame(p_374528_, p_374039_, p_374180_);
        if ($$3 < 2 || $$3 > 21) {
            return 0;
        }
        return $$3;
    }

    private static int getDistanceUntilEdgeAboveFrame(BlockGetter p_374084_, BlockPos p_77736_, Direction p_77737_) {
        BlockPos.MutableBlockPos $$3 = new BlockPos.MutableBlockPos();
        for (int $$4 = 0; $$4 <= 21; ++$$4) {
            $$3.set(p_77736_).move(p_77737_, $$4);
            BlockState $$5 = p_374084_.getBlockState($$3);
            if (!PortalShape.isEmpty($$5)) {
                if (!FRAME.test($$5, p_374084_, $$3)) break;
                return $$4;
            }
            BlockState $$6 = p_374084_.getBlockState($$3.move(Direction.DOWN));
            if (!FRAME.test($$6, p_374084_, $$3)) break;
        }
        return 0;
    }

    private static int calculateHeight(BlockGetter p_374198_, BlockPos p_374414_, Direction p_374486_, int p_374126_, MutableInt p_374165_) {
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        int $$6 = PortalShape.getDistanceUntilTop(p_374198_, p_374414_, p_374486_, $$5, p_374126_, p_374165_);
        if ($$6 < 3 || $$6 > 21 || !PortalShape.hasTopFrame(p_374198_, p_374414_, p_374486_, $$5, p_374126_, $$6)) {
            return 0;
        }
        return $$6;
    }

    private static boolean hasTopFrame(BlockGetter p_374223_, BlockPos p_374398_, Direction p_374129_, BlockPos.MutableBlockPos p_77731_, int p_77732_, int p_374112_) {
        for (int $$6 = 0; $$6 < p_77732_; ++$$6) {
            BlockPos.MutableBlockPos $$7 = p_77731_.set(p_374398_).move(Direction.UP, p_374112_).move(p_374129_, $$6);
            if (FRAME.test(p_374223_.getBlockState($$7), p_374223_, $$7)) continue;
            return false;
        }
        return true;
    }

    private static int getDistanceUntilTop(BlockGetter p_374443_, BlockPos p_374231_, Direction p_374062_, BlockPos.MutableBlockPos p_77729_, int p_374313_, MutableInt p_374330_) {
        for (int $$6 = 0; $$6 < 21; ++$$6) {
            p_77729_.set(p_374231_).move(Direction.UP, $$6).move(p_374062_, -1);
            if (!FRAME.test(p_374443_.getBlockState(p_77729_), p_374443_, p_77729_)) {
                return $$6;
            }
            p_77729_.set(p_374231_).move(Direction.UP, $$6).move(p_374062_, p_374313_);
            if (!FRAME.test(p_374443_.getBlockState(p_77729_), p_374443_, p_77729_)) {
                return $$6;
            }
            for (int $$7 = 0; $$7 < p_374313_; ++$$7) {
                p_77729_.set(p_374231_).move(Direction.UP, $$6).move(p_374062_, $$7);
                BlockState $$8 = p_374443_.getBlockState(p_77729_);
                if (!PortalShape.isEmpty($$8)) {
                    return $$6;
                }
                if (!$$8.is(Blocks.NETHER_PORTAL)) continue;
                p_374330_.increment();
            }
        }
        return 21;
    }

    private static boolean isEmpty(BlockState p_77718_) {
        return p_77718_.isAir() || p_77718_.is(BlockTags.FIRE) || p_77718_.is(Blocks.NETHER_PORTAL);
    }

    public boolean isValid() {
        return this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks(LevelAccessor p_374419_) {
        BlockState $$1 = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue(NetherPortalBlock.AXIS, this.axis);
        BlockPos.betweenClosed(this.bottomLeft, this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(p_374024_ -> p_374419_.setBlock((BlockPos)p_374024_, $$1, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vec3 getRelativePosition(BlockUtil.FoundRectangle p_77739_, Direction.Axis p_77740_, Vec3 p_77741_, EntityDimensions p_77742_) {
        double $$12;
        double $$9;
        double $$4 = (double)p_77739_.axis1Size - (double)p_77742_.width();
        double $$5 = (double)p_77739_.axis2Size - (double)p_77742_.height();
        BlockPos $$6 = p_77739_.minCorner;
        if ($$4 > 0.0) {
            double $$7 = (double)$$6.get(p_77740_) + (double)p_77742_.width() / 2.0;
            double $$8 = Mth.clamp(Mth.inverseLerp(p_77741_.get(p_77740_) - $$7, 0.0, $$4), 0.0, 1.0);
        } else {
            $$9 = 0.5;
        }
        if ($$5 > 0.0) {
            Direction.Axis $$10 = Direction.Axis.Y;
            double $$11 = Mth.clamp(Mth.inverseLerp(p_77741_.get($$10) - (double)$$6.get($$10), 0.0, $$5), 0.0, 1.0);
        } else {
            $$12 = 0.0;
        }
        Direction.Axis $$13 = p_77740_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double $$14 = p_77741_.get($$13) - ((double)$$6.get($$13) + 0.5);
        return new Vec3($$9, $$12, $$14);
    }

    public static Vec3 findCollisionFreePosition(Vec3 p_260315_, ServerLevel p_259704_, Entity p_259626_, EntityDimensions p_259816_) {
        if (p_259816_.width() > 4.0f || p_259816_.height() > 4.0f) {
            return p_260315_;
        }
        double $$4 = (double)p_259816_.height() / 2.0;
        Vec3 $$5 = p_260315_.add(0.0, $$4, 0.0);
        VoxelShape $$6 = Shapes.create(AABB.ofSize($$5, p_259816_.width(), 0.0, p_259816_.width()).expandTowards(0.0, 1.0, 0.0).inflate(1.0E-6));
        Optional<Vec3> $$7 = p_259704_.findFreePosition(p_259626_, $$6, $$5, p_259816_.width(), p_259816_.height(), p_259816_.width());
        Optional<Vec3> $$8 = $$7.map(p_259019_ -> p_259019_.subtract(0.0, $$4, 0.0));
        return $$8.orElse(p_260315_);
    }
}

