/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WalkNodeEvaluator
extends NodeEvaluator {
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    private final Long2ObjectMap<PathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();
    private final Node[] reusableNeighbors = new Node[Direction.Plane.HORIZONTAL.length()];

    @Override
    public void prepare(PathNavigationRegion p_77620_, Mob p_77621_) {
        super.prepare(p_77620_, p_77621_);
        p_77621_.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypesByPosCacheByMob.clear();
        this.collisionCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        BlockPos.MutableBlockPos $$0 = new BlockPos.MutableBlockPos();
        int $$1 = this.mob.getBlockY();
        BlockState $$2 = this.currentContext.getBlockState($$0.set(this.mob.getX(), (double)$$1, this.mob.getZ()));
        if (this.mob.canStandOnFluid($$2.getFluidState())) {
            while (this.mob.canStandOnFluid($$2.getFluidState())) {
                $$2 = this.currentContext.getBlockState($$0.set(this.mob.getX(), (double)(++$$1), this.mob.getZ()));
            }
            --$$1;
        } else if (this.canFloat() && this.mob.isInWater()) {
            while ($$2.is(Blocks.WATER) || $$2.getFluidState() == Fluids.WATER.getSource(false)) {
                $$2 = this.currentContext.getBlockState($$0.set(this.mob.getX(), (double)(++$$1), this.mob.getZ()));
            }
            --$$1;
        } else if (this.mob.onGround()) {
            $$1 = Mth.floor(this.mob.getY() + 0.5);
        } else {
            $$0.set(this.mob.getX(), this.mob.getY() + 1.0, this.mob.getZ());
            while ($$0.getY() > this.currentContext.level().getMinY()) {
                $$1 = $$0.getY();
                $$0.setY($$0.getY() - 1);
                BlockState $$3 = this.currentContext.getBlockState($$0);
                if ($$3.isAir() || $$3.isPathfindable(PathComputationType.LAND)) continue;
                break;
            }
        }
        BlockPos $$4 = this.mob.blockPosition();
        if (!this.canStartAt($$0.set($$4.getX(), $$1, $$4.getZ()))) {
            AABB $$5 = this.mob.getBoundingBox();
            if (this.canStartAt($$0.set($$5.minX, (double)$$1, $$5.minZ)) || this.canStartAt($$0.set($$5.minX, (double)$$1, $$5.maxZ)) || this.canStartAt($$0.set($$5.maxX, (double)$$1, $$5.minZ)) || this.canStartAt($$0.set($$5.maxX, (double)$$1, $$5.maxZ))) {
                return this.getStartNode($$0);
            }
        }
        return this.getStartNode(new BlockPos($$4.getX(), $$1, $$4.getZ()));
    }

    protected Node getStartNode(BlockPos p_230632_) {
        Node $$1 = this.getNode(p_230632_);
        $$1.type = this.getCachedPathType($$1.x, $$1.y, $$1.z);
        $$1.costMalus = this.mob.getPathfindingMalus($$1.type);
        return $$1;
    }

    protected boolean canStartAt(BlockPos p_262596_) {
        PathType $$1 = this.getCachedPathType(p_262596_.getX(), p_262596_.getY(), p_262596_.getZ());
        return $$1 != PathType.OPEN && this.mob.getPathfindingMalus($$1) >= 0.0f;
    }

    @Override
    public Target getTarget(double p_326793_, double p_326919_, double p_326802_) {
        return this.getTargetNodeAt(p_326793_, p_326919_, p_326802_);
    }

    @Override
    public int getNeighbors(Node[] p_77640_, Node p_77641_) {
        int $$2 = 0;
        int $$3 = 0;
        PathType $$4 = this.getCachedPathType(p_77641_.x, p_77641_.y + 1, p_77641_.z);
        PathType $$5 = this.getCachedPathType(p_77641_.x, p_77641_.y, p_77641_.z);
        if (this.mob.getPathfindingMalus($$4) >= 0.0f && $$5 != PathType.STICKY_HONEY) {
            $$3 = Mth.floor(Math.max(1.0f, this.mob.maxUpStep()));
        }
        double $$6 = this.getFloorLevel(new BlockPos(p_77641_.x, p_77641_.y, p_77641_.z));
        for (Direction $$7 : Direction.Plane.HORIZONTAL) {
            Node $$8;
            this.reusableNeighbors[$$7.get2DDataValue()] = $$8 = this.findAcceptedNode(p_77641_.x + $$7.getStepX(), p_77641_.y, p_77641_.z + $$7.getStepZ(), $$3, $$6, $$7, $$5);
            if (!this.isNeighborValid($$8, p_77641_)) continue;
            p_77640_[$$2++] = $$8;
        }
        for (Direction $$9 : Direction.Plane.HORIZONTAL) {
            Node $$11;
            Direction $$10 = $$9.getClockWise();
            if (!this.isDiagonalValid(p_77641_, this.reusableNeighbors[$$9.get2DDataValue()], this.reusableNeighbors[$$10.get2DDataValue()]) || !this.isDiagonalValid($$11 = this.findAcceptedNode(p_77641_.x + $$9.getStepX() + $$10.getStepX(), p_77641_.y, p_77641_.z + $$9.getStepZ() + $$10.getStepZ(), $$3, $$6, $$9, $$5))) continue;
            p_77640_[$$2++] = $$11;
        }
        return $$2;
    }

    protected boolean isNeighborValid(@Nullable Node p_77627_, Node p_77628_) {
        return p_77627_ != null && !p_77627_.closed && (p_77627_.costMalus >= 0.0f || p_77628_.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(Node p_326907_, @Nullable Node p_326803_, @Nullable Node p_326821_) {
        if (p_326821_ == null || p_326803_ == null || p_326821_.y > p_326907_.y || p_326803_.y > p_326907_.y) {
            return false;
        }
        if (p_326803_.type == PathType.WALKABLE_DOOR || p_326821_.type == PathType.WALKABLE_DOOR) {
            return false;
        }
        boolean $$3 = p_326821_.type == PathType.FENCE && p_326803_.type == PathType.FENCE && (double)this.mob.getBbWidth() < 0.5;
        return (p_326821_.y < p_326907_.y || p_326821_.costMalus >= 0.0f || $$3) && (p_326803_.y < p_326907_.y || p_326803_.costMalus >= 0.0f || $$3);
    }

    protected boolean isDiagonalValid(@Nullable Node p_77630_) {
        if (p_77630_ == null || p_77630_.closed) {
            return false;
        }
        if (p_77630_.type == PathType.WALKABLE_DOOR) {
            return false;
        }
        return p_77630_.costMalus >= 0.0f;
    }

    private static boolean doesBlockHavePartialCollision(PathType p_326827_) {
        return p_326827_ == PathType.FENCE || p_326827_ == PathType.DOOR_WOOD_CLOSED || p_326827_ == PathType.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(Node p_77625_) {
        AABB $$1 = this.mob.getBoundingBox();
        Vec3 $$2 = new Vec3((double)p_77625_.x - this.mob.getX() + $$1.getXsize() / 2.0, (double)p_77625_.y - this.mob.getY() + $$1.getYsize() / 2.0, (double)p_77625_.z - this.mob.getZ() + $$1.getZsize() / 2.0);
        int $$3 = Mth.ceil($$2.length() / $$1.getSize());
        $$2 = $$2.scale(1.0f / (float)$$3);
        for (int $$4 = 1; $$4 <= $$3; ++$$4) {
            if (!this.hasCollisions($$1 = $$1.move($$2))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos p_164733_) {
        CollisionGetter $$1 = this.currentContext.level();
        if ((this.canFloat() || this.isAmphibious()) && $$1.getFluidState(p_164733_).is(FluidTags.WATER)) {
            return (double)p_164733_.getY() + 0.5;
        }
        return WalkNodeEvaluator.getFloorLevel($$1, p_164733_);
    }

    public static double getFloorLevel(BlockGetter p_77612_, BlockPos p_77613_) {
        BlockPos $$2 = p_77613_.below();
        VoxelShape $$3 = p_77612_.getBlockState($$2).getCollisionShape(p_77612_, $$2);
        return (double)$$2.getY() + ($$3.isEmpty() ? 0.0 : $$3.max(Direction.Axis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected Node findAcceptedNode(int p_164726_, int p_164727_, int p_164728_, int p_164729_, double p_164730_, Direction p_164731_, PathType p_326873_) {
        Node $$7 = null;
        BlockPos.MutableBlockPos $$8 = new BlockPos.MutableBlockPos();
        double $$9 = this.getFloorLevel($$8.set(p_164726_, p_164727_, p_164728_));
        if ($$9 - p_164730_ > this.getMobJumpHeight()) {
            return null;
        }
        PathType $$10 = this.getCachedPathType(p_164726_, p_164727_, p_164728_);
        float $$11 = this.mob.getPathfindingMalus($$10);
        if ($$11 >= 0.0f) {
            $$7 = this.getNodeAndUpdateCostToMax(p_164726_, p_164727_, p_164728_, $$10, $$11);
        }
        if (WalkNodeEvaluator.doesBlockHavePartialCollision(p_326873_) && $$7 != null && $$7.costMalus >= 0.0f && !this.canReachWithoutCollision($$7)) {
            $$7 = null;
        }
        if ($$10 == PathType.WALKABLE || this.isAmphibious() && $$10 == PathType.WATER) {
            return $$7;
        }
        if (($$7 == null || $$7.costMalus < 0.0f) && p_164729_ > 0 && ($$10 != PathType.FENCE || this.canWalkOverFences()) && $$10 != PathType.UNPASSABLE_RAIL && $$10 != PathType.TRAPDOOR && $$10 != PathType.POWDER_SNOW) {
            $$7 = this.tryJumpOn(p_164726_, p_164727_, p_164728_, p_164729_, p_164730_, p_164731_, p_326873_, $$8);
        } else if (!this.isAmphibious() && $$10 == PathType.WATER && !this.canFloat()) {
            $$7 = this.tryFindFirstNonWaterBelow(p_164726_, p_164727_, p_164728_, $$7);
        } else if ($$10 == PathType.OPEN) {
            $$7 = this.tryFindFirstGroundNodeBelow(p_164726_, p_164727_, p_164728_);
        } else if (WalkNodeEvaluator.doesBlockHavePartialCollision($$10) && $$7 == null) {
            $$7 = this.getClosedNode(p_164726_, p_164727_, p_164728_, $$10);
        }
        return $$7;
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.maxUpStep());
    }

    private Node getNodeAndUpdateCostToMax(int p_230620_, int p_230621_, int p_230622_, PathType p_326789_, float p_230624_) {
        Node $$5 = this.getNode(p_230620_, p_230621_, p_230622_);
        $$5.type = p_326789_;
        $$5.costMalus = Math.max($$5.costMalus, p_230624_);
        return $$5;
    }

    private Node getBlockedNode(int p_230628_, int p_230629_, int p_230630_) {
        Node $$3 = this.getNode(p_230628_, p_230629_, p_230630_);
        $$3.type = PathType.BLOCKED;
        $$3.costMalus = -1.0f;
        return $$3;
    }

    private Node getClosedNode(int p_326935_, int p_326904_, int p_326845_, PathType p_326820_) {
        Node $$4 = this.getNode(p_326935_, p_326904_, p_326845_);
        $$4.closed = true;
        $$4.type = p_326820_;
        $$4.costMalus = p_326820_.getMalus();
        return $$4;
    }

    @Nullable
    private Node tryJumpOn(int p_326914_, int p_326900_, int p_326886_, int p_326902_, double p_326800_, Direction p_326868_, PathType p_326831_, BlockPos.MutableBlockPos p_326839_) {
        Node $$8 = this.findAcceptedNode(p_326914_, p_326900_ + 1, p_326886_, p_326902_ - 1, p_326800_, p_326868_, p_326831_);
        if ($$8 == null) {
            return null;
        }
        if (this.mob.getBbWidth() >= 1.0f) {
            return $$8;
        }
        if ($$8.type != PathType.OPEN && $$8.type != PathType.WALKABLE) {
            return $$8;
        }
        double $$9 = (double)(p_326914_ - p_326868_.getStepX()) + 0.5;
        double $$10 = (double)(p_326886_ - p_326868_.getStepZ()) + 0.5;
        double $$11 = (double)this.mob.getBbWidth() / 2.0;
        AABB $$12 = new AABB($$9 - $$11, this.getFloorLevel(p_326839_.set($$9, (double)(p_326900_ + 1), $$10)) + 0.001, $$10 - $$11, $$9 + $$11, (double)this.mob.getBbHeight() + this.getFloorLevel(p_326839_.set((double)$$8.x, (double)$$8.y, (double)$$8.z)) - 0.002, $$10 + $$11);
        return this.hasCollisions($$12) ? null : $$8;
    }

    @Nullable
    private Node tryFindFirstNonWaterBelow(int p_326959_, int p_326927_, int p_326932_, @Nullable Node p_326880_) {
        --p_326927_;
        while (p_326927_ > this.mob.level().getMinY()) {
            PathType $$4 = this.getCachedPathType(p_326959_, p_326927_, p_326932_);
            if ($$4 != PathType.WATER) {
                return p_326880_;
            }
            p_326880_ = this.getNodeAndUpdateCostToMax(p_326959_, p_326927_, p_326932_, $$4, this.mob.getPathfindingMalus($$4));
            --p_326927_;
        }
        return p_326880_;
    }

    private Node tryFindFirstGroundNodeBelow(int p_326892_, int p_326901_, int p_326809_) {
        for (int $$3 = p_326901_ - 1; $$3 >= this.mob.level().getMinY(); --$$3) {
            if (p_326901_ - $$3 > this.mob.getMaxFallDistance()) {
                return this.getBlockedNode(p_326892_, $$3, p_326809_);
            }
            PathType $$4 = this.getCachedPathType(p_326892_, $$3, p_326809_);
            float $$5 = this.mob.getPathfindingMalus($$4);
            if ($$4 == PathType.OPEN) continue;
            if ($$5 >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(p_326892_, $$3, p_326809_, $$4, $$5);
            }
            return this.getBlockedNode(p_326892_, $$3, p_326809_);
        }
        return this.getBlockedNode(p_326892_, p_326901_, p_326809_);
    }

    private boolean hasCollisions(AABB p_77635_) {
        return this.collisionCache.computeIfAbsent((Object)p_77635_, p_330163_ -> !this.currentContext.level().noCollision(this.mob, p_77635_));
    }

    protected PathType getCachedPathType(int p_326926_, int p_326795_, int p_326824_) {
        return (PathType)((Object)this.pathTypesByPosCacheByMob.computeIfAbsent(BlockPos.asLong(p_326926_, p_326795_, p_326824_), p_330161_ -> this.getPathTypeOfMob(this.currentContext, p_326926_, p_326795_, p_326824_, this.mob)));
    }

    @Override
    public PathType getPathTypeOfMob(PathfindingContext p_330551_, int p_326939_, int p_326943_, int p_326876_, Mob p_326786_) {
        Set<PathType> $$5 = this.getPathTypeWithinMobBB(p_330551_, p_326939_, p_326943_, p_326876_);
        if ($$5.contains((Object)PathType.FENCE)) {
            return PathType.FENCE;
        }
        if ($$5.contains((Object)PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType $$6 = PathType.BLOCKED;
        for (PathType $$7 : $$5) {
            if (p_326786_.getPathfindingMalus($$7) < 0.0f) {
                return $$7;
            }
            if (!(p_326786_.getPathfindingMalus($$7) >= p_326786_.getPathfindingMalus($$6))) continue;
            $$6 = $$7;
        }
        if (this.entityWidth <= 1 && $$6 != PathType.OPEN && p_326786_.getPathfindingMalus($$6) == 0.0f && this.getPathType(p_330551_, p_326939_, p_326943_, p_326876_) == PathType.OPEN) {
            return PathType.OPEN;
        }
        return $$6;
    }

    public Set<PathType> getPathTypeWithinMobBB(PathfindingContext p_331617_, int p_326916_, int p_326906_, int p_326848_) {
        EnumSet<PathType> $$4 = EnumSet.noneOf(PathType.class);
        for (int $$5 = 0; $$5 < this.entityWidth; ++$$5) {
            for (int $$6 = 0; $$6 < this.entityHeight; ++$$6) {
                for (int $$7 = 0; $$7 < this.entityDepth; ++$$7) {
                    int $$8 = $$5 + p_326916_;
                    int $$9 = $$6 + p_326906_;
                    int $$10 = $$7 + p_326848_;
                    PathType $$11 = this.getPathType(p_331617_, $$8, $$9, $$10);
                    BlockPos $$12 = this.mob.blockPosition();
                    boolean $$13 = this.canPassDoors();
                    if ($$11 == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && $$13) {
                        $$11 = PathType.WALKABLE_DOOR;
                    }
                    if ($$11 == PathType.DOOR_OPEN && !$$13) {
                        $$11 = PathType.BLOCKED;
                    }
                    if ($$11 == PathType.RAIL && this.getPathType(p_331617_, $$12.getX(), $$12.getY(), $$12.getZ()) != PathType.RAIL && this.getPathType(p_331617_, $$12.getX(), $$12.getY() - 1, $$12.getZ()) != PathType.RAIL) {
                        $$11 = PathType.UNPASSABLE_RAIL;
                    }
                    $$4.add($$11);
                }
            }
        }
        return $$4;
    }

    @Override
    public PathType getPathType(PathfindingContext p_330217_, int p_326856_, int p_326857_, int p_326859_) {
        return WalkNodeEvaluator.getPathTypeStatic(p_330217_, new BlockPos.MutableBlockPos(p_326856_, p_326857_, p_326859_));
    }

    public static PathType getPathTypeStatic(Mob p_332010_, BlockPos p_330520_) {
        return WalkNodeEvaluator.getPathTypeStatic(new PathfindingContext(p_332010_.level(), p_332010_), p_330520_.mutable());
    }

    public static PathType getPathTypeStatic(PathfindingContext p_330755_, BlockPos.MutableBlockPos p_331020_) {
        int $$4;
        int $$3;
        int $$2 = p_331020_.getX();
        PathType $$5 = p_330755_.getPathTypeFromState($$2, $$3 = p_331020_.getY(), $$4 = p_331020_.getZ());
        if ($$5 != PathType.OPEN || $$3 < p_330755_.level().getMinY() + 1) {
            return $$5;
        }
        return switch (p_330755_.getPathTypeFromState($$2, $$3 - 1, $$4)) {
            case PathType.OPEN, PathType.WATER, PathType.LAVA, PathType.WALKABLE -> PathType.OPEN;
            case PathType.DAMAGE_FIRE -> PathType.DAMAGE_FIRE;
            case PathType.DAMAGE_OTHER -> PathType.DAMAGE_OTHER;
            case PathType.STICKY_HONEY -> PathType.STICKY_HONEY;
            case PathType.POWDER_SNOW -> PathType.DANGER_POWDER_SNOW;
            case PathType.DAMAGE_CAUTIOUS -> PathType.DAMAGE_CAUTIOUS;
            case PathType.TRAPDOOR -> PathType.DANGER_TRAPDOOR;
            default -> WalkNodeEvaluator.checkNeighbourBlocks(p_330755_, $$2, $$3, $$4, PathType.WALKABLE);
        };
    }

    public static PathType checkNeighbourBlocks(PathfindingContext p_331893_, int p_332169_, int p_330433_, int p_331506_, PathType p_326944_) {
        for (int $$5 = -1; $$5 <= 1; ++$$5) {
            for (int $$6 = -1; $$6 <= 1; ++$$6) {
                for (int $$7 = -1; $$7 <= 1; ++$$7) {
                    if ($$5 == 0 && $$7 == 0) continue;
                    PathType $$8 = p_331893_.getPathTypeFromState(p_332169_ + $$5, p_330433_ + $$6, p_331506_ + $$7);
                    if ($$8 == PathType.DAMAGE_OTHER) {
                        return PathType.DANGER_OTHER;
                    }
                    if ($$8 == PathType.DAMAGE_FIRE || $$8 == PathType.LAVA) {
                        return PathType.DANGER_FIRE;
                    }
                    if ($$8 == PathType.WATER) {
                        return PathType.WATER_BORDER;
                    }
                    if ($$8 != PathType.DAMAGE_CAUTIOUS) continue;
                    return PathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return p_326944_;
    }

    protected static PathType getPathTypeFromState(BlockGetter p_77644_, BlockPos p_77645_) {
        BlockState $$2 = p_77644_.getBlockState(p_77645_);
        Block $$3 = $$2.getBlock();
        if ($$2.isAir()) {
            return PathType.OPEN;
        }
        if ($$2.is(BlockTags.TRAPDOORS) || $$2.is(Blocks.LILY_PAD) || $$2.is(Blocks.BIG_DRIPLEAF)) {
            return PathType.TRAPDOOR;
        }
        if ($$2.is(Blocks.POWDER_SNOW)) {
            return PathType.POWDER_SNOW;
        }
        if ($$2.is(Blocks.CACTUS) || $$2.is(Blocks.SWEET_BERRY_BUSH)) {
            return PathType.DAMAGE_OTHER;
        }
        if ($$2.is(Blocks.HONEY_BLOCK)) {
            return PathType.STICKY_HONEY;
        }
        if ($$2.is(Blocks.COCOA)) {
            return PathType.COCOA;
        }
        if ($$2.is(Blocks.WITHER_ROSE) || $$2.is(Blocks.POINTED_DRIPSTONE)) {
            return PathType.DAMAGE_CAUTIOUS;
        }
        FluidState $$4 = $$2.getFluidState();
        if ($$4.is(FluidTags.LAVA)) {
            return PathType.LAVA;
        }
        if (WalkNodeEvaluator.isBurningBlock($$2)) {
            return PathType.DAMAGE_FIRE;
        }
        if ($$3 instanceof DoorBlock) {
            DoorBlock $$5 = (DoorBlock)$$3;
            if ($$2.getValue(DoorBlock.OPEN).booleanValue()) {
                return PathType.DOOR_OPEN;
            }
            return $$5.type().canOpenByHand() ? PathType.DOOR_WOOD_CLOSED : PathType.DOOR_IRON_CLOSED;
        }
        if ($$3 instanceof BaseRailBlock) {
            return PathType.RAIL;
        }
        if ($$3 instanceof LeavesBlock) {
            return PathType.LEAVES;
        }
        if ($$2.is(BlockTags.FENCES) || $$2.is(BlockTags.WALLS) || $$3 instanceof FenceGateBlock && !$$2.getValue(FenceGateBlock.OPEN).booleanValue()) {
            return PathType.FENCE;
        }
        if (!$$2.isPathfindable(PathComputationType.LAND)) {
            return PathType.BLOCKED;
        }
        if ($$4.is(FluidTags.WATER)) {
            return PathType.WATER;
        }
        return PathType.OPEN;
    }
}

