/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int UNSET_HEIGHT = Integer.MIN_VALUE;

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext p_227239_, Holder<StructureTemplatePool> p_227240_, Optional<ResourceLocation> p_227241_, int p_227242_, BlockPos p_227243_, boolean p_227244_, Optional<Heightmap.Types> p_227245_, int p_227246_, PoolAliasLookup p_307522_, DimensionPadding p_348489_, LiquidSettings p_352161_) {
        BlockPos $$23;
        RegistryAccess $$11 = p_227239_.registryAccess();
        ChunkGenerator $$12 = p_227239_.chunkGenerator();
        StructureTemplateManager $$13 = p_227239_.structureTemplateManager();
        LevelHeightAccessor $$14 = p_227239_.heightAccessor();
        WorldgenRandom $$15 = p_227239_.random();
        HolderLookup.RegistryLookup $$16 = $$11.lookupOrThrow(Registries.TEMPLATE_POOL);
        Rotation $$17 = Rotation.getRandom($$15);
        StructureTemplatePool $$18 = p_227240_.unwrapKey().flatMap(arg_0 -> JigsawPlacement.lambda$addPieces$0((Registry)$$16, p_307522_, arg_0)).orElse(p_227240_.value());
        StructurePoolElement $$19 = $$18.getRandomTemplate($$15);
        if ($$19 == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (p_227241_.isPresent()) {
            ResourceLocation $$20 = p_227241_.get();
            Optional<BlockPos> $$21 = JigsawPlacement.getRandomNamedJigsaw($$19, $$20, p_227243_, $$17, $$13, $$15);
            if ($$21.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)$$20, (Object)p_227240_.unwrapKey().map(p_248484_ -> p_248484_.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPos $$22 = $$21.get();
        } else {
            $$23 = p_227243_;
        }
        BlockPos $$24 = $$23.subtract(p_227243_);
        BlockPos $$25 = p_227243_.subtract($$24);
        PoolElementStructurePiece $$26 = new PoolElementStructurePiece($$13, $$19, $$25, $$19.getGroundLevelDelta(), $$17, $$19.getBoundingBox($$13, $$25, $$17), p_352161_);
        BoundingBox $$27 = $$26.getBoundingBox();
        int $$28 = ($$27.maxX() + $$27.minX()) / 2;
        int $$29 = ($$27.maxZ() + $$27.minZ()) / 2;
        int $$30 = p_227245_.isEmpty() ? $$25.getY() : p_227243_.getY() + $$12.getFirstFreeHeight($$28, $$29, p_227245_.get(), $$14, p_227239_.randomState());
        int $$31 = $$27.minY() + $$26.getGroundLevelDelta();
        $$26.move(0, $$30 - $$31, 0);
        if (JigsawPlacement.isStartTooCloseToWorldHeightLimits($$14, p_348489_, $$26.getBoundingBox())) {
            LOGGER.debug("Center piece {} with bounding box {} does not fit dimension padding {}", new Object[]{$$19, $$26.getBoundingBox(), p_348489_});
            return Optional.empty();
        }
        int $$32 = $$30 + $$24.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos($$28, $$32, $$29), arg_0 -> JigsawPlacement.lambda$addPieces$2($$26, p_227242_, $$28, p_227246_, $$32, $$14, p_348489_, $$29, $$27, p_227239_, p_227244_, $$12, $$13, $$15, (Registry)$$16, p_307522_, p_352161_, arg_0)));
    }

    private static boolean isStartTooCloseToWorldHeightLimits(LevelHeightAccessor p_383116_, DimensionPadding p_382835_, BoundingBox p_383171_) {
        if (p_382835_ == DimensionPadding.ZERO) {
            return false;
        }
        int $$3 = p_383116_.getMinY() + p_382835_.bottom();
        int $$4 = p_383116_.getMaxY() - p_382835_.top();
        return p_383171_.minY() < $$3 || p_383171_.maxY() > $$4;
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement p_227248_, ResourceLocation p_227249_, BlockPos p_227250_, Rotation p_227251_, StructureTemplateManager p_227252_, WorldgenRandom p_227253_) {
        List<StructureTemplate.JigsawBlockInfo> $$6 = p_227248_.getShuffledJigsawBlocks(p_227252_, p_227250_, p_227251_, p_227253_);
        for (StructureTemplate.JigsawBlockInfo $$7 : $$6) {
            if (!p_227249_.equals($$7.name())) continue;
            return Optional.of($$7.info().pos());
        }
        return Optional.empty();
    }

    private static void addPieces(RandomState p_227211_, int p_227212_, boolean p_227213_, ChunkGenerator p_227214_, StructureTemplateManager p_227215_, LevelHeightAccessor p_227216_, RandomSource p_227217_, Registry<StructureTemplatePool> p_227218_, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> p_227220_, VoxelShape p_227221_, PoolAliasLookup p_307210_, LiquidSettings p_352331_) {
        Placer $$13 = new Placer(p_227218_, p_227212_, p_227214_, p_227215_, p_227220_, p_227217_);
        $$13.tryPlacingChildren(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0, p_227213_, p_227216_, p_227211_, p_307210_, p_352331_);
        while ($$13.placing.hasNext()) {
            PieceState $$14 = (PieceState)$$13.placing.next();
            $$13.tryPlacingChildren($$14.piece, $$14.free, $$14.depth, p_227213_, p_227216_, p_227211_, p_307210_, p_352331_);
        }
    }

    public static boolean generateJigsaw(ServerLevel p_227204_, Holder<StructureTemplatePool> p_227205_, ResourceLocation p_227206_, int p_227207_, BlockPos p_227208_, boolean p_227209_) {
        ChunkGenerator $$6 = p_227204_.getChunkSource().getGenerator();
        StructureTemplateManager $$7 = p_227204_.getStructureManager();
        StructureManager $$8 = p_227204_.structureManager();
        RandomSource $$9 = p_227204_.getRandom();
        Structure.GenerationContext $$10 = new Structure.GenerationContext(p_227204_.registryAccess(), $$6, $$6.getBiomeSource(), p_227204_.getChunkSource().randomState(), $$7, p_227204_.getSeed(), new ChunkPos(p_227208_), p_227204_, p_227255_ -> true);
        Optional<Structure.GenerationStub> $$11 = JigsawPlacement.addPieces($$10, p_227205_, Optional.of(p_227206_), p_227207_, p_227208_, false, Optional.empty(), 128, PoolAliasLookup.EMPTY, JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS);
        if ($$11.isPresent()) {
            StructurePiecesBuilder $$12 = $$11.get().getPiecesBuilder();
            for (StructurePiece $$13 : $$12.build().pieces()) {
                if (!($$13 instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece $$14 = (PoolElementStructurePiece)$$13;
                $$14.place(p_227204_, $$8, $$6, $$9, BoundingBox.infinite(), p_227208_, p_227209_);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$addPieces$2(PoolElementStructurePiece p_351997_, int p_351998_, int p_351999_, int p_352000_, int p_352001_, LevelHeightAccessor p_352002_, DimensionPadding p_352003_, int p_352004_, BoundingBox p_352005_, Structure.GenerationContext p_352006_, boolean p_352007_, ChunkGenerator p_352008_, StructureTemplateManager p_352009_, WorldgenRandom p_352010_, Registry p_352011_, PoolAliasLookup p_352012_, LiquidSettings p_352013_, StructurePiecesBuilder p_352014_) {
        ArrayList $$18 = Lists.newArrayList();
        $$18.add(p_351997_);
        if (p_351998_ <= 0) {
            return;
        }
        AABB $$19 = new AABB(p_351999_ - p_352000_, Math.max(p_352001_ - p_352000_, p_352002_.getMinY() + p_352003_.bottom()), p_352004_ - p_352000_, p_351999_ + p_352000_ + 1, Math.min(p_352001_ + p_352000_ + 1, p_352002_.getMaxY() + 1 - p_352003_.top()), p_352004_ + p_352000_ + 1);
        VoxelShape $$20 = Shapes.join(Shapes.create($$19), Shapes.create(AABB.of(p_352005_)), BooleanOp.ONLY_FIRST);
        JigsawPlacement.addPieces(p_352006_.randomState(), p_351998_, p_352007_, p_352008_, p_352009_, p_352002_, p_352010_, p_352011_, p_351997_, $$18, $$20, p_352012_, p_352013_);
        $$18.forEach(p_352014_::addPiece);
    }

    private static /* synthetic */ Optional lambda$addPieces$0(Registry p_314913_, PoolAliasLookup p_314914_, ResourceKey p_314915_) {
        return p_314913_.getOptional(p_314914_.lookup(p_314915_));
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> p_227258_, int p_227259_, ChunkGenerator p_227260_, StructureTemplateManager p_227261_, List<? super PoolElementStructurePiece> p_227262_, RandomSource p_227263_) {
            this.pools = p_227258_;
            this.maxDepth = p_227259_;
            this.chunkGenerator = p_227260_;
            this.structureTemplateManager = p_227261_;
            this.pieces = p_227262_;
            this.random = p_227263_;
        }

        void tryPlacingChildren(PoolElementStructurePiece p_227265_, MutableObject<VoxelShape> p_227266_, int p_227267_, boolean p_227268_, LevelHeightAccessor p_227269_, RandomState p_227270_, PoolAliasLookup p_307643_, LiquidSettings p_352442_) {
            StructurePoolElement $$8 = p_227265_.getElement();
            BlockPos $$9 = p_227265_.getPosition();
            Rotation $$10 = p_227265_.getRotation();
            StructureTemplatePool.Projection $$11 = $$8.getProjection();
            boolean $$12 = $$11 == StructureTemplatePool.Projection.RIGID;
            MutableObject $$13 = new MutableObject();
            BoundingBox $$14 = p_227265_.getBoundingBox();
            int $$15 = $$14.minY();
            block0: for (StructureTemplate.JigsawBlockInfo $$16 : $$8.getShuffledJigsawBlocks(this.structureTemplateManager, $$9, $$10, this.random)) {
                StructurePoolElement $$32;
                MutableObject<VoxelShape> $$29;
                StructureTemplate.StructureBlockInfo $$17 = $$16.info();
                Direction $$18 = JigsawBlock.getFrontFacing($$17.state());
                BlockPos $$19 = $$17.pos();
                BlockPos $$20 = $$19.relative($$18);
                int $$21 = $$19.getY() - $$15;
                int $$22 = Integer.MIN_VALUE;
                ResourceKey<StructureTemplatePool> $$23 = p_307643_.lookup($$16.pool());
                Optional $$24 = this.pools.get($$23);
                if ($$24.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$23.location());
                    continue;
                }
                Holder $$25 = (Holder)$$24.get();
                if (((StructureTemplatePool)$$25.value()).size() == 0 && !$$25.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)$$23.location());
                    continue;
                }
                Holder<StructureTemplatePool> $$26 = ((StructureTemplatePool)$$25.value()).getFallback();
                if ($$26.value().size() == 0 && !$$26.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)$$26.unwrapKey().map(p_255599_ -> p_255599_.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean $$27 = $$14.isInside($$20);
                if ($$27) {
                    MutableObject $$28 = $$13;
                    if ($$13.getValue() == null) {
                        $$13.setValue((Object)Shapes.create(AABB.of($$14)));
                    }
                } else {
                    $$29 = p_227266_;
                }
                ArrayList $$30 = Lists.newArrayList();
                if (p_227267_ != this.maxDepth) {
                    $$30.addAll(((StructureTemplatePool)$$25.value()).getShuffledTemplates(this.random));
                }
                $$30.addAll($$26.value().getShuffledTemplates(this.random));
                int $$31 = $$16.placementPriority();
                Iterator iterator = $$30.iterator();
                while (iterator.hasNext() && ($$32 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation $$33 : Rotation.getShuffled(this.random)) {
                        int $$37;
                        List<StructureTemplate.JigsawBlockInfo> $$34 = $$32.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, $$33, this.random);
                        BoundingBox $$35 = $$32.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, $$33);
                        if (!p_227268_ || $$35.getYSpan() > 16) {
                            boolean $$36 = false;
                        } else {
                            $$37 = $$34.stream().mapToInt(p_379284_ -> {
                                StructureTemplate.StructureBlockInfo $$3 = p_379284_.info();
                                if (!$$35.isInside($$3.pos().relative(JigsawBlock.getFrontFacing($$3.state())))) {
                                    return 0;
                                }
                                ResourceKey<StructureTemplatePool> $$4 = p_307643_.lookup(p_379284_.pool());
                                Optional $$5 = this.pools.get($$4);
                                Optional<Holder> $$6 = $$5.map(p_255600_ -> ((StructureTemplatePool)p_255600_.value()).getFallback());
                                int $$7 = $$5.map(p_255596_ -> ((StructureTemplatePool)p_255596_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                int $$8 = $$6.map(p_255601_ -> ((StructureTemplatePool)p_255601_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                                return Math.max($$7, $$8);
                            }).max().orElse(0);
                        }
                        for (StructureTemplate.JigsawBlockInfo $$38 : $$34) {
                            int $$59;
                            int $$55;
                            int $$48;
                            if (!JigsawBlock.canAttach($$16, $$38)) continue;
                            BlockPos $$39 = $$38.info().pos();
                            BlockPos $$40 = $$20.subtract($$39);
                            BoundingBox $$41 = $$32.getBoundingBox(this.structureTemplateManager, $$40, $$33);
                            int $$42 = $$41.minY();
                            StructureTemplatePool.Projection $$43 = $$32.getProjection();
                            boolean $$44 = $$43 == StructureTemplatePool.Projection.RIGID;
                            int $$45 = $$39.getY();
                            int $$46 = $$21 - $$45 + JigsawBlock.getFrontFacing($$17.state()).getStepY();
                            if ($$12 && $$44) {
                                int $$47 = $$15 + $$46;
                            } else {
                                if ($$22 == Integer.MIN_VALUE) {
                                    $$22 = this.chunkGenerator.getFirstFreeHeight($$19.getX(), $$19.getZ(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                $$48 = $$22 - $$45;
                            }
                            int $$49 = $$48 - $$42;
                            BoundingBox $$50 = $$41.moved(0, $$49, 0);
                            BlockPos $$51 = $$40.offset(0, $$49, 0);
                            if ($$37 > 0) {
                                int $$52 = Math.max($$37 + 1, $$50.maxY() - $$50.minY());
                                $$50.encapsulate(new BlockPos($$50.minX(), $$50.minY() + $$52, $$50.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)$$29.getValue(), Shapes.create(AABB.of($$50).deflate(0.25)), BooleanOp.ONLY_SECOND)) continue;
                            $$29.setValue((Object)Shapes.joinUnoptimized((VoxelShape)$$29.getValue(), Shapes.create(AABB.of($$50)), BooleanOp.ONLY_FIRST));
                            int $$53 = p_227265_.getGroundLevelDelta();
                            if ($$44) {
                                int $$54 = $$53 - $$46;
                            } else {
                                $$55 = $$32.getGroundLevelDelta();
                            }
                            PoolElementStructurePiece $$56 = new PoolElementStructurePiece(this.structureTemplateManager, $$32, $$51, $$55, $$33, $$50, p_352442_);
                            if ($$12) {
                                int $$57 = $$15 + $$21;
                            } else if ($$44) {
                                int $$58 = $$48 + $$45;
                            } else {
                                if ($$22 == Integer.MIN_VALUE) {
                                    $$22 = this.chunkGenerator.getFirstFreeHeight($$19.getX(), $$19.getZ(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                $$59 = $$22 + $$46 / 2;
                            }
                            p_227265_.addJunction(new JigsawJunction($$20.getX(), (int)($$59 - $$21 + $$53), $$20.getZ(), $$46, $$43));
                            $$56.addJunction(new JigsawJunction($$19.getX(), $$59 - $$45 + $$55, $$19.getZ(), -$$46, $$11));
                            this.pieces.add($$56);
                            if (p_227267_ + 1 > this.maxDepth) continue block0;
                            PieceState $$60 = new PieceState($$56, $$29, p_227267_ + 1);
                            this.placing.add($$60, $$31);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

