/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface VibrationSystem {
    public static final List<ResourceKey<GameEvent>> RESONANCE_EVENTS = List.of(GameEvent.RESONATE_1.key(), GameEvent.RESONATE_2.key(), GameEvent.RESONATE_3.key(), GameEvent.RESONATE_4.key(), GameEvent.RESONATE_5.key(), GameEvent.RESONATE_6.key(), GameEvent.RESONATE_7.key(), GameEvent.RESONATE_8.key(), GameEvent.RESONATE_9.key(), GameEvent.RESONATE_10.key(), GameEvent.RESONATE_11.key(), GameEvent.RESONATE_12.key(), GameEvent.RESONATE_13.key(), GameEvent.RESONATE_14.key(), GameEvent.RESONATE_15.key());
    public static final int NO_VIBRATION_FREQUENCY = 0;
    public static final ToIntFunction<ResourceKey<GameEvent>> VIBRATION_FREQUENCY_FOR_EVENT = (ToIntFunction)Util.make(new Reference2IntOpenHashMap(), p_316653_ -> {
        p_316653_.defaultReturnValue(0);
        p_316653_.put(GameEvent.STEP.key(), 1);
        p_316653_.put(GameEvent.SWIM.key(), 1);
        p_316653_.put(GameEvent.FLAP.key(), 1);
        p_316653_.put(GameEvent.PROJECTILE_LAND.key(), 2);
        p_316653_.put(GameEvent.HIT_GROUND.key(), 2);
        p_316653_.put(GameEvent.SPLASH.key(), 2);
        p_316653_.put(GameEvent.ITEM_INTERACT_FINISH.key(), 3);
        p_316653_.put(GameEvent.PROJECTILE_SHOOT.key(), 3);
        p_316653_.put(GameEvent.INSTRUMENT_PLAY.key(), 3);
        p_316653_.put(GameEvent.ENTITY_ACTION.key(), 4);
        p_316653_.put(GameEvent.ELYTRA_GLIDE.key(), 4);
        p_316653_.put(GameEvent.UNEQUIP.key(), 4);
        p_316653_.put(GameEvent.ENTITY_DISMOUNT.key(), 5);
        p_316653_.put(GameEvent.EQUIP.key(), 5);
        p_316653_.put(GameEvent.ENTITY_INTERACT.key(), 6);
        p_316653_.put(GameEvent.SHEAR.key(), 6);
        p_316653_.put(GameEvent.ENTITY_MOUNT.key(), 6);
        p_316653_.put(GameEvent.ENTITY_DAMAGE.key(), 7);
        p_316653_.put(GameEvent.DRINK.key(), 8);
        p_316653_.put(GameEvent.EAT.key(), 8);
        p_316653_.put(GameEvent.CONTAINER_CLOSE.key(), 9);
        p_316653_.put(GameEvent.BLOCK_CLOSE.key(), 9);
        p_316653_.put(GameEvent.BLOCK_DEACTIVATE.key(), 9);
        p_316653_.put(GameEvent.BLOCK_DETACH.key(), 9);
        p_316653_.put(GameEvent.CONTAINER_OPEN.key(), 10);
        p_316653_.put(GameEvent.BLOCK_OPEN.key(), 10);
        p_316653_.put(GameEvent.BLOCK_ACTIVATE.key(), 10);
        p_316653_.put(GameEvent.BLOCK_ATTACH.key(), 10);
        p_316653_.put(GameEvent.PRIME_FUSE.key(), 10);
        p_316653_.put(GameEvent.NOTE_BLOCK_PLAY.key(), 10);
        p_316653_.put(GameEvent.BLOCK_CHANGE.key(), 11);
        p_316653_.put(GameEvent.BLOCK_DESTROY.key(), 12);
        p_316653_.put(GameEvent.FLUID_PICKUP.key(), 12);
        p_316653_.put(GameEvent.BLOCK_PLACE.key(), 13);
        p_316653_.put(GameEvent.FLUID_PLACE.key(), 13);
        p_316653_.put(GameEvent.ENTITY_PLACE.key(), 14);
        p_316653_.put(GameEvent.LIGHTNING_STRIKE.key(), 14);
        p_316653_.put(GameEvent.TELEPORT.key(), 14);
        p_316653_.put(GameEvent.ENTITY_DIE.key(), 15);
        p_316653_.put(GameEvent.EXPLODE.key(), 15);
        for (int $$1 = 1; $$1 <= 15; ++$$1) {
            p_316653_.put(VibrationSystem.getResonanceEventByFrequency($$1), $$1);
        }
    });

    public Data getVibrationData();

    public User getVibrationUser();

    public static int getGameEventFrequency(Holder<GameEvent> p_316300_) {
        return p_316300_.unwrapKey().map(VibrationSystem::getGameEventFrequency).orElse(0);
    }

    public static int getGameEventFrequency(ResourceKey<GameEvent> p_316800_) {
        return VIBRATION_FREQUENCY_FOR_EVENT.applyAsInt(p_316800_);
    }

    public static ResourceKey<GameEvent> getResonanceEventByFrequency(int p_282105_) {
        return RESONANCE_EVENTS.get(p_282105_ - 1);
    }

    public static int getRedstoneStrengthForDistance(float p_282483_, int p_282722_) {
        double $$2 = 15.0 / (double)p_282722_;
        return Math.max(1, 15 - Mth.floor($$2 * (double)p_282483_));
    }

    public static interface User {
        public int getListenerRadius();

        public PositionSource getPositionSource();

        public boolean canReceiveVibration(ServerLevel var1, BlockPos var2, Holder<GameEvent> var3, GameEvent.Context var4);

        public void onReceiveVibration(ServerLevel var1, BlockPos var2, Holder<GameEvent> var3, @Nullable Entity var4, @Nullable Entity var5, float var6);

        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.VIBRATIONS;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean requiresAdjacentChunksToBeTicking() {
            return false;
        }

        default public int calculateTravelTimeInTicks(float p_281658_) {
            return Mth.floor(p_281658_);
        }

        default public boolean isValidVibration(Holder<GameEvent> p_316804_, GameEvent.Context p_283373_) {
            if (!p_316804_.is(this.getListenableEvents())) {
                return false;
            }
            Entity $$2 = p_283373_.sourceEntity();
            if ($$2 != null) {
                if ($$2.isSpectator()) {
                    return false;
                }
                if ($$2.isSteppingCarefully() && p_316804_.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                    if (this.canTriggerAvoidVibration() && $$2 instanceof ServerPlayer) {
                        ServerPlayer $$3 = (ServerPlayer)$$2;
                        CriteriaTriggers.AVOID_VIBRATION.trigger($$3);
                    }
                    return false;
                }
                if ($$2.dampensVibrations()) {
                    return false;
                }
            }
            if (p_283373_.affectedState() != null) {
                return !p_283373_.affectedState().is(BlockTags.DAMPENS_VIBRATIONS);
            }
            return true;
        }

        default public void onDataChanged() {
        }
    }

    public static interface Ticker {
        /*
         * WARNING - void declaration
         */
        public static void tick(Level p_281704_, Data p_282633_, User p_281564_) {
            void $$4;
            if (!(p_281704_ instanceof ServerLevel)) {
                return;
            }
            ServerLevel $$3 = (ServerLevel)p_281704_;
            if (p_282633_.currentVibration == null) {
                Ticker.trySelectAndScheduleVibration((ServerLevel)$$4, p_282633_, p_281564_);
            }
            if (p_282633_.currentVibration == null) {
                return;
            }
            boolean $$5 = p_282633_.getTravelTimeInTicks() > 0;
            Ticker.tryReloadVibrationParticle((ServerLevel)$$4, p_282633_, p_281564_);
            p_282633_.decrementTravelTime();
            if (p_282633_.getTravelTimeInTicks() <= 0) {
                $$5 = Ticker.receiveVibration((ServerLevel)$$4, p_282633_, p_281564_, p_282633_.currentVibration);
            }
            if ($$5) {
                p_281564_.onDataChanged();
            }
        }

        private static void trySelectAndScheduleVibration(ServerLevel p_282775_, Data p_282792_, User p_281845_) {
            p_282792_.getSelectionStrategy().chosenCandidate(p_282775_.getGameTime()).ifPresent(p_282059_ -> {
                p_282792_.setCurrentVibration((VibrationInfo)p_282059_);
                Vec3 $$4 = p_282059_.pos();
                p_282792_.setTravelTimeInTicks(p_281845_.calculateTravelTimeInTicks(p_282059_.distance()));
                p_282775_.sendParticles(new VibrationParticleOption(p_281845_.getPositionSource(), p_282792_.getTravelTimeInTicks()), $$4.x, $$4.y, $$4.z, 1, 0.0, 0.0, 0.0, 0.0);
                p_281845_.onDataChanged();
                p_282792_.getSelectionStrategy().startOver();
            });
        }

        private static void tryReloadVibrationParticle(ServerLevel p_282010_, Data p_282354_, User p_282958_) {
            double $$11;
            double $$10;
            int $$7;
            double $$8;
            double $$9;
            boolean $$12;
            if (!p_282354_.shouldReloadVibrationParticle()) {
                return;
            }
            if (p_282354_.currentVibration == null) {
                p_282354_.setReloadVibrationParticle(false);
                return;
            }
            Vec3 $$3 = p_282354_.currentVibration.pos();
            PositionSource $$4 = p_282958_.getPositionSource();
            Vec3 $$5 = $$4.getPosition(p_282010_).orElse($$3);
            int $$6 = p_282354_.getTravelTimeInTicks();
            boolean bl = $$12 = p_282010_.sendParticles(new VibrationParticleOption($$4, $$6), $$9 = Mth.lerp($$8 = 1.0 - (double)$$6 / (double)($$7 = p_282958_.calculateTravelTimeInTicks(p_282354_.currentVibration.distance())), $$3.x, $$5.x), $$10 = Mth.lerp($$8, $$3.y, $$5.y), $$11 = Mth.lerp($$8, $$3.z, $$5.z), 1, 0.0, 0.0, 0.0, 0.0) > 0;
            if ($$12) {
                p_282354_.setReloadVibrationParticle(false);
            }
        }

        private static boolean receiveVibration(ServerLevel p_282967_, Data p_283447_, User p_282301_, VibrationInfo p_281498_) {
            BlockPos $$4 = BlockPos.containing(p_281498_.pos());
            BlockPos $$5 = p_282301_.getPositionSource().getPosition(p_282967_).map(BlockPos::containing).orElse($$4);
            if (p_282301_.requiresAdjacentChunksToBeTicking() && !Ticker.areAdjacentChunksTicking(p_282967_, $$5)) {
                return false;
            }
            p_282301_.onReceiveVibration(p_282967_, $$4, p_281498_.gameEvent(), p_281498_.getEntity(p_282967_).orElse(null), p_281498_.getProjectileOwner(p_282967_).orElse(null), Listener.distanceBetweenInBlocks($$4, $$5));
            p_283447_.setCurrentVibration(null);
            return true;
        }

        private static boolean areAdjacentChunksTicking(Level p_282735_, BlockPos p_281722_) {
            ChunkPos $$2 = new ChunkPos(p_281722_);
            for (int $$3 = $$2.x - 1; $$3 <= $$2.x + 1; ++$$3) {
                for (int $$4 = $$2.z - 1; $$4 <= $$2.z + 1; ++$$4) {
                    if (p_282735_.shouldTickBlocksAt(ChunkPos.asLong($$3, $$4)) && p_282735_.getChunkSource().getChunkNow($$3, $$4) != null) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class Listener
    implements GameEventListener {
        private final VibrationSystem system;

        public Listener(VibrationSystem p_281843_) {
            this.system = p_281843_;
        }

        @Override
        public PositionSource getListenerSource() {
            return this.system.getVibrationUser().getPositionSource();
        }

        @Override
        public int getListenerRadius() {
            return this.system.getVibrationUser().getListenerRadius();
        }

        @Override
        public boolean handleGameEvent(ServerLevel p_282254_, Holder<GameEvent> p_316513_, GameEvent.Context p_283664_, Vec3 p_282426_) {
            Data $$4 = this.system.getVibrationData();
            User $$5 = this.system.getVibrationUser();
            if ($$4.getCurrentVibration() != null) {
                return false;
            }
            if (!$$5.isValidVibration(p_316513_, p_283664_)) {
                return false;
            }
            Optional<Vec3> $$6 = $$5.getPositionSource().getPosition(p_282254_);
            if ($$6.isEmpty()) {
                return false;
            }
            Vec3 $$7 = $$6.get();
            if (!$$5.canReceiveVibration(p_282254_, BlockPos.containing(p_282426_), p_316513_, p_283664_)) {
                return false;
            }
            if (Listener.isOccluded(p_282254_, p_282426_, $$7)) {
                return false;
            }
            this.scheduleVibration(p_282254_, $$4, p_316513_, p_283664_, p_282426_, $$7);
            return true;
        }

        public void forceScheduleVibration(ServerLevel p_282808_, Holder<GameEvent> p_316321_, GameEvent.Context p_281652_, Vec3 p_281530_) {
            this.system.getVibrationUser().getPositionSource().getPosition(p_282808_).ifPresent(p_316103_ -> this.scheduleVibration(p_282808_, this.system.getVibrationData(), p_316321_, p_281652_, p_281530_, (Vec3)p_316103_));
        }

        private void scheduleVibration(ServerLevel p_282037_, Data p_283229_, Holder<GameEvent> p_316858_, GameEvent.Context p_283344_, Vec3 p_281758_, Vec3 p_282990_) {
            p_283229_.selectionStrategy.addCandidate(new VibrationInfo(p_316858_, (float)p_281758_.distanceTo(p_282990_), p_281758_, p_283344_.sourceEntity()), p_282037_.getGameTime());
        }

        public static float distanceBetweenInBlocks(BlockPos p_282413_, BlockPos p_281960_) {
            return (float)Math.sqrt(p_282413_.distSqr(p_281960_));
        }

        private static boolean isOccluded(Level p_283225_, Vec3 p_283328_, Vec3 p_283163_) {
            Vec3 $$3 = new Vec3((double)Mth.floor(p_283328_.x) + 0.5, (double)Mth.floor(p_283328_.y) + 0.5, (double)Mth.floor(p_283328_.z) + 0.5);
            Vec3 $$4 = new Vec3((double)Mth.floor(p_283163_.x) + 0.5, (double)Mth.floor(p_283163_.y) + 0.5, (double)Mth.floor(p_283163_.z) + 0.5);
            for (Direction $$5 : Direction.values()) {
                Vec3 $$6 = $$3.relative($$5, 1.0E-5f);
                if (p_283225_.isBlockInLine(new ClipBlockStateContext($$6, $$4, p_283608_ -> p_283608_.is(BlockTags.OCCLUDES_VIBRATION_SIGNALS))).getType() == HitResult.Type.BLOCK) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Data {
        public static Codec<Data> CODEC = RecordCodecBuilder.create(p_338090_ -> p_338090_.group((App)VibrationInfo.CODEC.lenientOptionalFieldOf("event").forGetter(p_281665_ -> Optional.ofNullable(p_281665_.currentVibration)), (App)VibrationSelector.CODEC.fieldOf("selector").forGetter(Data::getSelectionStrategy), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("event_delay").orElse((Object)0).forGetter(Data::getTravelTimeInTicks)).apply((Applicative)p_338090_, (p_281934_, p_282381_, p_282931_) -> new Data(p_281934_.orElse(null), (VibrationSelector)p_282381_, (int)p_282931_, true)));
        public static final String NBT_TAG_KEY = "listener";
        @Nullable
        VibrationInfo currentVibration;
        private int travelTimeInTicks;
        final VibrationSelector selectionStrategy;
        private boolean reloadVibrationParticle;

        private Data(@Nullable VibrationInfo p_281967_, VibrationSelector p_283036_, int p_283607_, boolean p_282438_) {
            this.currentVibration = p_281967_;
            this.travelTimeInTicks = p_283607_;
            this.selectionStrategy = p_283036_;
            this.reloadVibrationParticle = p_282438_;
        }

        public Data() {
            this(null, new VibrationSelector(), 0, false);
        }

        public VibrationSelector getSelectionStrategy() {
            return this.selectionStrategy;
        }

        @Nullable
        public VibrationInfo getCurrentVibration() {
            return this.currentVibration;
        }

        public void setCurrentVibration(@Nullable VibrationInfo p_282049_) {
            this.currentVibration = p_282049_;
        }

        public int getTravelTimeInTicks() {
            return this.travelTimeInTicks;
        }

        public void setTravelTimeInTicks(int p_282973_) {
            this.travelTimeInTicks = p_282973_;
        }

        public void decrementTravelTime() {
            this.travelTimeInTicks = Math.max(0, this.travelTimeInTicks - 1);
        }

        public boolean shouldReloadVibrationParticle() {
            return this.reloadVibrationParticle;
        }

        public void setReloadVibrationParticle(boolean p_281702_) {
            this.reloadVibrationParticle = p_281702_;
        }
    }
}

