/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public record SerializableChunkData(Registry<Biome> biomeRegistry, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData) {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Codec<List<SavedTick<Block>>> BLOCK_TICKS_CODEC = SavedTick.codec(BuiltInRegistries.BLOCK.byNameCodec()).listOf();
    private static final Codec<List<SavedTick<Fluid>>> FLUID_TICKS_CODEC = SavedTick.codec(BuiltInRegistries.FLUID.byNameCodec()).listOf();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor p_361938_, RegistryAccess p_365010_, CompoundTag p_362040_) {
        if (p_362040_.getString("Status").isEmpty()) {
            return null;
        }
        ChunkPos $$3 = new ChunkPos(p_362040_.getIntOr(X_POS_TAG, 0), p_362040_.getIntOr(Z_POS_TAG, 0));
        long $$4 = p_362040_.getLongOr("LastUpdate", 0L);
        long $$5 = p_362040_.getLongOr("InhabitedTime", 0L);
        ChunkStatus $$6 = p_362040_.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY);
        UpgradeData $$7 = p_362040_.getCompound(TAG_UPGRADE_DATA).map(p_409546_ -> new UpgradeData((CompoundTag)p_409546_, p_361938_)).orElse(UpgradeData.EMPTY);
        boolean $$8 = p_362040_.getBooleanOr(IS_LIGHT_ON_TAG, false);
        BlendingData.Packed $$9 = p_362040_.read("blending_data", BlendingData.Packed.CODEC).orElse(null);
        BelowZeroRetrogen $$10 = p_362040_.read("below_zero_retrogen", BelowZeroRetrogen.CODEC).orElse(null);
        long[] $$11 = p_362040_.getLongArray("carving_mask").orElse(null);
        EnumMap<Heightmap.Types, long[]> $$12 = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        p_362040_.getCompound(HEIGHTMAPS_TAG).ifPresent(p_409536_ -> {
            for (Heightmap.Types $$3 : $$6.heightmapsAfter()) {
                p_409536_.getLongArray($$3.getSerializationKey()).ifPresent(p_409544_ -> $$12.put($$3, (long[])p_409544_));
            }
        });
        List<SavedTick<Block>> $$13 = SavedTick.filterTickListForChunk(p_362040_.read(BLOCK_TICKS_TAG, BLOCK_TICKS_CODEC).orElse(List.of()), $$3);
        List<SavedTick<Fluid>> $$14 = SavedTick.filterTickListForChunk(p_362040_.read(FLUID_TICKS_TAG, FLUID_TICKS_CODEC).orElse(List.of()), $$3);
        ChunkAccess.PackedTicks $$15 = new ChunkAccess.PackedTicks($$13, $$14);
        ListTag $$16 = p_362040_.getListOrEmpty("PostProcessing");
        ShortList[] $$17 = new ShortList[$$16.size()];
        for (int $$18 = 0; $$18 < $$16.size(); ++$$18) {
            ListTag $$19 = $$16.getListOrEmpty($$18);
            ShortArrayList $$20 = new ShortArrayList($$19.size());
            for (int $$21 = 0; $$21 < $$19.size(); ++$$21) {
                $$20.add($$19.getShortOr($$21, (short)0));
            }
            $$17[$$18] = $$20;
        }
        List<CompoundTag> $$22 = p_362040_.getList("entities").stream().flatMap(ListTag::compoundStream).toList();
        List<CompoundTag> $$23 = p_362040_.getList("block_entities").stream().flatMap(ListTag::compoundStream).toList();
        CompoundTag $$24 = p_362040_.getCompoundOrEmpty("structures");
        ListTag $$25 = p_362040_.getListOrEmpty(SECTIONS_TAG);
        ArrayList<SectionData> $$26 = new ArrayList<SectionData>($$25.size());
        HolderLookup.RegistryLookup $$27 = p_365010_.lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$28 = SerializableChunkData.makeBiomeCodec((Registry<Biome>)$$27);
        for (int $$29 = 0; $$29 < $$25.size(); ++$$29) {
            LevelChunkSection $$36;
            Optional<CompoundTag> $$30 = $$25.getCompound($$29);
            if ($$30.isEmpty()) continue;
            CompoundTag $$31 = $$30.get();
            byte $$32 = $$31.getByteOr("Y", (byte)0);
            if ($$32 >= p_361938_.getMinSectionY() && $$32 <= p_361938_.getMaxSectionY()) {
                PalettedContainer $$33 = $$31.getCompound("block_states").map(p_409528_ -> (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, p_409528_).promotePartial(p_361842_ -> SerializableChunkData.logErrors($$3, $$32, p_361842_)).getOrThrow(ChunkReadException::new)).orElseGet(() -> new PalettedContainer<BlockState>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES));
                PalettedContainerRO $$34 = $$31.getCompound("biomes").map(p_409533_ -> (PalettedContainerRO)$$28.parse((DynamicOps)NbtOps.INSTANCE, p_409533_).promotePartial(p_361282_ -> SerializableChunkData.logErrors($$3, $$32, p_361282_)).getOrThrow(ChunkReadException::new)).orElseGet(() -> SerializableChunkData.lambda$parse$8((Registry)$$27));
                LevelChunkSection $$35 = new LevelChunkSection($$33, $$34);
            } else {
                $$36 = null;
            }
            DataLayer $$37 = $$31.getByteArray(BLOCK_LIGHT_TAG).map(DataLayer::new).orElse(null);
            DataLayer $$38 = $$31.getByteArray(SKY_LIGHT_TAG).map(DataLayer::new).orElse(null);
            $$26.add(new SectionData($$32, $$36, $$37, $$38));
        }
        return new SerializableChunkData((Registry<Biome>)$$27, $$3, p_361938_.getMinSectionY(), $$4, $$5, $$6, $$9, $$10, $$7, $$11, $$12, $$15, $$17, $$8, $$26, $$22, $$23, $$24);
    }

    public ProtoChunk read(ServerLevel p_360452_, PoiManager p_364451_, RegionStorageInfo p_364971_, ChunkPos p_360628_) {
        ProtoChunk $$22;
        if (!Objects.equals(p_360628_, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{p_360628_, p_360628_, this.chunkPos});
            p_360452_.getServer().reportMisplacedChunk(this.chunkPos, p_360628_, p_364971_);
        }
        int $$4 = p_360452_.getSectionsCount();
        LevelChunkSection[] $$5 = new LevelChunkSection[$$4];
        boolean $$6 = p_360452_.dimensionType().hasSkyLight();
        ServerChunkCache $$7 = p_360452_.getChunkSource();
        LevelLightEngine $$8 = ((ChunkSource)$$7).getLightEngine();
        HolderLookup.RegistryLookup $$9 = p_360452_.registryAccess().lookupOrThrow(Registries.BIOME);
        boolean $$10 = false;
        for (SectionData $$11 : this.sectionData) {
            boolean $$14;
            SectionPos $$12 = SectionPos.of(p_360628_, $$11.y);
            if ($$11.chunkSection != null) {
                $$5[p_360452_.getSectionIndexFromSectionY((int)$$11.y)] = $$11.chunkSection;
                p_364451_.checkConsistencyWithBlocks($$12, $$11.chunkSection);
            }
            boolean $$13 = $$11.blockLight != null;
            boolean bl = $$14 = $$6 && $$11.skyLight != null;
            if (!$$13 && !$$14) continue;
            if (!$$10) {
                $$8.retainData(p_360628_, true);
                $$10 = true;
            }
            if ($$13) {
                $$8.queueSectionData(LightLayer.BLOCK, $$12, $$11.blockLight);
            }
            if (!$$14) continue;
            $$8.queueSectionData(LightLayer.SKY, $$12, $$11.skyLight);
        }
        ChunkType $$15 = this.chunkStatus.getChunkType();
        if ($$15 == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> $$16 = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            LevelChunkTicks<Fluid> $$17 = new LevelChunkTicks<Fluid>(this.packedTicks.fluids());
            LevelChunk $$18 = new LevelChunk(p_360452_.getLevel(), p_360628_, this.upgradeData, $$16, $$17, this.inhabitedTime, $$5, SerializableChunkData.postLoadChunk(p_360452_, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunk $$21;
            ProtoChunkTicks<Block> $$19 = ProtoChunkTicks.load(this.packedTicks.blocks());
            ProtoChunkTicks<Fluid> $$20 = ProtoChunkTicks.load(this.packedTicks.fluids());
            $$22 = $$21 = new ProtoChunk(p_360628_, this.upgradeData, $$5, $$19, $$20, p_360452_, (Registry<Biome>)$$9, BlendingData.unpack(this.blendingData));
            $$22.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                $$21.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            $$21.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                $$21.setLightEngine($$8);
            }
        }
        $$22.setLightCorrect(this.lightCorrect);
        EnumSet<Heightmap.Types> $$23 = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types $$24 : ((ChunkAccess)$$22).getPersistedStatus().heightmapsAfter()) {
            long[] $$25 = this.heightmaps.get($$24);
            if ($$25 != null) {
                $$22.setHeightmap($$24, $$25);
                continue;
            }
            $$23.add($$24);
        }
        Heightmap.primeHeightmaps($$22, $$23);
        $$22.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel(p_360452_), this.structureData, p_360452_.getSeed()));
        $$22.setAllReferences(SerializableChunkData.unpackStructureReferences(p_360452_.registryAccess(), p_360628_, this.structureData));
        for (int $$26 = 0; $$26 < this.postProcessingSections.length; ++$$26) {
            ((ChunkAccess)$$22).addPackedPostProcess(this.postProcessingSections[$$26], $$26);
        }
        if ($$15 == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)((Object)$$22), false);
        }
        ProtoChunk $$27 = $$22;
        for (CompoundTag $$28 : this.entities) {
            $$27.addEntity($$28);
        }
        for (CompoundTag $$29 : this.blockEntities) {
            $$27.setBlockEntityNbt($$29);
        }
        if (this.carvingMask != null) {
            $$27.setCarvingMask(new CarvingMask(this.carvingMask, $$22.getMinY()));
        }
        return $$27;
    }

    private static void logErrors(ChunkPos p_361949_, int p_364275_, String p_360703_) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{p_361949_.x, p_364275_, p_361949_.z, p_360703_});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> p_364562_) {
        return PalettedContainer.codecRO(p_364562_.asHolderIdMap(), p_364562_.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, p_364562_.getOrThrow(Biomes.PLAINS));
    }

    public static SerializableChunkData copyOf(ServerLevel p_365319_, ChunkAccess p_362284_) {
        if (!p_362284_.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(p_362284_));
        }
        ChunkPos $$2 = p_362284_.getPos();
        ArrayList<SectionData> $$3 = new ArrayList<SectionData>();
        LevelChunkSection[] $$4 = p_362284_.getSections();
        ThreadedLevelLightEngine $$5 = p_365319_.getChunkSource().getLightEngine();
        for (int $$6 = $$5.getMinLightSection(); $$6 < $$5.getMaxLightSection(); ++$$6) {
            DataLayer $$12;
            int $$7 = p_362284_.getSectionIndexFromSectionY($$6);
            boolean $$8 = $$7 >= 0 && $$7 < $$4.length;
            DataLayer $$9 = $$5.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of($$2, $$6));
            DataLayer $$10 = $$5.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of($$2, $$6));
            DataLayer dataLayer = $$9 != null && !$$9.isEmpty() ? $$9.copy() : null;
            DataLayer dataLayer2 = $$12 = $$10 != null && !$$10.isEmpty() ? $$10.copy() : null;
            if (!$$8 && dataLayer == null && $$12 == null) continue;
            LevelChunkSection $$13 = $$8 ? $$4[$$7].copy() : null;
            $$3.add(new SectionData($$6, $$13, dataLayer, $$12));
        }
        ArrayList<CompoundTag> $$14 = new ArrayList<CompoundTag>(p_362284_.getBlockEntitiesPos().size());
        for (BlockPos $$15 : p_362284_.getBlockEntitiesPos()) {
            CompoundTag $$16 = p_362284_.getBlockEntityNbtForSaving($$15, p_365319_.registryAccess());
            if ($$16 == null) continue;
            $$14.add($$16);
        }
        ArrayList<CompoundTag> $$17 = new ArrayList<CompoundTag>();
        long[] $$18 = null;
        if (p_362284_.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk $$19 = (ProtoChunk)p_362284_;
            $$17.addAll($$19.getEntities());
            CarvingMask $$20 = $$19.getCarvingMask();
            if ($$20 != null) {
                $$18 = $$20.toArray();
            }
        }
        EnumMap<Heightmap.Types, long[]> $$21 = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Map.Entry entry : p_362284_.getHeightmaps()) {
            if (!p_362284_.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            long[] $$23 = ((Heightmap)entry.getValue()).getRawData();
            $$21.put((Heightmap.Types)entry.getKey(), (long[])$$23.clone());
        }
        ChunkAccess.PackedTicks $$24 = p_362284_.getTicksForSerialization(p_365319_.getGameTime());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(p_362284_.getPostProcessing()).map(p_363794_ -> p_363794_ != null ? new ShortArrayList(p_363794_) : null).toArray(ShortList[]::new);
        CompoundTag $$26 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel(p_365319_), $$2, p_362284_.getAllStarts(), p_362284_.getAllReferences());
        return new SerializableChunkData((Registry<Biome>)p_365319_.registryAccess().lookupOrThrow(Registries.BIOME), $$2, p_362284_.getMinSectionY(), p_365319_.getGameTime(), p_362284_.getInhabitedTime(), p_362284_.getPersistedStatus(), Optionull.map(p_362284_.getBlendingData(), BlendingData::pack), p_362284_.getBelowZeroRetrogen(), p_362284_.getUpgradeData().copy(), $$18, $$21, $$24, shortListArray, p_362284_.isLightCorrect(), $$3, $$17, $$14, $$26);
    }

    public CompoundTag write() {
        CompoundTag $$0 = NbtUtils.addCurrentDataVersion(new CompoundTag());
        $$0.putInt(X_POS_TAG, this.chunkPos.x);
        $$0.putInt("yPos", this.minSectionY);
        $$0.putInt(Z_POS_TAG, this.chunkPos.z);
        $$0.putLong("LastUpdate", this.lastUpdateTime);
        $$0.putLong("InhabitedTime", this.inhabitedTime);
        $$0.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        $$0.storeNullable("blending_data", BlendingData.Packed.CODEC, this.blendingData);
        $$0.storeNullable("below_zero_retrogen", BelowZeroRetrogen.CODEC, this.belowZeroRetrogen);
        if (!this.upgradeData.isEmpty()) {
            $$0.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        ListTag $$1 = new ListTag();
        Codec<PalettedContainerRO<Holder<Biome>>> $$2 = SerializableChunkData.makeBiomeCodec(this.biomeRegistry);
        for (SectionData $$3 : this.sectionData) {
            CompoundTag $$4 = new CompoundTag();
            LevelChunkSection $$5 = $$3.chunkSection;
            if ($$5 != null) {
                $$4.store("block_states", BLOCK_STATE_CODEC, $$5.getStates());
                $$4.store("biomes", $$2, $$5.getBiomes());
            }
            if ($$3.blockLight != null) {
                $$4.putByteArray(BLOCK_LIGHT_TAG, $$3.blockLight.getData());
            }
            if ($$3.skyLight != null) {
                $$4.putByteArray(SKY_LIGHT_TAG, $$3.skyLight.getData());
            }
            if ($$4.isEmpty()) continue;
            $$4.putByte("Y", (byte)$$3.y);
            $$1.add($$4);
        }
        $$0.put(SECTIONS_TAG, $$1);
        if (this.lightCorrect) {
            $$0.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag $$6 = new ListTag();
        $$6.addAll(this.blockEntities);
        $$0.put("block_entities", $$6);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            ListTag $$7 = new ListTag();
            $$7.addAll(this.entities);
            $$0.put("entities", $$7);
            if (this.carvingMask != null) {
                $$0.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks($$0, this.packedTicks);
        $$0.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        CompoundTag $$8 = new CompoundTag();
        this.heightmaps.forEach((p_362472_, p_363515_) -> $$8.put(p_362472_.getSerializationKey(), new LongArrayTag((long[])p_363515_)));
        $$0.put(HEIGHTMAPS_TAG, $$8);
        $$0.put("structures", this.structureData);
        return $$0;
    }

    private static void saveTicks(CompoundTag p_362920_, ChunkAccess.PackedTicks p_361228_) {
        p_362920_.store(BLOCK_TICKS_TAG, BLOCK_TICKS_CODEC, p_361228_.blocks());
        p_362920_.store(FLUID_TICKS_TAG, FLUID_TICKS_CODEC, p_361228_.fluids());
    }

    public static ChunkStatus getChunkStatusFromTag(@Nullable CompoundTag p_405768_) {
        return p_405768_ != null ? p_405768_.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY) : ChunkStatus.EMPTY;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel p_363005_, List<CompoundTag> p_362405_, List<CompoundTag> p_364156_) {
        if (p_362405_.isEmpty() && p_364156_.isEmpty()) {
            return null;
        }
        return p_421450_ -> {
            if (!p_362405_.isEmpty()) {
                try (ProblemReporter.ScopedCollector $$4 = new ProblemReporter.ScopedCollector(p_421450_.problemPath(), LOGGER);){
                    p_363005_.addLegacyChunkEntities(EntityType.loadEntitiesRecursive(TagValueInput.create((ProblemReporter)$$4, (HolderLookup.Provider)p_363005_.registryAccess(), p_362405_), p_363005_, EntitySpawnReason.LOAD));
                }
            }
            for (CompoundTag $$5 : p_364156_) {
                boolean $$6 = $$5.getBooleanOr("keepPacked", false);
                if ($$6) {
                    p_421450_.setBlockEntityNbt($$5);
                    continue;
                }
                BlockPos $$7 = BlockEntity.getPosFromTag(p_421450_.getPos(), $$5);
                BlockEntity $$8 = BlockEntity.loadStatic($$7, p_421450_.getBlockState($$7), $$5, p_363005_.registryAccess());
                if ($$8 == null) continue;
                p_421450_.setBlockEntity($$8);
            }
        };
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext p_361063_, ChunkPos p_365377_, Map<Structure, StructureStart> p_365385_, Map<Structure, LongSet> p_362410_) {
        CompoundTag $$4 = new CompoundTag();
        CompoundTag $$5 = new CompoundTag();
        HolderLookup.RegistryLookup $$6 = p_361063_.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> $$7 : p_365385_.entrySet()) {
            ResourceLocation $$8 = $$6.getKey($$7.getKey());
            $$5.put($$8.toString(), $$7.getValue().createTag(p_361063_, p_365377_));
        }
        $$4.put("starts", $$5);
        CompoundTag $$9 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> $$10 : p_362410_.entrySet()) {
            if ($$10.getValue().isEmpty()) continue;
            ResourceLocation $$11 = $$6.getKey($$10.getKey());
            $$9.putLongArray($$11.toString(), $$10.getValue().toLongArray());
        }
        $$4.put("References", $$9);
        return $$4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext p_360982_, CompoundTag p_363682_, long p_362695_) {
        HashMap $$3 = Maps.newHashMap();
        HolderLookup.RegistryLookup $$4 = p_360982_.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = p_363682_.getCompoundOrEmpty("starts");
        for (String $$6 : $$5.keySet()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = (Structure)$$4.getValue($$7);
            if ($$8 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)$$7);
                continue;
            }
            StructureStart $$9 = StructureStart.loadStaticStart(p_360982_, $$5.getCompoundOrEmpty($$6), p_362695_);
            if ($$9 == null) continue;
            $$3.put($$8, $$9);
        }
        return $$3;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess p_360856_, ChunkPos p_362116_, CompoundTag p_360575_) {
        HashMap $$3 = Maps.newHashMap();
        HolderLookup.RegistryLookup $$4 = p_360856_.lookupOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = p_360575_.getCompoundOrEmpty("References");
        $$5.forEach((arg_0, arg_1) -> SerializableChunkData.lambda$unpackStructureReferences$14((Registry)$$4, p_362116_, $$3, arg_0, arg_1));
        return $$3;
    }

    private static ListTag packOffsets(ShortList[] p_364852_) {
        ListTag $$1 = new ListTag();
        for (ShortList $$2 : p_364852_) {
            ListTag $$3 = new ListTag();
            if ($$2 != null) {
                for (int $$4 = 0; $$4 < $$2.size(); ++$$4) {
                    $$3.add(ShortTag.valueOf($$2.getShort($$4)));
                }
            }
            $$1.add($$3);
        }
        return $$1;
    }

    private static /* synthetic */ void lambda$unpackStructureReferences$14(Registry p_409537_, ChunkPos p_409538_, Map p_409539_, String p_409540_, Tag p_409541_) {
        ResourceLocation $$5 = ResourceLocation.tryParse(p_409540_);
        Structure $$6 = (Structure)p_409537_.getValue($$5);
        if ($$6 == null) {
            LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)$$5, (Object)p_409538_);
            return;
        }
        Optional<long[]> $$7 = p_409541_.asLongArray();
        if ($$7.isEmpty()) {
            return;
        }
        p_409539_.put($$6, new LongOpenHashSet(Arrays.stream($$7.get()).filter(p_360765_ -> {
            ChunkPos $$3 = new ChunkPos(p_360765_);
            if ($$3.getChessboardDistance(p_409538_) > 8) {
                LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{$$5, $$3, p_409538_});
                return false;
            }
            return true;
        }).toArray()));
    }

    private static /* synthetic */ PalettedContainerRO lambda$parse$8(Registry p_409529_) {
        return new PalettedContainer<Holder.Reference>(p_409529_.asHolderIdMap(), p_409529_.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
    }

    public record SectionData(int y, @Nullable LevelChunkSection chunkSection, @Nullable DataLayer blockLight, @Nullable DataLayer skyLight) {
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String p_361971_) {
            super(p_361971_);
        }
    }
}

