/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.Property;

public final class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final List<T> values;
    private final Map<String, T> names;
    private final int[] ordinalToIndex;

    private EnumProperty(String p_61579_, Class<T> p_61580_, List<T> p_372820_) {
        super(p_61579_, p_61580_);
        if (p_372820_.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + p_61579_ + "'");
        }
        this.values = List.copyOf(p_372820_);
        Enum[] $$3 = (Enum[])p_61580_.getEnumConstants();
        this.ordinalToIndex = new int[$$3.length];
        for (Enum $$4 : $$3) {
            this.ordinalToIndex[$$4.ordinal()] = p_372820_.indexOf($$4);
        }
        ImmutableMap.Builder $$5 = ImmutableMap.builder();
        for (Enum $$6 : p_372820_) {
            String $$7 = ((StringRepresentable)((Object)$$6)).getSerializedName();
            $$5.put((Object)$$7, (Object)$$6);
        }
        this.names = $$5.buildOrThrow();
    }

    @Override
    public List<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String p_61604_) {
        return Optional.ofNullable((Enum)this.names.get(p_61604_));
    }

    @Override
    public String getName(T p_61586_) {
        return ((StringRepresentable)p_61586_).getSerializedName();
    }

    @Override
    public int getInternalIndex(T p_373052_) {
        return this.ordinalToIndex[((Enum)p_373052_).ordinal()];
    }

    @Override
    public boolean equals(Object p_61606_) {
        if (this == p_61606_) {
            return true;
        }
        if (p_61606_ instanceof EnumProperty) {
            EnumProperty $$1 = (EnumProperty)p_61606_;
            if (super.equals(p_61606_)) {
                return this.values.equals($$1.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        int $$0 = super.generateHashCode();
        $$0 = 31 * $$0 + this.values.hashCode();
        return $$0;
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String p_61588_, Class<T> p_61589_) {
        return EnumProperty.create(p_61588_, p_61589_, (T p_187560_) -> true);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String p_61595_, Class<T> p_61596_, Predicate<T> p_61597_) {
        return EnumProperty.create(p_61595_, p_61596_, Arrays.stream((Enum[])p_61596_.getEnumConstants()).filter(p_61597_).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumProperty<T> create(String p_61599_, Class<T> p_61600_, T ... p_61601_) {
        return EnumProperty.create(p_61599_, p_61600_, List.of(p_61601_));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String p_61591_, Class<T> p_61592_, List<T> p_372944_) {
        return new EnumProperty<T>(p_61591_, p_61592_, p_372944_);
    }

    @Override
    public /* synthetic */ int getInternalIndex(Comparable comparable) {
        return this.getInternalIndex((Enum)((Object)comparable));
    }

    @Override
    public /* synthetic */ String getName(Comparable comparable) {
        return this.getName((Enum)((Object)comparable));
    }
}

