/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class TrialSpawnerStateData {
    private static final String TAG_SPAWN_DATA = "spawn_data";
    private static final String TAG_NEXT_MOB_SPAWNS_AT = "next_mob_spawns_at";
    private static final int DELAY_BETWEEN_PLAYER_SCANS = 20;
    private static final int TRIAL_OMEN_PER_BAD_OMEN_LEVEL = 18000;
    final Set<UUID> detectedPlayers = new HashSet<UUID>();
    final Set<UUID> currentMobs = new HashSet<UUID>();
    long cooldownEndsAt;
    long nextMobSpawnsAt;
    int totalMobsSpawned;
    Optional<SpawnData> nextSpawnData = Optional.empty();
    Optional<ResourceKey<LootTable>> ejectingLootTable = Optional.empty();
    @Nullable
    private Entity displayEntity;
    @Nullable
    private WeightedList<ItemStack> dispensing;
    double spin;
    double oSpin;

    public Packed pack() {
        return new Packed(Set.copyOf(this.detectedPlayers), Set.copyOf(this.currentMobs), this.cooldownEndsAt, this.nextMobSpawnsAt, this.totalMobsSpawned, this.nextSpawnData, this.ejectingLootTable);
    }

    public void apply(Packed p_421478_) {
        this.detectedPlayers.clear();
        this.detectedPlayers.addAll(p_421478_.detectedPlayers);
        this.currentMobs.clear();
        this.currentMobs.addAll(p_421478_.currentMobs);
        this.cooldownEndsAt = p_421478_.cooldownEndsAt;
        this.nextMobSpawnsAt = p_421478_.nextMobSpawnsAt;
        this.totalMobsSpawned = p_421478_.totalMobsSpawned;
        this.nextSpawnData = p_421478_.nextSpawnData;
        this.ejectingLootTable = p_421478_.ejectingLootTable;
    }

    public void reset() {
        this.currentMobs.clear();
        this.nextSpawnData = Optional.empty();
        this.resetStatistics();
    }

    public void resetStatistics() {
        this.detectedPlayers.clear();
        this.totalMobsSpawned = 0;
        this.nextMobSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
    }

    public boolean hasMobToSpawn(TrialSpawner p_422351_, RandomSource p_421482_) {
        boolean $$2 = this.getOrCreateNextSpawnData(p_422351_, p_421482_).getEntityToSpawn().getString("id").isPresent();
        return $$2 || !p_422351_.activeConfig().spawnPotentialsDefinition().isEmpty();
    }

    public boolean hasFinishedSpawningAllMobs(TrialSpawnerConfig p_422354_, int p_422183_) {
        return this.totalMobsSpawned >= p_422354_.calculateTargetTotalMobs(p_422183_);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(ServerLevel p_422162_, TrialSpawnerConfig p_422263_, int p_422207_) {
        return p_422162_.getGameTime() >= this.nextMobSpawnsAt && this.currentMobs.size() < p_422263_.calculateTargetSimultaneousMobs(p_422207_);
    }

    public int countAdditionalPlayers(BlockPos p_422699_) {
        if (this.detectedPlayers.isEmpty()) {
            Util.logAndPauseIfInIde("Trial Spawner at " + String.valueOf(p_422699_) + " has no detected players");
        }
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public void tryDetectPlayers(ServerLevel p_422381_, BlockPos p_421956_, TrialSpawner p_421925_) {
        List<UUID> $$9;
        boolean $$7;
        boolean $$3;
        boolean bl = $$3 = (p_421956_.asLong() + p_422381_.getGameTime()) % 20L != 0L;
        if ($$3) {
            return;
        }
        if (p_421925_.getState().equals(TrialSpawnerState.COOLDOWN) && p_421925_.isOminous()) {
            return;
        }
        List<UUID> $$4 = p_421925_.getPlayerDetector().detect(p_422381_, p_421925_.getEntitySelector(), p_421956_, p_421925_.getRequiredPlayerRange(), true);
        if (p_421925_.isOminous() || $$4.isEmpty()) {
            boolean $$5 = false;
        } else {
            Optional<Pair<Player, Holder<MobEffect>>> $$6 = TrialSpawnerStateData.findPlayerWithOminousEffect(p_422381_, $$4);
            $$6.ifPresent(p_427219_ -> {
                Player $$4 = (Player)p_427219_.getFirst();
                if (p_427219_.getSecond() == MobEffects.BAD_OMEN) {
                    TrialSpawnerStateData.transformBadOmenIntoTrialOmen($$4);
                }
                p_422381_.levelEvent(3020, BlockPos.containing($$4.getEyePosition()), 0);
                p_421925_.applyOminous(p_422381_, p_421956_);
            });
            $$7 = $$6.isPresent();
        }
        if (p_421925_.getState().equals(TrialSpawnerState.COOLDOWN) && !$$7) {
            return;
        }
        boolean $$8 = p_421925_.getStateData().detectedPlayers.isEmpty();
        List<UUID> list = $$9 = $$8 ? $$4 : p_421925_.getPlayerDetector().detect(p_422381_, p_421925_.getEntitySelector(), p_421956_, p_421925_.getRequiredPlayerRange(), false);
        if (this.detectedPlayers.addAll($$9)) {
            this.nextMobSpawnsAt = Math.max(p_422381_.getGameTime() + 40L, this.nextMobSpawnsAt);
            if (!$$7) {
                int $$10 = p_421925_.isOminous() ? 3019 : 3013;
                p_422381_.levelEvent($$10, p_421956_, this.detectedPlayers.size());
            }
        }
    }

    private static Optional<Pair<Player, Holder<MobEffect>>> findPlayerWithOminousEffect(ServerLevel p_422672_, List<UUID> p_422201_) {
        Player $$2 = null;
        for (UUID $$3 : p_422201_) {
            Player $$4 = p_422672_.getPlayerByUUID($$3);
            if ($$4 == null) continue;
            Holder<MobEffect> $$5 = MobEffects.TRIAL_OMEN;
            if ($$4.hasEffect($$5)) {
                return Optional.of(Pair.of((Object)$$4, $$5));
            }
            if (!$$4.hasEffect(MobEffects.BAD_OMEN)) continue;
            $$2 = $$4;
        }
        return Optional.ofNullable($$2).map(p_421755_ -> Pair.of((Object)p_421755_, MobEffects.BAD_OMEN));
    }

    public void resetAfterBecomingOminous(TrialSpawner p_421806_, ServerLevel p_422006_) {
        this.currentMobs.stream().map(p_422006_::getEntity).forEach(p_421890_ -> {
            if (p_421890_ == null) {
                return;
            }
            p_422006_.levelEvent(3012, p_421890_.blockPosition(), TrialSpawner.FlameParticle.NORMAL.encode());
            if (p_421890_ instanceof Mob) {
                Mob $$2 = (Mob)p_421890_;
                $$2.dropPreservedEquipment(p_422006_);
            }
            p_421890_.remove(Entity.RemovalReason.DISCARDED);
        });
        if (!p_421806_.ominousConfig().spawnPotentialsDefinition().isEmpty()) {
            this.nextSpawnData = Optional.empty();
        }
        this.totalMobsSpawned = 0;
        this.currentMobs.clear();
        this.nextMobSpawnsAt = p_422006_.getGameTime() + (long)p_421806_.ominousConfig().ticksBetweenSpawn();
        p_421806_.markUpdated();
        this.cooldownEndsAt = p_422006_.getGameTime() + p_421806_.ominousConfig().ticksBetweenItemSpawners();
    }

    private static void transformBadOmenIntoTrialOmen(Player p_422355_) {
        MobEffectInstance $$1 = p_422355_.getEffect(MobEffects.BAD_OMEN);
        if ($$1 == null) {
            return;
        }
        int $$2 = $$1.getAmplifier() + 1;
        int $$3 = 18000 * $$2;
        p_422355_.removeEffect(MobEffects.BAD_OMEN);
        p_422355_.addEffect(new MobEffectInstance(MobEffects.TRIAL_OMEN, $$3, 0));
    }

    public boolean isReadyToOpenShutter(ServerLevel p_421776_, float p_422030_, int p_422651_) {
        long $$3 = this.cooldownEndsAt - (long)p_422651_;
        return (float)p_421776_.getGameTime() >= (float)$$3 + p_422030_;
    }

    public boolean isReadyToEjectItems(ServerLevel p_422356_, float p_422031_, int p_422141_) {
        long $$3 = this.cooldownEndsAt - (long)p_422141_;
        return (float)(p_422356_.getGameTime() - $$3) % p_422031_ == 0.0f;
    }

    public boolean isCooldownFinished(ServerLevel p_421790_) {
        return p_421790_.getGameTime() >= this.cooldownEndsAt;
    }

    protected SpawnData getOrCreateNextSpawnData(TrialSpawner p_422364_, RandomSource p_422656_) {
        if (this.nextSpawnData.isPresent()) {
            return this.nextSpawnData.get();
        }
        WeightedList<SpawnData> $$2 = p_422364_.activeConfig().spawnPotentialsDefinition();
        Optional<SpawnData> $$3 = $$2.isEmpty() ? this.nextSpawnData : $$2.getRandom(p_422656_);
        this.nextSpawnData = Optional.of($$3.orElseGet(SpawnData::new));
        p_422364_.markUpdated();
        return this.nextSpawnData.get();
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(TrialSpawner p_422419_, Level p_421870_, TrialSpawnerState p_422215_) {
        CompoundTag $$3;
        if (!p_422215_.hasSpinningMob()) {
            return null;
        }
        if (this.displayEntity == null && ($$3 = this.getOrCreateNextSpawnData(p_422419_, p_421870_.getRandom()).getEntityToSpawn()).getString("id").isPresent()) {
            this.displayEntity = EntityType.loadEntityRecursive($$3, p_421870_, EntitySpawnReason.TRIAL_SPAWNER, Function.identity());
        }
        return this.displayEntity;
    }

    public CompoundTag getUpdateTag(TrialSpawnerState p_422094_) {
        CompoundTag $$1 = new CompoundTag();
        if (p_422094_ == TrialSpawnerState.ACTIVE) {
            $$1.putLong(TAG_NEXT_MOB_SPAWNS_AT, this.nextMobSpawnsAt);
        }
        this.nextSpawnData.ifPresent(p_422694_ -> $$1.store(TAG_SPAWN_DATA, SpawnData.CODEC, p_422694_));
        return $$1;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    WeightedList<ItemStack> getDispensingItems(ServerLevel p_421873_, TrialSpawnerConfig p_421889_, BlockPos p_422242_) {
        long $$5;
        LootParams $$4;
        if (this.dispensing != null) {
            return this.dispensing;
        }
        LootTable $$3 = p_421873_.getServer().reloadableRegistries().getLootTable(p_421889_.itemsToDropWhenOminous());
        ObjectArrayList<ItemStack> $$6 = $$3.getRandomItems($$4 = new LootParams.Builder(p_421873_).create(LootContextParamSets.EMPTY), $$5 = TrialSpawnerStateData.lowResolutionPosition(p_421873_, p_422242_));
        if ($$6.isEmpty()) {
            return WeightedList.of();
        }
        WeightedList.Builder<ItemStack> $$7 = WeightedList.builder();
        for (ItemStack $$8 : $$6) {
            $$7.add($$8.copyWithCount(1), $$8.getCount());
        }
        this.dispensing = $$7.build();
        return this.dispensing;
    }

    private static long lowResolutionPosition(ServerLevel p_422056_, BlockPos p_421660_) {
        BlockPos $$2 = new BlockPos(Mth.floor((float)p_421660_.getX() / 30.0f), Mth.floor((float)p_421660_.getY() / 20.0f), Mth.floor((float)p_421660_.getZ() / 30.0f));
        return p_422056_.getSeed() + $$2.asLong();
    }

    public record Packed(Set<UUID> detectedPlayers, Set<UUID> currentMobs, long cooldownEndsAt, long nextMobSpawnsAt, int totalMobsSpawned, Optional<SpawnData> nextSpawnData, Optional<ResourceKey<LootTable>> ejectingLootTable) {
        public static final MapCodec<Packed> MAP_CODEC = RecordCodecBuilder.mapCodec(p_421723_ -> p_421723_.group((App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("registered_players", Set.of()).forGetter(Packed::detectedPlayers), (App)UUIDUtil.CODEC_SET.lenientOptionalFieldOf("current_mobs", Set.of()).forGetter(Packed::currentMobs), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(Packed::cooldownEndsAt), (App)Codec.LONG.lenientOptionalFieldOf(TrialSpawnerStateData.TAG_NEXT_MOB_SPAWNS_AT, (Object)0L).forGetter(Packed::nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(Packed::totalMobsSpawned), (App)SpawnData.CODEC.lenientOptionalFieldOf(TrialSpawnerStateData.TAG_SPAWN_DATA).forGetter(Packed::nextSpawnData), (App)LootTable.KEY_CODEC.lenientOptionalFieldOf("ejecting_loot_table").forGetter(Packed::ejectingLootTable)).apply((Applicative)p_421723_, Packed::new));
    }
}

