/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.slf4j.Logger;

public final class TrialSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerStateData data = new TrialSpawnerStateData();
    private FullConfig config;
    private final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    private boolean isOminous;

    public TrialSpawner(FullConfig p_422371_, StateAccessor p_312198_, PlayerDetector p_312690_, PlayerDetector.EntitySelector p_323834_) {
        this.config = p_422371_;
        this.stateAccessor = p_312198_;
        this.playerDetector = p_312690_;
        this.entitySelector = p_323834_;
    }

    public TrialSpawnerConfig activeConfig() {
        return this.isOminous ? this.config.ominous().value() : this.config.normal.value();
    }

    public TrialSpawnerConfig normalConfig() {
        return this.config.normal.value();
    }

    public TrialSpawnerConfig ominousConfig() {
        return this.config.ominous.value();
    }

    public void load(ValueInput p_421696_) {
        p_421696_.read(TrialSpawnerStateData.Packed.MAP_CODEC).ifPresent(this.data::apply);
        this.config = p_421696_.read(FullConfig.MAP_CODEC).orElse(FullConfig.DEFAULT);
    }

    public void store(ValueOutput p_422109_) {
        p_422109_.store(TrialSpawnerStateData.Packed.MAP_CODEC, this.data.pack());
        p_422109_.store(FullConfig.MAP_CODEC, this.config);
    }

    public void applyOminous(ServerLevel p_338315_, BlockPos p_338416_) {
        p_338315_.setBlock(p_338416_, (BlockState)p_338315_.getBlockState(p_338416_).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        p_338315_.levelEvent(3020, p_338416_, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, p_338315_);
    }

    public void removeOminous(ServerLevel p_338672_, BlockPos p_338318_) {
        p_338672_.setBlock(p_338318_, (BlockState)p_338672_.getBlockState(p_338318_).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public int getTargetCooldownLength() {
        return this.config.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.config.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public TrialSpawnerStateData getStateData() {
        return this.data;
    }

    public void setState(Level p_312688_, TrialSpawnerState p_312718_) {
        this.stateAccessor.setState(p_312688_, p_312718_);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(ServerLevel p_376465_) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if (p_376465_.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return p_376465_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(ServerLevel p_312582_, BlockPos p_312518_) {
        RandomSource $$2 = p_312582_.getRandom();
        SpawnData $$3 = this.data.getOrCreateNextSpawnData(this, p_312582_.getRandom());
        try (ProblemReporter.ScopedCollector $$4 = new ProblemReporter.ScopedCollector(() -> "spawner@" + String.valueOf(p_312518_), LOGGER);){
            Object $$11;
            SpawnData.CustomSpawnRules $$9;
            ValueInput $$5 = TagValueInput.create((ProblemReporter)$$4, (HolderLookup.Provider)p_312582_.registryAccess(), $$3.entityToSpawn());
            Optional<EntityType<?>> $$6 = EntityType.by($$5);
            if ($$6.isEmpty()) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            Vec3 $$7 = $$5.read("Pos", Vec3.CODEC).orElseGet(() -> {
                TrialSpawnerConfig $$2 = this.activeConfig();
                return new Vec3((double)p_312518_.getX() + ($$2.nextDouble() - $$2.nextDouble()) * (double)$$2.spawnRange() + 0.5, p_312518_.getY() + $$2.nextInt(3) - 1, (double)p_312518_.getZ() + ($$2.nextDouble() - $$2.nextDouble()) * (double)$$2.spawnRange() + 0.5);
            });
            if (!p_312582_.noCollision($$6.get().getSpawnAABB($$7.x, $$7.y, $$7.z))) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            if (!TrialSpawner.inLineOfSight(p_312582_, p_312518_.getCenter(), $$7)) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            BlockPos $$8 = BlockPos.containing($$7);
            if (!SpawnPlacements.checkSpawnRules($$6.get(), p_312582_, EntitySpawnReason.TRIAL_SPAWNER, $$8, p_312582_.getRandom())) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            if ($$3.getCustomSpawnRules().isPresent() && !($$9 = $$3.getCustomSpawnRules().get()).isValidPosition($$8, p_312582_)) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            Entity $$10 = EntityType.loadEntityRecursive($$5, (Level)p_312582_, EntitySpawnReason.TRIAL_SPAWNER, p_404588_ -> {
                p_404588_.snapTo(p_404586_.x, p_404586_.y, p_404586_.z, $$2.nextFloat() * 360.0f, 0.0f);
                return p_404588_;
            });
            if ($$10 == null) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            if ($$10 instanceof Mob) {
                boolean $$12;
                $$11 = (Mob)$$10;
                if (!((Mob)$$11).checkSpawnObstruction(p_312582_)) {
                    Optional<UUID> optional = Optional.empty();
                    return optional;
                }
                boolean bl = $$12 = $$3.getEntityToSpawn().size() == 1 && $$3.getEntityToSpawn().getString("id").isPresent();
                if ($$12) {
                    ((Mob)$$11).finalizeSpawn(p_312582_, p_312582_.getCurrentDifficultyAt(((Entity)$$11).blockPosition()), EntitySpawnReason.TRIAL_SPAWNER, null);
                }
                ((Mob)$$11).setPersistenceRequired();
                $$3.getEquipment().ifPresent(((Mob)$$11)::equip);
            }
            if (!p_312582_.tryAddFreshEntityWithPassengers($$10)) {
                $$11 = Optional.empty();
                return $$11;
            }
            FlameParticle $$13 = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
            p_312582_.levelEvent(3011, p_312518_, $$13.encode());
            p_312582_.levelEvent(3012, $$8, $$13.encode());
            p_312582_.gameEvent($$10, GameEvent.ENTITY_PLACE, $$8);
            Optional<UUID> optional = Optional.of($$10.getUUID());
            return optional;
        }
    }

    public void ejectReward(ServerLevel p_312892_, BlockPos p_312668_, ResourceKey<LootTable> p_335942_) {
        LootParams $$4;
        LootTable $$3 = p_312892_.getServer().reloadableRegistries().getLootTable(p_335942_);
        ObjectArrayList<ItemStack> $$5 = $$3.getRandomItems($$4 = new LootParams.Builder(p_312892_).create(LootContextParamSets.EMPTY));
        if (!$$5.isEmpty()) {
            for (ItemStack $$6 : $$5) {
                DefaultDispenseItemBehavior.spawnItem(p_312892_, $$6, 2, Direction.UP, Vec3.atBottomCenterOf(p_312668_).relative(Direction.UP, 1.2));
            }
            p_312892_.levelEvent(3014, p_312668_, 0);
        }
    }

    public void tickClient(Level p_312771_, BlockPos p_312484_, boolean p_338382_) {
        RandomSource $$5;
        TrialSpawnerState $$3 = this.getState();
        $$3.emitParticles(p_312771_, p_312484_, p_338382_);
        if ($$3.hasSpinningMob()) {
            double $$4 = Math.max(0L, this.data.nextMobSpawnsAt - p_312771_.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + $$3.spinningMobSpeed() / ($$4 + 200.0)) % 360.0;
        }
        if ($$3.isCapableOfSpawning() && ($$5 = p_312771_.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent $$6 = p_338382_ ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            p_312771_.playLocalSound(p_312484_, $$6, SoundSource.BLOCKS, $$5.nextFloat() * 0.25f + 0.75f, $$5.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel p_312132_, BlockPos p_312062_, boolean p_338207_) {
        TrialSpawnerState $$4;
        this.isOminous = p_338207_;
        TrialSpawnerState $$3 = this.getState();
        if (this.data.currentMobs.removeIf(p_312870_ -> TrialSpawner.shouldMobBeUntracked(p_312132_, p_312062_, p_312870_))) {
            this.data.nextMobSpawnsAt = p_312132_.getGameTime() + (long)this.activeConfig().ticksBetweenSpawn();
        }
        if (($$4 = $$3.tickAndGetNext(p_312062_, this, p_312132_)) != $$3) {
            this.setState(p_312132_, $$4);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel p_312908_, BlockPos p_312807_, UUID p_311952_) {
        Entity $$3 = p_312908_.getEntity(p_311952_);
        return $$3 == null || !$$3.isAlive() || !$$3.level().dimension().equals(p_312908_.dimension()) || $$3.blockPosition().distSqr(p_312807_) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level p_312623_, Vec3 p_312390_, Vec3 p_312652_) {
        BlockHitResult $$3 = p_312623_.clip(new ClipContext(p_312652_, p_312390_, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return $$3.getBlockPos().equals(BlockPos.containing(p_312390_)) || $$3.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level p_312303_, BlockPos p_312392_, RandomSource p_312825_, SimpleParticleType p_338426_) {
        for (int $$4 = 0; $$4 < 20; ++$$4) {
            double $$5 = (double)p_312392_.getX() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            double $$6 = (double)p_312392_.getY() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            double $$7 = (double)p_312392_.getZ() + 0.5 + (p_312825_.nextDouble() - 0.5) * 2.0;
            p_312303_.addParticle(ParticleTypes.SMOKE, $$5, $$6, $$7, 0.0, 0.0, 0.0);
            p_312303_.addParticle(p_338426_, $$5, $$6, $$7, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level p_338657_, BlockPos p_338406_, RandomSource p_338527_) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)p_338406_.getX() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double $$5 = (double)p_338406_.getY() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double $$6 = (double)p_338406_.getZ() + 0.5 + (p_338527_.nextDouble() - 0.5) * 2.0;
            double $$7 = p_338527_.nextGaussian() * 0.02;
            double $$8 = p_338527_.nextGaussian() * 0.02;
            double $$9 = p_338527_.nextGaussian() * 0.02;
            p_338657_.addParticle(ParticleTypes.TRIAL_OMEN, $$4, $$5, $$6, $$7, $$8, $$9);
            p_338657_.addParticle(ParticleTypes.SOUL_FIRE_FLAME, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    public static void addDetectPlayerParticles(Level p_312225_, BlockPos p_311759_, RandomSource p_312553_, int p_312188_, ParticleOptions p_338522_) {
        for (int $$5 = 0; $$5 < 30 + Math.min(p_312188_, 10) * 5; ++$$5) {
            double $$6 = (double)(2.0f * p_312553_.nextFloat() - 1.0f) * 0.65;
            double $$7 = (double)(2.0f * p_312553_.nextFloat() - 1.0f) * 0.65;
            double $$8 = (double)p_311759_.getX() + 0.5 + $$6;
            double $$9 = (double)p_311759_.getY() + 0.1 + (double)p_312553_.nextFloat() * 0.8;
            double $$10 = (double)p_311759_.getZ() + 0.5 + $$7;
            p_312225_.addParticle(p_338522_, $$8, $$9, $$10, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level p_312009_, BlockPos p_312583_, RandomSource p_312715_) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)p_312583_.getX() + 0.4 + p_312715_.nextDouble() * 0.2;
            double $$5 = (double)p_312583_.getY() + 0.4 + p_312715_.nextDouble() * 0.2;
            double $$6 = (double)p_312583_.getZ() + 0.4 + p_312715_.nextDouble() * 0.2;
            double $$7 = p_312715_.nextGaussian() * 0.02;
            double $$8 = p_312715_.nextGaussian() * 0.02;
            double $$9 = p_312715_.nextGaussian() * 0.02;
            p_312009_.addParticle(ParticleTypes.SMALL_FLAME, $$4, $$5, $$6, $$7, $$8, $$9 * 0.25);
            p_312009_.addParticle(ParticleTypes.SMOKE, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    public void overrideEntityToSpawn(EntityType<?> p_387174_, Level p_386596_) {
        this.data.reset();
        this.config = this.config.overrideEntity(p_387174_);
        this.setState(p_386596_, TrialSpawnerState.INACTIVE);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector p_312510_) {
        this.playerDetector = p_312510_;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public record FullConfig(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous, int targetCooldownLength, int requiredPlayerRange) {
        public static final MapCodec<FullConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(p_422015_ -> p_422015_.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf("normal_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::normal), (App)TrialSpawnerConfig.CODEC.optionalFieldOf("ominous_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(FullConfig::ominous), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(FullConfig::targetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(FullConfig::requiredPlayerRange)).apply((Applicative)p_422015_, FullConfig::new));
        public static final FullConfig DEFAULT = new FullConfig(Holder.direct(TrialSpawnerConfig.DEFAULT), Holder.direct(TrialSpawnerConfig.DEFAULT), 36000, 14);

        public FullConfig overrideEntity(EntityType<?> p_422573_) {
            return new FullConfig(Holder.direct(this.normal.value().withSpawning(p_422573_)), Holder.direct(this.ominous.value().withSpawning(p_422573_)), this.targetCooldownLength, this.requiredPlayerRange);
        }
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType p_338374_) {
            this.particleType = p_338374_;
        }

        public static FlameParticle decode(int p_338695_) {
            FlameParticle[] $$1 = FlameParticle.values();
            if (p_338695_ > $$1.length || p_338695_ < 0) {
                return NORMAL;
            }
            return $$1[p_338695_];
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

