/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public interface PlayerDetector {
    public static final PlayerDetector NO_CREATIVE_PLAYERS = (p_338030_, p_338031_, p_338032_, p_338033_, p_338034_) -> p_338031_.getPlayers(p_338030_, p_427209_ -> p_427209_.blockPosition().closerThan(p_338032_, p_338033_) && !p_427209_.isCreative() && !p_427209_.isSpectator()).stream().filter(p_427198_ -> !p_338034_ || PlayerDetector.inLineOfSight(p_338030_, p_338032_.getCenter(), p_427198_.getEyePosition())).map(Entity::getUUID).toList();
    public static final PlayerDetector INCLUDING_CREATIVE_PLAYERS = (p_338015_, p_338016_, p_338017_, p_338018_, p_338019_) -> p_338016_.getPlayers(p_338015_, p_427212_ -> p_427212_.blockPosition().closerThan(p_338017_, p_338018_) && !p_427212_.isSpectator()).stream().filter(p_427206_ -> !p_338019_ || PlayerDetector.inLineOfSight(p_338015_, p_338017_.getCenter(), p_427206_.getEyePosition())).map(Entity::getUUID).toList();
    public static final PlayerDetector SHEEP = (p_338002_, p_338003_, p_338004_, p_338005_, p_338006_) -> {
        AABB $$5 = new AABB(p_338004_).inflate(p_338005_);
        return p_338003_.getEntities(p_338002_, EntityType.SHEEP, $$5, LivingEntity::isAlive).stream().filter(p_427202_ -> !p_338006_ || PlayerDetector.inLineOfSight(p_338002_, p_338004_.getCenter(), p_427202_.getEyePosition())).map(Entity::getUUID).toList();
    };

    public List<UUID> detect(ServerLevel var1, EntitySelector var2, BlockPos var3, double var4, boolean var6);

    private static boolean inLineOfSight(Level p_338760_, Vec3 p_338259_, Vec3 p_338810_) {
        BlockHitResult $$3 = p_338760_.clip(new ClipContext(p_338810_, p_338259_, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return $$3.getBlockPos().equals(BlockPos.containing(p_338259_)) || $$3.getType() == HitResult.Type.MISS;
    }

    public static interface EntitySelector {
        public static final EntitySelector SELECT_FROM_LEVEL = new EntitySelector(){

            public List<ServerPlayer> getPlayers(ServerLevel p_323695_, Predicate<? super Player> p_324206_) {
                return p_323695_.getPlayers(p_324206_);
            }

            @Override
            public <T extends Entity> List<T> getEntities(ServerLevel p_324491_, EntityTypeTest<Entity, T> p_323728_, AABB p_324572_, Predicate<? super T> p_323881_) {
                return p_324491_.getEntities(p_323728_, p_324572_, p_323881_);
            }
        };

        public List<? extends Player> getPlayers(ServerLevel var1, Predicate<? super Player> var2);

        public <T extends Entity> List<T> getEntities(ServerLevel var1, EntityTypeTest<Entity, T> var2, AABB var3, Predicate<? super T> var4);

        public static EntitySelector onlySelectPlayer(Player p_324540_) {
            return EntitySelector.onlySelectPlayers(List.of(p_324540_));
        }

        public static EntitySelector onlySelectPlayers(final List<Player> p_323995_) {
            return new EntitySelector(){

                public List<Player> getPlayers(ServerLevel p_323585_, Predicate<? super Player> p_323950_) {
                    return p_323995_.stream().filter(p_323950_).toList();
                }

                @Override
                public <T extends Entity> List<T> getEntities(ServerLevel p_324352_, EntityTypeTest<Entity, T> p_323526_, AABB p_324544_, Predicate<? super T> p_323570_) {
                    return p_323995_.stream().map(p_323526_::tryCast).filter(Objects::nonNull).filter(p_323570_).toList();
                }
            };
        }
    }
}

