/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class SculkShriekerBlockEntity
extends BlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    private static final int WARNING_SOUND_RADIUS = 10;
    private static final int WARDEN_SPAWN_ATTEMPTS = 20;
    private static final int WARDEN_SPAWN_RANGE_XZ = 5;
    private static final int WARDEN_SPAWN_RANGE_Y = 6;
    private static final int DARKNESS_RADIUS = 40;
    private static final int SHRIEKING_TICKS = 90;
    private static final Int2ObjectMap<SoundEvent> SOUND_BY_LEVEL = (Int2ObjectMap)Util.make(new Int2ObjectOpenHashMap(), p_222866_ -> {
        p_222866_.put(1, (Object)SoundEvents.WARDEN_NEARBY_CLOSE);
        p_222866_.put(2, (Object)SoundEvents.WARDEN_NEARBY_CLOSER);
        p_222866_.put(3, (Object)SoundEvents.WARDEN_NEARBY_CLOSEST);
        p_222866_.put(4, (Object)SoundEvents.WARDEN_LISTENING_ANGRY);
    });
    private static final int DEFAULT_WARNING_LEVEL = 0;
    private int warningLevel = 0;
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener(this);

    public SculkShriekerBlockEntity(BlockPos p_222835_, BlockState p_222836_) {
        super(BlockEntityType.SCULK_SHRIEKER, p_222835_, p_222836_);
    }

    @Override
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    @Override
    protected void loadAdditional(ValueInput p_422415_) {
        super.loadAdditional(p_422415_);
        this.warningLevel = p_422415_.getIntOr("warning_level", 0);
        this.vibrationData = p_422415_.read("listener", VibrationSystem.Data.CODEC).orElseGet(VibrationSystem.Data::new);
    }

    @Override
    protected void saveAdditional(ValueOutput p_422120_) {
        super.saveAdditional(p_422120_);
        p_422120_.putInt("warning_level", this.warningLevel);
        p_422120_.store("listener", VibrationSystem.Data.CODEC, this.vibrationData);
    }

    @Nullable
    public static ServerPlayer tryGetPlayer(@Nullable Entity p_222862_) {
        ItemEntity $$5;
        Projectile $$3;
        Entity entity;
        LivingEntity livingEntity;
        if (p_222862_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_222862_;
            return $$1;
        }
        if (p_222862_ != null && (livingEntity = p_222862_.getControllingPassenger()) instanceof ServerPlayer) {
            ServerPlayer $$2 = (ServerPlayer)livingEntity;
            return $$2;
        }
        if (p_222862_ instanceof Projectile && (entity = ($$3 = (Projectile)p_222862_).getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$4 = (ServerPlayer)entity;
            return $$4;
        }
        if (p_222862_ instanceof ItemEntity && (entity = ($$5 = (ItemEntity)p_222862_).getOwner()) instanceof ServerPlayer) {
            ServerPlayer $$6 = (ServerPlayer)entity;
            return $$6;
        }
        return null;
    }

    public void tryShriek(ServerLevel p_222842_, @Nullable ServerPlayer p_222843_) {
        if (p_222843_ == null) {
            return;
        }
        BlockState $$2 = this.getBlockState();
        if ($$2.getValue(SculkShriekerBlock.SHRIEKING).booleanValue()) {
            return;
        }
        this.warningLevel = 0;
        if (this.canRespond(p_222842_) && !this.tryToWarn(p_222842_, p_222843_)) {
            return;
        }
        this.shriek(p_222842_, p_222843_);
    }

    private boolean tryToWarn(ServerLevel p_222875_, ServerPlayer p_222876_) {
        OptionalInt $$2 = WardenSpawnTracker.tryWarn(p_222875_, this.getBlockPos(), p_222876_);
        $$2.ifPresent(p_222838_ -> {
            this.warningLevel = p_222838_;
        });
        return $$2.isPresent();
    }

    private void shriek(ServerLevel p_222845_, @Nullable Entity p_222846_) {
        BlockPos $$2 = this.getBlockPos();
        BlockState $$3 = this.getBlockState();
        p_222845_.setBlock($$2, (BlockState)$$3.setValue(SculkShriekerBlock.SHRIEKING, true), 2);
        p_222845_.scheduleTick($$2, $$3.getBlock(), 90);
        p_222845_.levelEvent(3007, $$2, 0);
        p_222845_.gameEvent(GameEvent.SHRIEK, $$2, GameEvent.Context.of(p_222846_));
    }

    private boolean canRespond(ServerLevel p_222873_) {
        return this.getBlockState().getValue(SculkShriekerBlock.CAN_SUMMON) != false && p_222873_.getDifficulty() != Difficulty.PEACEFUL && p_222873_.getGameRules().getBoolean(GameRules.RULE_DO_WARDEN_SPAWNING);
    }

    @Override
    public void preRemoveSideEffects(BlockPos p_394217_, BlockState p_393528_) {
        Level level;
        if (p_393528_.getValue(SculkShriekerBlock.SHRIEKING).booleanValue() && (level = this.level) instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            this.tryRespond($$2);
        }
    }

    public void tryRespond(ServerLevel p_222840_) {
        if (this.canRespond(p_222840_) && this.warningLevel > 0) {
            if (!this.trySummonWarden(p_222840_)) {
                this.playWardenReplySound(p_222840_);
            }
            Warden.applyDarknessAround(p_222840_, Vec3.atCenterOf(this.getBlockPos()), null, 40);
        }
    }

    private void playWardenReplySound(Level p_281300_) {
        SoundEvent $$1 = (SoundEvent)SOUND_BY_LEVEL.get(this.warningLevel);
        if ($$1 != null) {
            BlockPos $$2 = this.getBlockPos();
            int $$3 = $$2.getX() + Mth.randomBetweenInclusive(p_281300_.random, -10, 10);
            int $$4 = $$2.getY() + Mth.randomBetweenInclusive(p_281300_.random, -10, 10);
            int $$5 = $$2.getZ() + Mth.randomBetweenInclusive(p_281300_.random, -10, 10);
            p_281300_.playSound(null, (double)$$3, (double)$$4, (double)$$5, $$1, SoundSource.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(ServerLevel p_222881_) {
        if (this.warningLevel < 4) {
            return false;
        }
        return SpawnUtil.trySpawnMob(EntityType.WARDEN, EntitySpawnReason.TRIGGERED, p_222881_, this.getBlockPos(), 20, 5, 6, SpawnUtil.Strategy.ON_TOP_OF_COLLIDER, false).isPresent();
    }

    @Override
    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    @Override
    public /* synthetic */ GameEventListener getListener() {
        return this.getListener();
    }

    class VibrationUser
    implements VibrationSystem.User {
        private static final int LISTENER_RADIUS = 8;
        private final PositionSource positionSource;

        public VibrationUser() {
            this.positionSource = new BlockPositionSource(SculkShriekerBlockEntity.this.worldPosition);
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.SHRIEKER_CAN_LISTEN;
        }

        @Override
        public boolean canReceiveVibration(ServerLevel p_281256_, BlockPos p_281528_, Holder<GameEvent> p_316788_, GameEvent.Context p_282914_) {
            return SculkShriekerBlockEntity.this.getBlockState().getValue(SculkShriekerBlock.SHRIEKING) == false && SculkShriekerBlockEntity.tryGetPlayer(p_282914_.sourceEntity()) != null;
        }

        @Override
        public void onReceiveVibration(ServerLevel p_283372_, BlockPos p_281679_, Holder<GameEvent> p_316155_, @Nullable Entity p_282286_, @Nullable Entity p_281384_, float p_283119_) {
            SculkShriekerBlockEntity.this.tryShriek(p_283372_, SculkShriekerBlockEntity.tryGetPlayer(p_281384_ != null ? p_281384_ : p_282286_));
        }

        @Override
        public void onDataChanged() {
            SculkShriekerBlockEntity.this.setChanged();
        }

        @Override
        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

