/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DispenserBlockEntity
extends RandomizableContainerBlockEntity {
    public static final int CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> items = NonNullList.withSize(9, ItemStack.EMPTY);

    protected DispenserBlockEntity(BlockEntityType<?> p_155489_, BlockPos p_155490_, BlockState p_155491_) {
        super(p_155489_, p_155490_, p_155491_);
    }

    public DispenserBlockEntity(BlockPos p_155493_, BlockState p_155494_) {
        this(BlockEntityType.DISPENSER, p_155493_, p_155494_);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    public int getRandomSlot(RandomSource p_222762_) {
        this.unpackLootTable(null);
        int $$1 = -1;
        int $$2 = 1;
        for (int $$3 = 0; $$3 < this.items.size(); ++$$3) {
            if (this.items.get($$3).isEmpty() || p_222762_.nextInt($$2++) != 0) continue;
            $$1 = $$3;
        }
        return $$1;
    }

    public ItemStack insertItem(ItemStack p_347519_) {
        int $$1 = this.getMaxStackSize(p_347519_);
        for (int $$2 = 0; $$2 < this.items.size(); ++$$2) {
            ItemStack $$3 = this.items.get($$2);
            if (!$$3.isEmpty() && !ItemStack.isSameItemSameComponents(p_347519_, $$3)) continue;
            int $$4 = Math.min(p_347519_.getCount(), $$1 - $$3.getCount());
            if ($$4 > 0) {
                if ($$3.isEmpty()) {
                    this.setItem($$2, p_347519_.split($$4));
                } else {
                    p_347519_.shrink($$4);
                    $$3.grow($$4);
                }
            }
            if (p_347519_.isEmpty()) break;
        }
        return p_347519_;
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable("container.dispenser");
    }

    @Override
    protected void loadAdditional(ValueInput p_421597_) {
        super.loadAdditional(p_421597_);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(p_421597_)) {
            ContainerHelper.loadAllItems(p_421597_, this.items);
        }
    }

    @Override
    protected void saveAdditional(ValueOutput p_422073_) {
        super.saveAdditional(p_422073_);
        if (!this.trySaveLootTable(p_422073_)) {
            ContainerHelper.saveAllItems(p_422073_, this.items);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> p_59243_) {
        this.items = p_59243_;
    }

    @Override
    protected AbstractContainerMenu createMenu(int p_59235_, Inventory p_59236_) {
        return new DispenserMenu(p_59235_, p_59236_, this);
    }
}

