/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    private ItemStack item = ItemStack.EMPTY;
    @Nullable
    private Direction hitDirection;
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;

    public BrushableBlockEntity(BlockPos p_277558_, BlockState p_278093_) {
        super(BlockEntityType.BRUSHABLE_BLOCK, p_277558_, p_278093_);
    }

    public boolean brush(long p_277786_, ServerLevel p_373105_, LivingEntity p_393879_, Direction p_277424_, ItemStack p_372848_) {
        if (this.hitDirection == null) {
            this.hitDirection = p_277424_;
        }
        this.brushCountResetsAtTick = p_277786_ + 40L;
        if (p_277786_ < this.coolDownEndsAtTick) {
            return false;
        }
        this.coolDownEndsAtTick = p_277786_ + 10L;
        this.unpackLootTable(p_373105_, p_393879_, p_372848_);
        int $$5 = this.getCompletionState();
        if (++this.brushCount >= 10) {
            this.brushingCompleted(p_373105_, p_393879_, p_372848_);
            return true;
        }
        p_373105_.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
        int $$6 = this.getCompletionState();
        if ($$5 != $$6) {
            BlockState $$7 = this.getBlockState();
            BlockState $$8 = (BlockState)$$7.setValue(BlockStateProperties.DUSTED, $$6);
            p_373105_.setBlock(this.getBlockPos(), $$8, 3);
        }
        return false;
    }

    private void unpackLootTable(ServerLevel p_373015_, LivingEntity p_394489_, ItemStack p_372798_) {
        if (this.lootTable == null) {
            return;
        }
        LootTable $$3 = p_373015_.getServer().reloadableRegistries().getLootTable(this.lootTable);
        if (p_394489_ instanceof ServerPlayer) {
            ServerPlayer $$4 = (ServerPlayer)p_394489_;
            CriteriaTriggers.GENERATE_LOOT.trigger($$4, this.lootTable);
        }
        LootParams $$5 = new LootParams.Builder(p_373015_).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(this.worldPosition)).withLuck(p_394489_.getLuck()).withParameter(LootContextParams.THIS_ENTITY, p_394489_).withParameter(LootContextParams.TOOL, p_372798_).create(LootContextParamSets.ARCHAEOLOGY);
        ObjectArrayList<ItemStack> $$6 = $$3.getRandomItems($$5, this.lootTableSeed);
        this.item = switch ($$6.size()) {
            case 0 -> ItemStack.EMPTY;
            case 1 -> (ItemStack)$$6.getFirst();
            default -> {
                LOGGER.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.lootTable.location(), (Object)$$6.size());
                yield (ItemStack)$$6.getFirst();
            }
        };
        this.lootTable = null;
        this.setChanged();
    }

    private void brushingCompleted(ServerLevel p_373046_, LivingEntity p_394011_, ItemStack p_373073_) {
        Block $$7;
        this.dropContent(p_373046_, p_394011_, p_373073_);
        BlockState $$3 = this.getBlockState();
        p_373046_.levelEvent(3008, this.getBlockPos(), Block.getId($$3));
        Block $$4 = this.getBlockState().getBlock();
        if ($$4 instanceof BrushableBlock) {
            BrushableBlock $$5 = (BrushableBlock)$$4;
            Block $$6 = $$5.getTurnsInto();
        } else {
            $$7 = Blocks.AIR;
        }
        p_373046_.setBlock(this.worldPosition, $$7.defaultBlockState(), 3);
    }

    private void dropContent(ServerLevel p_373112_, LivingEntity p_393620_, ItemStack p_372836_) {
        this.unpackLootTable(p_373112_, p_393620_, p_372836_);
        if (!this.item.isEmpty()) {
            double $$3 = EntityType.ITEM.getWidth();
            double $$4 = 1.0 - $$3;
            double $$5 = $$3 / 2.0;
            Direction $$6 = Objects.requireNonNullElse(this.hitDirection, Direction.UP);
            BlockPos $$7 = this.worldPosition.relative($$6, 1);
            double $$8 = (double)$$7.getX() + 0.5 * $$4 + $$5;
            double $$9 = (double)$$7.getY() + 0.5 + (double)(EntityType.ITEM.getHeight() / 2.0f);
            double $$10 = (double)$$7.getZ() + 0.5 * $$4 + $$5;
            ItemEntity $$11 = new ItemEntity(p_373112_, $$8, $$9, $$10, this.item.split(p_373112_.random.nextInt(21) + 10));
            $$11.setDeltaMovement(Vec3.ZERO);
            p_373112_.addFreshEntity($$11);
            this.item = ItemStack.EMPTY;
        }
    }

    public void checkReset(ServerLevel p_372947_) {
        if (this.brushCount != 0 && p_372947_.getGameTime() >= this.brushCountResetsAtTick) {
            int $$1 = this.getCompletionState();
            this.brushCount = Math.max(0, this.brushCount - 2);
            int $$2 = this.getCompletionState();
            if ($$1 != $$2) {
                p_372947_.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(BlockStateProperties.DUSTED, $$2), 3);
            }
            int $$3 = 4;
            this.brushCountResetsAtTick = p_372947_.getGameTime() + 4L;
        }
        if (this.brushCount == 0) {
            this.hitDirection = null;
            this.brushCountResetsAtTick = 0L;
            this.coolDownEndsAtTick = 0L;
        } else {
            p_372947_.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
        }
    }

    private boolean tryLoadLootTable(ValueInput p_422032_) {
        this.lootTable = p_422032_.read(LOOT_TABLE_TAG, LootTable.KEY_CODEC).orElse(null);
        this.lootTableSeed = p_422032_.getLongOr(LOOT_TABLE_SEED_TAG, 0L);
        return this.lootTable != null;
    }

    private boolean trySaveLootTable(ValueOutput p_421941_) {
        if (this.lootTable == null) {
            return false;
        }
        p_421941_.store(LOOT_TABLE_TAG, LootTable.KEY_CODEC, this.lootTable);
        if (this.lootTableSeed != 0L) {
            p_421941_.putLong(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider p_323531_) {
        CompoundTag $$1 = super.getUpdateTag(p_323531_);
        $$1.storeNullable(HIT_DIRECTION_TAG, Direction.LEGACY_ID_CODEC, this.hitDirection);
        if (!this.item.isEmpty()) {
            RegistryOps<Tag> $$2 = p_323531_.createSerializationContext(NbtOps.INSTANCE);
            $$1.store(ITEM_TAG, ItemStack.CODEC, $$2, this.item);
        }
        return $$1;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    protected void loadAdditional(ValueInput p_422299_) {
        super.loadAdditional(p_422299_);
        this.item = !this.tryLoadLootTable(p_422299_) ? p_422299_.read(ITEM_TAG, ItemStack.CODEC).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.hitDirection = p_422299_.read(HIT_DIRECTION_TAG, Direction.LEGACY_ID_CODEC).orElse(null);
    }

    @Override
    protected void saveAdditional(ValueOutput p_421746_) {
        super.saveAdditional(p_421746_);
        if (!this.trySaveLootTable(p_421746_) && !this.item.isEmpty()) {
            p_421746_.store(ITEM_TAG, ItemStack.CODEC, this.item);
        }
    }

    public void setLootTable(ResourceKey<LootTable> p_335433_, long p_277991_) {
        this.lootTable = p_335433_;
        this.lootTableSeed = p_277991_;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        if (this.brushCount < 6) {
            return 2;
        }
        return 3;
    }

    @Nullable
    public Direction getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

