/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class BeehiveBlockEntity
extends BlockEntity {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_FLOWER_POS = "flower_pos";
    private static final String BEES = "bees";
    static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "drop_chances", "equipment", "Brain", "CanPickUpLoot", "DeathTime", "fall_distance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "sleeping_pos", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private final List<BeeData> stored = Lists.newArrayList();
    @Nullable
    private BlockPos savedFlowerPos;

    public BeehiveBlockEntity(BlockPos p_155134_, BlockState p_155135_) {
        super(BlockEntityType.BEEHIVE, p_155134_, p_155135_);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), BeeReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        if (this.level == null) {
            return false;
        }
        for (BlockPos $$0 : BlockPos.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1))) {
            if (!(this.level.getBlockState($$0).getBlock() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 3;
    }

    public void emptyAllLivingFromHive(@Nullable Player p_58749_, BlockState p_58750_, BeeReleaseStatus p_58751_) {
        List<Entity> $$3 = this.releaseAllOccupants(p_58750_, p_58751_);
        if (p_58749_ != null) {
            for (Entity $$4 : $$3) {
                if (!($$4 instanceof Bee)) continue;
                Bee $$5 = (Bee)$$4;
                if (!(p_58749_.position().distanceToSqr($$4.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    $$5.setTarget(p_58749_);
                    continue;
                }
                $$5.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<Entity> releaseAllOccupants(BlockState p_58760_, BeeReleaseStatus p_58761_) {
        ArrayList $$2 = Lists.newArrayList();
        this.stored.removeIf(p_330138_ -> BeehiveBlockEntity.releaseOccupant(this.level, this.worldPosition, p_58760_, p_330138_.toOccupant(), $$2, p_58761_, this.savedFlowerPos));
        if (!$$2.isEmpty()) {
            super.setChanged();
        }
        return $$2;
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public static int getHoneyLevel(BlockState p_58753_) {
        return p_58753_.getValue(BeehiveBlock.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return CampfireBlock.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupant(Bee p_389531_) {
        if (this.stored.size() >= 3) {
            return;
        }
        p_389531_.stopRiding();
        p_389531_.ejectPassengers();
        p_389531_.dropLeash();
        this.storeBee(Occupant.of(p_389531_));
        if (this.level != null) {
            if (p_389531_.hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                this.savedFlowerPos = p_389531_.getSavedFlowerPos();
            }
            BlockPos $$1 = this.getBlockPos();
            this.level.playSound(null, (double)$$1.getX(), (double)$$1.getY(), (double)$$1.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, $$1, GameEvent.Context.of(p_389531_, this.getBlockState()));
        }
        p_389531_.discard();
        super.setChanged();
    }

    public void storeBee(Occupant p_330820_) {
        this.stored.add(new BeeData(p_330820_));
    }

    private static boolean releaseOccupant(Level p_155137_, BlockPos p_155138_, BlockState p_155139_, Occupant p_332184_, @Nullable List<Entity> p_155141_, BeeReleaseStatus p_155142_, @Nullable BlockPos p_155143_) {
        boolean $$9;
        if (Bee.isNightOrRaining(p_155137_) && p_155142_ != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Direction $$7 = p_155139_.getValue(BeehiveBlock.FACING);
        BlockPos $$8 = p_155138_.relative($$7);
        boolean bl = $$9 = !p_155137_.getBlockState($$8).getCollisionShape(p_155137_, $$8).isEmpty();
        if ($$9 && p_155142_ != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity $$10 = p_332184_.createEntity(p_155137_, p_155138_);
        if ($$10 != null) {
            if ($$10 instanceof Bee) {
                Bee $$11 = (Bee)$$10;
                if (p_155143_ != null && !$$11.hasSavedFlowerPos() && p_155137_.random.nextFloat() < 0.9f) {
                    $$11.setSavedFlowerPos(p_155143_);
                }
                if (p_155142_ == BeeReleaseStatus.HONEY_DELIVERED) {
                    int $$12;
                    $$11.dropOffNectar();
                    if (p_155139_.is(BlockTags.BEEHIVES, p_202037_ -> p_202037_.hasProperty(BeehiveBlock.HONEY_LEVEL)) && ($$12 = BeehiveBlockEntity.getHoneyLevel(p_155139_)) < 5) {
                        int $$13;
                        int n = $$13 = p_155137_.random.nextInt(100) == 0 ? 2 : 1;
                        if ($$12 + $$13 > 5) {
                            --$$13;
                        }
                        p_155137_.setBlockAndUpdate(p_155138_, (BlockState)p_155139_.setValue(BeehiveBlock.HONEY_LEVEL, $$12 + $$13));
                    }
                }
                if (p_155141_ != null) {
                    p_155141_.add($$11);
                }
                float $$14 = $$10.getBbWidth();
                double $$15 = $$9 ? 0.0 : 0.55 + (double)($$14 / 2.0f);
                double $$16 = (double)p_155138_.getX() + 0.5 + $$15 * (double)$$7.getStepX();
                double $$17 = (double)p_155138_.getY() + 0.5 - (double)($$10.getBbHeight() / 2.0f);
                double $$18 = (double)p_155138_.getZ() + 0.5 + $$15 * (double)$$7.getStepZ();
                $$10.snapTo($$16, $$17, $$18, $$10.getYRot(), $$10.getXRot());
            }
            p_155137_.playSound(null, p_155138_, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_155137_.gameEvent(GameEvent.BLOCK_CHANGE, p_155138_, GameEvent.Context.of($$10, p_155137_.getBlockState(p_155138_)));
            return p_155137_.addFreshEntity($$10);
        }
        return false;
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(Level p_155150_, BlockPos p_155151_, BlockState p_155152_, List<BeeData> p_155153_, @Nullable BlockPos p_155154_) {
        boolean $$5 = false;
        Iterator<BeeData> $$6 = p_155153_.iterator();
        while ($$6.hasNext()) {
            BeeReleaseStatus $$8;
            BeeData $$7 = $$6.next();
            if (!$$7.tick()) continue;
            BeeReleaseStatus beeReleaseStatus = $$8 = $$7.hasNectar() ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
            if (!BeehiveBlockEntity.releaseOccupant(p_155150_, p_155151_, p_155152_, $$7.toOccupant(), null, $$8, p_155154_)) continue;
            $$5 = true;
            $$6.remove();
        }
        if ($$5) {
            BeehiveBlockEntity.setChanged(p_155150_, p_155151_, p_155152_);
        }
    }

    public static void serverTick(Level p_155145_, BlockPos p_155146_, BlockState p_155147_, BeehiveBlockEntity p_155148_) {
        BeehiveBlockEntity.tickOccupants(p_155145_, p_155146_, p_155147_, p_155148_.stored, p_155148_.savedFlowerPos);
        if (!p_155148_.stored.isEmpty() && p_155145_.getRandom().nextDouble() < 0.005) {
            double $$4 = (double)p_155146_.getX() + 0.5;
            double $$5 = p_155146_.getY();
            double $$6 = (double)p_155146_.getZ() + 0.5;
            p_155145_.playSound(null, $$4, $$5, $$6, SoundEvents.BEEHIVE_WORK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        DebugPackets.sendHiveInfo(p_155145_, p_155146_, p_155147_, p_155148_);
    }

    @Override
    protected void loadAdditional(ValueInput p_422386_) {
        super.loadAdditional(p_422386_);
        this.stored.clear();
        p_422386_.read(BEES, Occupant.LIST_CODEC).orElse(List.of()).forEach(this::storeBee);
        this.savedFlowerPos = p_422386_.read(TAG_FLOWER_POS, BlockPos.CODEC).orElse(null);
    }

    @Override
    protected void saveAdditional(ValueOutput p_422298_) {
        super.saveAdditional(p_422298_);
        p_422298_.store(BEES, Occupant.LIST_CODEC, this.getBees());
        p_422298_.storeNullable(TAG_FLOWER_POS, BlockPos.CODEC, this.savedFlowerPos);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397481_) {
        super.applyImplicitComponents(p_397481_);
        this.stored.clear();
        List<Occupant> $$1 = p_397481_.getOrDefault(DataComponents.BEES, Bees.EMPTY).bees();
        $$1.forEach(this::storeBee);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338773_) {
        super.collectImplicitComponents(p_338773_);
        p_338773_.set(DataComponents.BEES, new Bees(this.getBees()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput p_422198_) {
        super.removeComponentsFromTag(p_422198_);
        p_422198_.discard(BEES);
    }

    private List<Occupant> getBees() {
        return this.stored.stream().map(BeeData::toOccupant).toList();
    }

    public static enum BeeReleaseStatus {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    public record Occupant(CustomData entityData, int ticksInHive, int minTicksInHive) {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(p_337984_ -> p_337984_.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(Occupant::ticksInHive), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(Occupant::minTicksInHive)).apply((Applicative)p_337984_, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<ByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite(CustomData.STREAM_CODEC, Occupant::entityData, ByteBufCodecs.VAR_INT, Occupant::ticksInHive, ByteBufCodecs.VAR_INT, Occupant::minTicksInHive, Occupant::new);

        public static Occupant of(Entity p_331485_) {
            try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector(p_331485_.problemPath(), LOGGER);){
                TagValueOutput $$2 = TagValueOutput.createWithContext($$1, p_331485_.registryAccess());
                p_331485_.save($$2);
                IGNORED_BEE_TAGS.forEach($$2::discard);
                CompoundTag $$3 = $$2.buildResult();
                boolean $$4 = $$3.getBooleanOr("HasNectar", false);
                Occupant occupant = new Occupant(CustomData.of($$3), 0, $$4 ? 2400 : 600);
                return occupant;
            }
        }

        public static Occupant create(int p_331115_) {
            CompoundTag $$1 = new CompoundTag();
            $$1.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(EntityType.BEE).toString());
            return new Occupant(CustomData.of($$1), p_331115_, 600);
        }

        @Nullable
        public Entity createEntity(Level p_331790_, BlockPos p_330712_) {
            CompoundTag $$2 = this.entityData.copyTag();
            IGNORED_BEE_TAGS.forEach($$2::remove);
            Entity $$3 = EntityType.loadEntityRecursive($$2, p_331790_, EntitySpawnReason.LOAD, p_331097_ -> p_331097_);
            if ($$3 == null || !$$3.getType().is(EntityTypeTags.BEEHIVE_INHABITORS)) {
                return null;
            }
            $$3.setNoGravity(true);
            if ($$3 instanceof Bee) {
                Bee $$4 = (Bee)$$3;
                $$4.setHivePos(p_330712_);
                Occupant.setBeeReleaseData(this.ticksInHive, $$4);
            }
            return $$3;
        }

        private static void setBeeReleaseData(int p_331728_, Bee p_331988_) {
            int $$2 = p_331988_.getAge();
            if ($$2 < 0) {
                p_331988_.setAge(Math.min(0, $$2 + p_331728_));
            } else if ($$2 > 0) {
                p_331988_.setAge(Math.max(0, $$2 - p_331728_));
            }
            p_331988_.setInLoveTime(Math.max(0, p_331988_.getInLoveTime() - p_331728_));
        }
    }

    static class BeeData {
        private final Occupant occupant;
        private int ticksInHive;

        BeeData(Occupant p_331832_) {
            this.occupant = p_331832_;
            this.ticksInHive = p_331832_.ticksInHive();
        }

        public boolean tick() {
            return this.ticksInHive++ > this.occupant.minTicksInHive;
        }

        public Occupant toOccupant() {
            return new Occupant(this.occupant.entityData, this.ticksInHive, this.occupant.minTicksInHive);
        }

        public boolean hasNectar() {
            return this.occupant.entityData.getUnsafe().getBooleanOr("HasNectar", false);
        }
    }
}

