/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VineBlock
extends Block {
    public static final MapCodec<VineBlock> CODEC = VineBlock.simpleCodec(VineBlock::new);
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.toMap());
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<VineBlock> codec() {
        return CODEC;
    }

    public VineBlock(BlockBehaviour.Properties p_57847_) {
        super(p_57847_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> $$0 = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(p_393379_ -> {
            VoxelShape $$2 = Shapes.empty();
            for (Map.Entry<Direction, BooleanProperty> $$3 : PROPERTY_BY_DIRECTION.entrySet()) {
                if (!((Boolean)p_393379_.getValue($$3.getValue())).booleanValue()) continue;
                $$2 = Shapes.or($$2, (VoxelShape)$$0.get($$3.getKey()));
            }
            return $$2.isEmpty() ? Shapes.block() : $$2;
        });
    }

    @Override
    protected VoxelShape getShape(BlockState p_57897_, BlockGetter p_57898_, BlockPos p_57899_, CollisionContext p_57900_) {
        return this.shapes.apply(p_57897_);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_181239_) {
        return true;
    }

    @Override
    protected boolean canSurvive(BlockState p_57861_, LevelReader p_57862_, BlockPos p_57863_) {
        return this.hasFaces(this.getUpdatedState(p_57861_, p_57862_, p_57863_));
    }

    private boolean hasFaces(BlockState p_57908_) {
        return this.countFaces(p_57908_) > 0;
    }

    private int countFaces(BlockState p_57910_) {
        int $$1 = 0;
        for (BooleanProperty $$2 : PROPERTY_BY_DIRECTION.values()) {
            if (!p_57910_.getValue($$2).booleanValue()) continue;
            ++$$1;
        }
        return $$1;
    }

    private boolean canSupportAtFace(BlockGetter p_57888_, BlockPos p_57889_, Direction p_57890_) {
        if (p_57890_ == Direction.DOWN) {
            return false;
        }
        BlockPos $$3 = p_57889_.relative(p_57890_);
        if (VineBlock.isAcceptableNeighbour(p_57888_, $$3, p_57890_)) {
            return true;
        }
        if (p_57890_.getAxis() != Direction.Axis.Y) {
            BooleanProperty $$4 = PROPERTY_BY_DIRECTION.get(p_57890_);
            BlockState $$5 = p_57888_.getBlockState(p_57889_.above());
            return $$5.is(this) && $$5.getValue($$4) != false;
        }
        return false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter p_57854_, BlockPos p_57855_, Direction p_57856_) {
        return MultifaceBlock.canAttachTo(p_57854_, p_57856_, p_57855_, p_57854_.getBlockState(p_57855_));
    }

    private BlockState getUpdatedState(BlockState p_57902_, BlockGetter p_57903_, BlockPos p_57904_) {
        BlockPos $$3 = p_57904_.above();
        if (p_57902_.getValue(UP).booleanValue()) {
            p_57902_ = (BlockState)p_57902_.setValue(UP, VineBlock.isAcceptableNeighbour(p_57903_, $$3, Direction.DOWN));
        }
        BlockBehaviour.BlockStateBase $$4 = null;
        for (Direction $$5 : Direction.Plane.HORIZONTAL) {
            BooleanProperty $$6 = VineBlock.getPropertyForFace($$5);
            if (!p_57902_.getValue($$6).booleanValue()) continue;
            boolean $$7 = this.canSupportAtFace(p_57903_, p_57904_, $$5);
            if (!$$7) {
                if ($$4 == null) {
                    $$4 = p_57903_.getBlockState($$3);
                }
                $$7 = $$4.is(this) && $$4.getValue($$6) != false;
            }
            p_57902_ = (BlockState)p_57902_.setValue($$6, $$7);
        }
        return p_57902_;
    }

    @Override
    protected BlockState updateShape(BlockState p_57875_, LevelReader p_374150_, ScheduledTickAccess p_374192_, BlockPos p_57879_, Direction p_57876_, BlockPos p_57880_, BlockState p_57877_, RandomSource p_374278_) {
        if (p_57876_ == Direction.DOWN) {
            return super.updateShape(p_57875_, p_374150_, p_374192_, p_57879_, p_57876_, p_57880_, p_57877_, p_374278_);
        }
        BlockState $$8 = this.getUpdatedState(p_57875_, p_374150_, p_57879_);
        if (!this.hasFaces($$8)) {
            return Blocks.AIR.defaultBlockState();
        }
        return $$8;
    }

    @Override
    protected void randomTick(BlockState p_222655_, ServerLevel p_222656_, BlockPos p_222657_, RandomSource p_222658_) {
        BlockState $$20;
        BlockState $$19;
        BlockPos $$17;
        BlockState $$18;
        if (!p_222656_.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD)) {
            return;
        }
        if (p_222658_.nextInt(4) != 0) {
            return;
        }
        Direction $$4 = Direction.getRandom(p_222658_);
        BlockPos $$5 = p_222657_.above();
        if ($$4.getAxis().isHorizontal() && !p_222655_.getValue(VineBlock.getPropertyForFace($$4)).booleanValue()) {
            if (!this.canSpread(p_222656_, p_222657_)) {
                return;
            }
            BlockPos $$6 = p_222657_.relative($$4);
            BlockState $$7 = p_222656_.getBlockState($$6);
            if ($$7.isAir()) {
                Direction $$8 = $$4.getClockWise();
                Direction $$9 = $$4.getCounterClockWise();
                boolean $$10 = p_222655_.getValue(VineBlock.getPropertyForFace($$8));
                boolean $$11 = p_222655_.getValue(VineBlock.getPropertyForFace($$9));
                BlockPos $$12 = $$6.relative($$8);
                BlockPos $$13 = $$6.relative($$9);
                if ($$10 && VineBlock.isAcceptableNeighbour(p_222656_, $$12, $$8)) {
                    p_222656_.setBlock($$6, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace($$8), true), 2);
                } else if ($$11 && VineBlock.isAcceptableNeighbour(p_222656_, $$13, $$9)) {
                    p_222656_.setBlock($$6, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace($$9), true), 2);
                } else {
                    Direction $$14 = $$4.getOpposite();
                    if ($$10 && p_222656_.isEmptyBlock($$12) && VineBlock.isAcceptableNeighbour(p_222656_, p_222657_.relative($$8), $$14)) {
                        p_222656_.setBlock($$12, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace($$14), true), 2);
                    } else if ($$11 && p_222656_.isEmptyBlock($$13) && VineBlock.isAcceptableNeighbour(p_222656_, p_222657_.relative($$9), $$14)) {
                        p_222656_.setBlock($$13, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace($$14), true), 2);
                    } else if ((double)p_222658_.nextFloat() < 0.05 && VineBlock.isAcceptableNeighbour(p_222656_, $$6.above(), Direction.UP)) {
                        p_222656_.setBlock($$6, (BlockState)this.defaultBlockState().setValue(UP, true), 2);
                    }
                }
            } else if (VineBlock.isAcceptableNeighbour(p_222656_, $$6, $$4)) {
                p_222656_.setBlock(p_222657_, (BlockState)p_222655_.setValue(VineBlock.getPropertyForFace($$4), true), 2);
            }
            return;
        }
        if ($$4 == Direction.UP && p_222657_.getY() < p_222656_.getMaxY()) {
            if (this.canSupportAtFace(p_222656_, p_222657_, $$4)) {
                p_222656_.setBlock(p_222657_, (BlockState)p_222655_.setValue(UP, true), 2);
                return;
            }
            if (p_222656_.isEmptyBlock($$5)) {
                if (!this.canSpread(p_222656_, p_222657_)) {
                    return;
                }
                BlockState $$15 = p_222655_;
                for (Direction $$16 : Direction.Plane.HORIZONTAL) {
                    if (!p_222658_.nextBoolean() && VineBlock.isAcceptableNeighbour(p_222656_, $$5.relative($$16), $$16)) continue;
                    $$15 = (BlockState)$$15.setValue(VineBlock.getPropertyForFace($$16), false);
                }
                if (this.hasHorizontalConnection($$15)) {
                    p_222656_.setBlock($$5, $$15, 2);
                }
                return;
            }
        }
        if (p_222657_.getY() > p_222656_.getMinY() && (($$18 = p_222656_.getBlockState($$17 = p_222657_.below())).isAir() || $$18.is(this)) && ($$19 = $$18.isAir() ? this.defaultBlockState() : $$18) != ($$20 = this.copyRandomFaces(p_222655_, $$19, p_222658_)) && this.hasHorizontalConnection($$20)) {
            p_222656_.setBlock($$17, $$20, 2);
        }
    }

    private BlockState copyRandomFaces(BlockState p_222651_, BlockState p_222652_, RandomSource p_222653_) {
        for (Direction $$3 : Direction.Plane.HORIZONTAL) {
            BooleanProperty $$4;
            if (!p_222653_.nextBoolean() || !p_222651_.getValue($$4 = VineBlock.getPropertyForFace($$3)).booleanValue()) continue;
            p_222652_ = (BlockState)p_222652_.setValue($$4, true);
        }
        return p_222652_;
    }

    private boolean hasHorizontalConnection(BlockState p_57912_) {
        return p_57912_.getValue(NORTH) != false || p_57912_.getValue(EAST) != false || p_57912_.getValue(SOUTH) != false || p_57912_.getValue(WEST) != false;
    }

    private boolean canSpread(BlockGetter p_57851_, BlockPos p_57852_) {
        int $$2 = 4;
        Iterable<BlockPos> $$3 = BlockPos.betweenClosed(p_57852_.getX() - 4, p_57852_.getY() - 1, p_57852_.getZ() - 4, p_57852_.getX() + 4, p_57852_.getY() + 1, p_57852_.getZ() + 4);
        int $$4 = 5;
        for (BlockPos $$5 : $$3) {
            if (!p_57851_.getBlockState($$5).is(this) || --$$4 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canBeReplaced(BlockState p_57858_, BlockPlaceContext p_57859_) {
        BlockState $$2 = p_57859_.getLevel().getBlockState(p_57859_.getClickedPos());
        if ($$2.is(this)) {
            return this.countFaces($$2) < PROPERTY_BY_DIRECTION.size();
        }
        return super.canBeReplaced(p_57858_, p_57859_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_57849_) {
        BlockState $$1 = p_57849_.getLevel().getBlockState(p_57849_.getClickedPos());
        boolean $$2 = $$1.is(this);
        BlockState $$3 = $$2 ? $$1 : this.defaultBlockState();
        for (Direction $$4 : p_57849_.getNearestLookingDirections()) {
            boolean $$6;
            if ($$4 == Direction.DOWN) continue;
            BooleanProperty $$5 = VineBlock.getPropertyForFace($$4);
            boolean bl = $$6 = $$2 && $$1.getValue($$5) != false;
            if ($$6 || !this.canSupportAtFace(p_57849_.getLevel(), p_57849_.getClickedPos(), $$4)) continue;
            return (BlockState)$$3.setValue($$5, true);
        }
        return $$2 ? $$3 : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57882_) {
        p_57882_.add(UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected BlockState rotate(BlockState p_57868_, Rotation p_57869_) {
        switch (p_57869_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.setValue(NORTH, p_57868_.getValue(SOUTH))).setValue(EAST, p_57868_.getValue(WEST))).setValue(SOUTH, p_57868_.getValue(NORTH))).setValue(WEST, p_57868_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.setValue(NORTH, p_57868_.getValue(EAST))).setValue(EAST, p_57868_.getValue(SOUTH))).setValue(SOUTH, p_57868_.getValue(WEST))).setValue(WEST, p_57868_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_57868_.setValue(NORTH, p_57868_.getValue(WEST))).setValue(EAST, p_57868_.getValue(NORTH))).setValue(SOUTH, p_57868_.getValue(EAST))).setValue(WEST, p_57868_.getValue(SOUTH));
            }
        }
        return p_57868_;
    }

    @Override
    protected BlockState mirror(BlockState p_57865_, Mirror p_57866_) {
        switch (p_57866_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_57865_.setValue(NORTH, p_57865_.getValue(SOUTH))).setValue(SOUTH, p_57865_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_57865_.setValue(EAST, p_57865_.getValue(WEST))).setValue(WEST, p_57865_.getValue(EAST));
            }
        }
        return super.mirror(p_57865_, p_57866_);
    }

    public static BooleanProperty getPropertyForFace(Direction p_57884_) {
        return PROPERTY_BY_DIRECTION.get(p_57884_);
    }
}

