/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class VaultBlock
extends BaseEntityBlock {
    public static final MapCodec<VaultBlock> CODEC = VaultBlock.simpleCodec(VaultBlock::new);
    public static final Property<VaultState> STATE = BlockStateProperties.VAULT_STATE;
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OMINOUS = BlockStateProperties.OMINOUS;

    public MapCodec<VaultBlock> codec() {
        return CODEC;
    }

    public VaultBlock(BlockBehaviour.Properties p_324605_) {
        super(p_324605_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(STATE, VaultState.INACTIVE)).setValue(OMINOUS, false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InteractionResult useItemOn(ItemStack p_324161_, BlockState p_323816_, Level p_324403_, BlockPos p_324623_, Player p_324219_, InteractionHand p_324416_, BlockHitResult p_324261_) {
        if (p_324161_.isEmpty() || p_323816_.getValue(STATE) != VaultState.ACTIVE) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (p_324403_ instanceof ServerLevel) {
            void $$9;
            ServerLevel $$7 = (ServerLevel)p_324403_;
            BlockEntity blockEntity = $$7.getBlockEntity(p_324623_);
            if (!(blockEntity instanceof VaultBlockEntity)) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            VaultBlockEntity $$8 = (VaultBlockEntity)blockEntity;
            VaultBlockEntity.Server.tryInsertKey($$7, p_324623_, p_323816_, $$9.getConfig(), $$9.getServerData(), $$9.getSharedData(), p_324219_, p_324161_);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_324543_, BlockState p_323652_) {
        return new VaultBlockEntity(p_324543_, p_323652_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_323673_) {
        p_323673_.add(FACING, STATE, OMINOUS);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_323525_, BlockState p_324070_, BlockEntityType<T> p_323541_) {
        BlockEntityTicker<T> blockEntityTicker;
        if (p_323525_ instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)p_323525_;
            blockEntityTicker = VaultBlock.createTickerHelper(p_323541_, BlockEntityType.VAULT, (p_323957_, p_324322_, p_323828_, p_323769_) -> VaultBlockEntity.Server.tick($$3, p_324322_, p_323828_, p_323769_.getConfig(), p_323769_.getServerData(), p_323769_.getSharedData()));
        } else {
            blockEntityTicker = VaultBlock.createTickerHelper(p_323541_, BlockEntityType.VAULT, (p_324290_, p_323926_, p_323941_, p_323489_) -> VaultBlockEntity.Client.tick(p_324290_, p_323926_, p_323941_, p_323489_.getClientData(), p_323489_.getSharedData()));
        }
        return blockEntityTicker;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_324576_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, p_324576_.getHorizontalDirection().getOpposite());
    }

    @Override
    public BlockState rotate(BlockState p_324232_, Rotation p_324443_) {
        return (BlockState)p_324232_.setValue(FACING, p_324443_.rotate(p_324232_.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState p_323894_, Mirror p_324242_) {
        return p_323894_.rotate(p_324242_.getRotation(p_323894_.getValue(FACING)));
    }
}

