/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;

public class TestBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<TestBlock> CODEC = TestBlock.simpleCodec(TestBlock::new);
    public static final EnumProperty<TestBlockMode> MODE = BlockStateProperties.TEST_BLOCK_MODE;

    public TestBlock(BlockBehaviour.Properties p_397223_) {
        super(p_397223_);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_397356_, BlockState p_397468_) {
        return new TestBlockEntity(p_397356_, p_397468_);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_397700_) {
        TestBlockMode $$3;
        BlockItemStateProperties $$1 = p_397700_.getItemInHand().get(DataComponents.BLOCK_STATE);
        BlockState $$2 = this.defaultBlockState();
        if ($$1 != null && ($$3 = $$1.get(MODE)) != null) {
            $$2 = (BlockState)$$2.setValue(MODE, $$3);
        }
        return $$2;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_397099_) {
        p_397099_.add(MODE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected InteractionResult useWithoutItem(BlockState p_397020_, Level p_397230_, BlockPos p_397100_, Player p_397362_, BlockHitResult p_397202_) {
        BlockEntity $$5 = p_397230_.getBlockEntity(p_397100_);
        if (!($$5 instanceof TestBlockEntity)) {
            return InteractionResult.PASS;
        }
        TestBlockEntity $$6 = (TestBlockEntity)$$5;
        if (!p_397362_.canUseGameMasterBlocks()) {
            return InteractionResult.PASS;
        }
        if (p_397230_.isClientSide) {
            void $$7;
            p_397362_.openTestBlock((TestBlockEntity)$$7);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void tick(BlockState p_397712_, ServerLevel p_397112_, BlockPos p_397466_, RandomSource p_397531_) {
        TestBlockEntity $$4 = TestBlock.getServerTestBlockEntity(p_397112_, p_397466_);
        if ($$4 == null) {
            return;
        }
        $$4.reset();
    }

    @Override
    protected void neighborChanged(BlockState p_397457_, Level p_397572_, BlockPos p_397104_, Block p_397813_, @Nullable Orientation p_397759_, boolean p_397459_) {
        TestBlockEntity $$6 = TestBlock.getServerTestBlockEntity(p_397572_, p_397104_);
        if ($$6 == null) {
            return;
        }
        if ($$6.getMode() == TestBlockMode.START) {
            return;
        }
        boolean $$7 = p_397572_.hasNeighborSignal(p_397104_);
        boolean $$8 = $$6.isPowered();
        if ($$7 && !$$8) {
            $$6.setPowered(true);
            $$6.trigger();
        } else if (!$$7 && $$8) {
            $$6.setPowered(false);
        }
    }

    @Nullable
    private static TestBlockEntity getServerTestBlockEntity(Level p_397380_, BlockPos p_397998_) {
        ServerLevel $$2;
        BlockEntity blockEntity;
        if (p_397380_ instanceof ServerLevel && (blockEntity = ($$2 = (ServerLevel)p_397380_).getBlockEntity(p_397998_)) instanceof TestBlockEntity) {
            TestBlockEntity $$3 = (TestBlockEntity)blockEntity;
            return $$3;
        }
        return null;
    }

    @Override
    public int getSignal(BlockState p_397637_, BlockGetter p_397297_, BlockPos p_397948_, Direction p_397493_) {
        if (p_397637_.getValue(MODE) != TestBlockMode.START) {
            return 0;
        }
        BlockEntity $$4 = p_397297_.getBlockEntity(p_397948_);
        if ($$4 instanceof TestBlockEntity) {
            TestBlockEntity $$5 = (TestBlockEntity)$$4;
            return $$5.isPowered() ? 15 : 0;
        }
        return 0;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader p_397697_, BlockPos p_397696_, BlockState p_397513_, boolean p_398035_) {
        ItemStack $$4 = super.getCloneItemStack(p_397697_, p_397696_, p_397513_, p_398035_);
        return TestBlock.setModeOnStack($$4, p_397513_.getValue(MODE));
    }

    public static ItemStack setModeOnStack(ItemStack p_396991_, TestBlockMode p_397281_) {
        p_396991_.set(DataComponents.BLOCK_STATE, p_396991_.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY).with(MODE, p_397281_));
        return p_396991_;
    }

    protected MapCodec<TestBlock> codec() {
        return CODEC;
    }
}

