/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;

public abstract class SpreadingSnowyDirtBlock
extends SnowyDirtBlock {
    protected SpreadingSnowyDirtBlock(BlockBehaviour.Properties p_56817_) {
        super(p_56817_);
    }

    private static boolean canBeGrass(BlockState p_56824_, LevelReader p_56825_, BlockPos p_56826_) {
        BlockPos $$3 = p_56826_.above();
        BlockState $$4 = p_56825_.getBlockState($$3);
        if ($$4.is(Blocks.SNOW) && $$4.getValue(SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if ($$4.getFluidState().getAmount() == 8) {
            return false;
        }
        int $$5 = LightEngine.getLightBlockInto(p_56824_, $$4, Direction.UP, $$4.getLightBlock());
        return $$5 < 15;
    }

    protected abstract MapCodec<? extends SpreadingSnowyDirtBlock> codec();

    private static boolean canPropagate(BlockState p_56828_, LevelReader p_56829_, BlockPos p_56830_) {
        BlockPos $$3 = p_56830_.above();
        return SpreadingSnowyDirtBlock.canBeGrass(p_56828_, p_56829_, p_56830_) && !p_56829_.getFluidState($$3).is(FluidTags.WATER);
    }

    @Override
    protected void randomTick(BlockState p_222508_, ServerLevel p_222509_, BlockPos p_222510_, RandomSource p_222511_) {
        if (!SpreadingSnowyDirtBlock.canBeGrass(p_222508_, p_222509_, p_222510_)) {
            p_222509_.setBlockAndUpdate(p_222510_, Blocks.DIRT.defaultBlockState());
            return;
        }
        if (p_222509_.getMaxLocalRawBrightness(p_222510_.above()) >= 9) {
            BlockState $$4 = this.defaultBlockState();
            for (int $$5 = 0; $$5 < 4; ++$$5) {
                BlockPos $$6 = p_222510_.offset(p_222511_.nextInt(3) - 1, p_222511_.nextInt(5) - 3, p_222511_.nextInt(3) - 1);
                if (!p_222509_.getBlockState($$6).is(Blocks.DIRT) || !SpreadingSnowyDirtBlock.canPropagate($$4, p_222509_, $$6)) continue;
                p_222509_.setBlockAndUpdate($$6, (BlockState)$$4.setValue(SNOWY, SpreadingSnowyDirtBlock.isSnowySetting(p_222509_.getBlockState($$6.above()))));
            }
        }
    }
}

