/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;

public class NoteBlock
extends Block {
    public static final MapCodec<NoteBlock> CODEC = NoteBlock.simpleCodec(NoteBlock::new);
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.NOTEBLOCK_INSTRUMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty NOTE = BlockStateProperties.NOTE;
    public static final int NOTE_VOLUME = 3;

    public MapCodec<NoteBlock> codec() {
        return CODEC;
    }

    public NoteBlock(BlockBehaviour.Properties p_55016_) {
        super(p_55016_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(INSTRUMENT, NoteBlockInstrument.HARP)).setValue(NOTE, 0)).setValue(POWERED, false));
    }

    private BlockState setInstrument(LevelReader p_374305_, BlockPos p_261908_, BlockState p_262130_) {
        NoteBlockInstrument $$3 = p_374305_.getBlockState(p_261908_.above()).instrument();
        if ($$3.worksAboveNoteBlock()) {
            return (BlockState)p_262130_.setValue(INSTRUMENT, $$3);
        }
        NoteBlockInstrument $$4 = p_374305_.getBlockState(p_261908_.below()).instrument();
        NoteBlockInstrument $$5 = $$4.worksAboveNoteBlock() ? NoteBlockInstrument.HARP : $$4;
        return (BlockState)p_262130_.setValue(INSTRUMENT, $$5);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_55018_) {
        return this.setInstrument(p_55018_.getLevel(), p_55018_.getClickedPos(), this.defaultBlockState());
    }

    @Override
    protected BlockState updateShape(BlockState p_55048_, LevelReader p_374298_, ScheduledTickAccess p_374153_, BlockPos p_55052_, Direction p_55049_, BlockPos p_55053_, BlockState p_55050_, RandomSource p_374540_) {
        boolean $$8;
        boolean bl = $$8 = p_55049_.getAxis() == Direction.Axis.Y;
        if ($$8) {
            return this.setInstrument(p_374298_, p_55052_, p_55048_);
        }
        return super.updateShape(p_55048_, p_374298_, p_374153_, p_55052_, p_55049_, p_55053_, p_55050_, p_374540_);
    }

    @Override
    protected void neighborChanged(BlockState p_55041_, Level p_55042_, BlockPos p_55043_, Block p_55044_, @Nullable Orientation p_361888_, boolean p_55046_) {
        boolean $$6 = p_55042_.hasNeighborSignal(p_55043_);
        if ($$6 != p_55041_.getValue(POWERED)) {
            if ($$6) {
                this.playNote(null, p_55041_, p_55042_, p_55043_);
            }
            p_55042_.setBlock(p_55043_, (BlockState)p_55041_.setValue(POWERED, $$6), 3);
        }
    }

    private void playNote(@Nullable Entity p_261664_, BlockState p_261606_, Level p_261819_, BlockPos p_262042_) {
        if (p_261606_.getValue(INSTRUMENT).worksAboveNoteBlock() || p_261819_.getBlockState(p_262042_.above()).isAir()) {
            p_261819_.blockEvent(p_262042_, this, 0, 0);
            p_261819_.gameEvent(p_261664_, GameEvent.NOTE_BLOCK_PLAY, p_262042_);
        }
    }

    @Override
    protected InteractionResult useItemOn(ItemStack p_316716_, BlockState p_316688_, Level p_316672_, BlockPos p_316355_, Player p_316822_, InteractionHand p_316505_, BlockHitResult p_316667_) {
        if (p_316716_.is(ItemTags.NOTE_BLOCK_TOP_INSTRUMENTS) && p_316667_.getDirection() == Direction.UP) {
            return InteractionResult.PASS;
        }
        return super.useItemOn(p_316716_, p_316688_, p_316672_, p_316355_, p_316822_, p_316505_, p_316667_);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_316441_, Level p_316774_, BlockPos p_316344_, Player p_316884_, BlockHitResult p_316631_) {
        if (!p_316774_.isClientSide) {
            p_316441_ = (BlockState)p_316441_.cycle(NOTE);
            p_316774_.setBlock(p_316344_, p_316441_, 3);
            this.playNote(p_316884_, p_316441_, p_316774_, p_316344_);
            p_316884_.awardStat(Stats.TUNE_NOTEBLOCK);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState p_55029_, Level p_55030_, BlockPos p_55031_, Player p_55032_) {
        if (p_55030_.isClientSide) {
            return;
        }
        this.playNote(p_55032_, p_55029_, p_55030_, p_55031_);
        p_55032_.awardStat(Stats.PLAY_NOTEBLOCK);
    }

    public static float getPitchFromNote(int p_277409_) {
        return (float)Math.pow(2.0, (double)(p_277409_ - 12) / 12.0);
    }

    @Override
    protected boolean triggerEvent(BlockState p_55023_, Level p_55024_, BlockPos p_55025_, int p_55026_, int p_55027_) {
        Holder<SoundEvent> $$11;
        float $$8;
        NoteBlockInstrument $$5 = p_55023_.getValue(INSTRUMENT);
        if ($$5.isTunable()) {
            int $$6 = p_55023_.getValue(NOTE);
            float $$7 = NoteBlock.getPitchFromNote($$6);
            p_55024_.addParticle(ParticleTypes.NOTE, (double)p_55025_.getX() + 0.5, (double)p_55025_.getY() + 1.2, (double)p_55025_.getZ() + 0.5, (double)$$6 / 24.0, 0.0, 0.0);
        } else {
            $$8 = 1.0f;
        }
        if ($$5.hasCustomSound()) {
            ResourceLocation $$9 = this.getCustomSoundId(p_55024_, p_55025_);
            if ($$9 == null) {
                return false;
            }
            Holder<SoundEvent> $$10 = Holder.direct(SoundEvent.createVariableRangeEvent($$9));
        } else {
            $$11 = $$5.getSoundEvent();
        }
        p_55024_.playSeededSound(null, (double)p_55025_.getX() + 0.5, (double)p_55025_.getY() + 0.5, (double)p_55025_.getZ() + 0.5, $$11, SoundSource.RECORDS, 3.0f, $$8, p_55024_.random.nextLong());
        return true;
    }

    @Nullable
    private ResourceLocation getCustomSoundId(Level p_263070_, BlockPos p_262999_) {
        BlockEntity blockEntity = p_263070_.getBlockEntity(p_262999_.above());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity $$2 = (SkullBlockEntity)blockEntity;
            return $$2.getNoteBlockSound();
        }
        return null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55055_) {
        p_55055_.add(INSTRUMENT, POWERED, NOTE);
    }
}

