/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class NetherPortalBlock
extends Block
implements Portal {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<NetherPortalBlock> CODEC = NetherPortalBlock.simpleCodec(NetherPortalBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private static final Map<Direction.Axis, VoxelShape> SHAPES = Shapes.rotateHorizontalAxis(Block.column(4.0, 16.0, 0.0, 16.0));

    public MapCodec<NetherPortalBlock> codec() {
        return CODEC;
    }

    public NetherPortalBlock(BlockBehaviour.Properties p_54909_) {
        super(p_54909_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, Direction.Axis.X));
    }

    @Override
    protected VoxelShape getShape(BlockState p_54942_, BlockGetter p_54943_, BlockPos p_54944_, CollisionContext p_54945_) {
        return SHAPES.get(p_54942_.getValue(AXIS));
    }

    @Override
    protected void randomTick(BlockState p_221799_, ServerLevel p_221800_, BlockPos p_221801_, RandomSource p_221802_) {
        if (p_221800_.dimensionType().natural() && p_221800_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && p_221802_.nextInt(2000) < p_221800_.getDifficulty().getId() && p_221800_.anyPlayerCloseEnoughForSpawning(p_221801_)) {
            ZombifiedPiglin $$4;
            while (p_221800_.getBlockState(p_221801_).is(this)) {
                p_221801_ = p_221801_.below();
            }
            if (p_221800_.getBlockState(p_221801_).isValidSpawn(p_221800_, p_221801_, EntityType.ZOMBIFIED_PIGLIN) && ($$4 = EntityType.ZOMBIFIED_PIGLIN.spawn(p_221800_, p_221801_.above(), EntitySpawnReason.STRUCTURE)) != null) {
                $$4.setPortalCooldown();
                Entity $$5 = $$4.getVehicle();
                if ($$5 != null) {
                    $$5.setPortalCooldown();
                }
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState p_54928_, LevelReader p_374413_, ScheduledTickAccess p_374339_, BlockPos p_54932_, Direction p_54929_, BlockPos p_54933_, BlockState p_54930_, RandomSource p_374242_) {
        boolean $$10;
        Direction.Axis $$8 = p_54929_.getAxis();
        Direction.Axis $$9 = p_54928_.getValue(AXIS);
        boolean bl = $$10 = $$9 != $$8 && $$8.isHorizontal();
        if ($$10 || p_54930_.is(this) || PortalShape.findAnyShape(p_374413_, p_54932_, $$9).isComplete()) {
            return super.updateShape(p_54928_, p_374413_, p_374339_, p_54932_, p_54929_, p_54933_, p_54930_, p_374242_);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected void entityInside(BlockState p_54915_, Level p_54916_, BlockPos p_54917_, Entity p_54918_, InsideBlockEffectApplier p_405383_) {
        if (p_54918_.canUsePortal(false)) {
            p_54918_.setAsInsidePortal(this, p_54917_);
        }
    }

    @Override
    public int getPortalTransitionTime(ServerLevel p_350689_, Entity p_350280_) {
        if (p_350280_ instanceof Player) {
            Player $$2 = (Player)p_350280_;
            return Math.max(0, p_350689_.getGameRules().getInt($$2.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel p_350444_, Entity p_350334_, BlockPos p_350764_) {
        ResourceKey<Level> $$3 = p_350444_.dimension() == Level.NETHER ? Level.OVERWORLD : Level.NETHER;
        ServerLevel $$4 = p_350444_.getServer().getLevel($$3);
        if ($$4 == null) {
            return null;
        }
        boolean $$5 = $$4.dimension() == Level.NETHER;
        WorldBorder $$6 = $$4.getWorldBorder();
        double $$7 = DimensionType.getTeleportationScale(p_350444_.dimensionType(), $$4.dimensionType());
        BlockPos $$8 = $$6.clampToBounds(p_350334_.getX() * $$7, p_350334_.getY(), p_350334_.getZ() * $$7);
        return this.getExitPortal($$4, p_350334_, p_350764_, $$8, $$5, $$6);
    }

    @Nullable
    private TeleportTransition getExitPortal(ServerLevel p_350564_, Entity p_350493_, BlockPos p_350379_, BlockPos p_350747_, boolean p_350326_, WorldBorder p_350718_) {
        TeleportTransition.PostTeleportTransition $$14;
        BlockUtil.FoundRectangle $$13;
        Optional<BlockPos> $$6 = p_350564_.getPortalForcer().findClosestPortalPosition(p_350747_, p_350326_, p_350718_);
        if ($$6.isPresent()) {
            BlockPos $$7 = $$6.get();
            BlockState $$8 = p_350564_.getBlockState($$7);
            BlockUtil.FoundRectangle $$9 = BlockUtil.getLargestRectangleAround($$7, $$8.getValue(BlockStateProperties.HORIZONTAL_AXIS), 21, Direction.Axis.Y, 21, p_351970_ -> p_350564_.getBlockState((BlockPos)p_351970_) == $$8);
            TeleportTransition.PostTeleportTransition $$10 = TeleportTransition.PLAY_PORTAL_SOUND.then(p_351967_ -> p_351967_.placePortalTicket($$7));
        } else {
            Direction.Axis $$11 = p_350493_.level().getBlockState(p_350379_).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> $$12 = p_350564_.getPortalForcer().createPortal(p_350747_, $$11);
            if ($$12.isEmpty()) {
                LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            $$13 = $$12.get();
            $$14 = TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET);
        }
        return NetherPortalBlock.getDimensionTransitionFromExit(p_350493_, p_350379_, $$13, p_350564_, $$14);
    }

    private static TeleportTransition getDimensionTransitionFromExit(Entity p_350906_, BlockPos p_350376_, BlockUtil.FoundRectangle p_350428_, ServerLevel p_350928_, TeleportTransition.PostTeleportTransition p_379530_) {
        Vec3 $$10;
        Direction.Axis $$9;
        BlockState $$5 = p_350906_.level().getBlockState(p_350376_);
        if ($$5.hasProperty(BlockStateProperties.HORIZONTAL_AXIS)) {
            Direction.Axis $$6 = $$5.getValue(BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle $$7 = BlockUtil.getLargestRectangleAround(p_350376_, $$6, 21, Direction.Axis.Y, 21, p_351016_ -> p_350906_.level().getBlockState((BlockPos)p_351016_) == $$5);
            Vec3 $$8 = p_350906_.getRelativePortalPosition($$6, $$7);
        } else {
            $$9 = Direction.Axis.X;
            $$10 = new Vec3(0.5, 0.0, 0.0);
        }
        return NetherPortalBlock.createDimensionTransition(p_350928_, p_350428_, $$9, $$10, p_350906_, p_379530_);
    }

    private static TeleportTransition createDimensionTransition(ServerLevel p_350955_, BlockUtil.FoundRectangle p_350865_, Direction.Axis p_351013_, Vec3 p_351020_, Entity p_350578_, TeleportTransition.PostTeleportTransition p_379531_) {
        BlockPos $$6 = p_350865_.minCorner;
        BlockState $$7 = p_350955_.getBlockState($$6);
        Direction.Axis $$8 = $$7.getOptionalValue(BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double $$9 = p_350865_.axis1Size;
        double $$10 = p_350865_.axis2Size;
        EntityDimensions $$11 = p_350578_.getDimensions(p_350578_.getPose());
        int $$12 = p_351013_ == $$8 ? 0 : 90;
        double $$13 = (double)$$11.width() / 2.0 + ($$9 - (double)$$11.width()) * p_351020_.x();
        double $$14 = ($$10 - (double)$$11.height()) * p_351020_.y();
        double $$15 = 0.5 + p_351020_.z();
        boolean $$16 = $$8 == Direction.Axis.X;
        Vec3 $$17 = new Vec3((double)$$6.getX() + ($$16 ? $$13 : $$15), (double)$$6.getY() + $$14, (double)$$6.getZ() + ($$16 ? $$15 : $$13));
        Vec3 $$18 = PortalShape.findCollisionFreePosition($$17, p_350955_, p_350578_, $$11);
        return new TeleportTransition(p_350955_, $$18, Vec3.ZERO, $$12, 0.0f, Relative.union(Relative.DELTA, Relative.ROTATION), p_379531_);
    }

    @Override
    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    @Override
    public void animateTick(BlockState p_221794_, Level p_221795_, BlockPos p_221796_, RandomSource p_221797_) {
        if (p_221797_.nextInt(100) == 0) {
            p_221795_.playLocalSound((double)p_221796_.getX() + 0.5, (double)p_221796_.getY() + 0.5, (double)p_221796_.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, p_221797_.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int $$4 = 0; $$4 < 4; ++$$4) {
            double $$5 = (double)p_221796_.getX() + p_221797_.nextDouble();
            double $$6 = (double)p_221796_.getY() + p_221797_.nextDouble();
            double $$7 = (double)p_221796_.getZ() + p_221797_.nextDouble();
            double $$8 = ((double)p_221797_.nextFloat() - 0.5) * 0.5;
            double $$9 = ((double)p_221797_.nextFloat() - 0.5) * 0.5;
            double $$10 = ((double)p_221797_.nextFloat() - 0.5) * 0.5;
            int $$11 = p_221797_.nextInt(2) * 2 - 1;
            if (p_221795_.getBlockState(p_221796_.west()).is(this) || p_221795_.getBlockState(p_221796_.east()).is(this)) {
                $$7 = (double)p_221796_.getZ() + 0.5 + 0.25 * (double)$$11;
                $$10 = p_221797_.nextFloat() * 2.0f * (float)$$11;
            } else {
                $$5 = (double)p_221796_.getX() + 0.5 + 0.25 * (double)$$11;
                $$8 = p_221797_.nextFloat() * 2.0f * (float)$$11;
            }
            p_221795_.addParticle(ParticleTypes.PORTAL, $$5, $$6, $$7, $$8, $$9, $$10);
        }
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader p_304402_, BlockPos p_54912_, BlockState p_54913_, boolean p_386478_) {
        return ItemStack.EMPTY;
    }

    @Override
    protected BlockState rotate(BlockState p_54925_, Rotation p_54926_) {
        switch (p_54926_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (p_54925_.getValue(AXIS)) {
                    case X: {
                        return (BlockState)p_54925_.setValue(AXIS, Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)p_54925_.setValue(AXIS, Direction.Axis.X);
                    }
                }
                return p_54925_;
            }
        }
        return p_54925_;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54935_) {
        p_54935_.add(AXIS);
    }
}

