/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MossyCarpetBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<MossyCarpetBlock> CODEC = MossyCarpetBlock.simpleCodec(MossyCarpetBlock::new);
    public static final BooleanProperty BASE = BlockStateProperties.BOTTOM;
    public static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<MossyCarpetBlock> codec() {
        return CODEC;
    }

    public MossyCarpetBlock(BlockBehaviour.Properties p_380381_) {
        super(p_380381_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(BASE, true)).setValue(NORTH, WallSide.NONE)).setValue(EAST, WallSide.NONE)).setValue(SOUTH, WallSide.NONE)).setValue(WEST, WallSide.NONE));
        this.shapes = this.makeShapes();
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState p_380234_) {
        return Shapes.empty();
    }

    public Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> $$0 = Shapes.rotateHorizontal(Block.boxZ(16.0, 0.0, 10.0, 0.0, 1.0));
        Map<Direction, VoxelShape> $$1 = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(p_393367_ -> {
            VoxelShape $$3 = p_393367_.getValue(BASE) != false ? (VoxelShape)$$1.get(Direction.DOWN) : Shapes.empty();
            for (Map.Entry<Direction, EnumProperty<WallSide>> $$4 : PROPERTY_BY_DIRECTION.entrySet()) {
                switch ((WallSide)p_393367_.getValue($$4.getValue())) {
                    case NONE: {
                        break;
                    }
                    case LOW: {
                        $$3 = Shapes.or($$3, (VoxelShape)$$0.get($$4.getKey()));
                        break;
                    }
                    case TALL: {
                        $$3 = Shapes.or($$3, (VoxelShape)$$1.get($$4.getKey()));
                    }
                }
            }
            return $$3.isEmpty() ? Shapes.block() : $$3;
        });
    }

    @Override
    protected VoxelShape getShape(BlockState p_380262_, BlockGetter p_379532_, BlockPos p_379586_, CollisionContext p_380281_) {
        return this.shapes.apply(p_380262_);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState p_380336_, BlockGetter p_380068_, BlockPos p_379717_, CollisionContext p_379651_) {
        return p_380336_.getValue(BASE) != false ? this.shapes.apply(this.defaultBlockState()) : Shapes.empty();
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_379750_) {
        return true;
    }

    @Override
    protected boolean canSurvive(BlockState p_379574_, LevelReader p_379768_, BlockPos p_380354_) {
        BlockState $$3 = p_379768_.getBlockState(p_380354_.below());
        if (p_379574_.getValue(BASE).booleanValue()) {
            return !$$3.isAir();
        }
        return $$3.is(this) && $$3.getValue(BASE) != false;
    }

    private static boolean hasFaces(BlockState p_379942_) {
        if (p_379942_.getValue(BASE).booleanValue()) {
            return true;
        }
        for (EnumProperty<WallSide> $$1 : PROPERTY_BY_DIRECTION.values()) {
            if (p_379942_.getValue($$1) == WallSide.NONE) continue;
            return true;
        }
        return false;
    }

    private static boolean canSupportAtFace(BlockGetter p_380047_, BlockPos p_379895_, Direction p_380188_) {
        if (p_380188_ == Direction.UP) {
            return false;
        }
        return MultifaceBlock.canAttachTo(p_380047_, p_379895_, p_380188_);
    }

    private static BlockState getUpdatedState(BlockState p_379720_, BlockGetter p_379555_, BlockPos p_379912_, boolean p_379623_) {
        BlockBehaviour.BlockStateBase $$4 = null;
        BlockBehaviour.BlockStateBase $$5 = null;
        p_379623_ |= p_379720_.getValue(BASE).booleanValue();
        for (Direction $$6 : Direction.Plane.HORIZONTAL) {
            WallSide $$8;
            EnumProperty<WallSide> $$7 = MossyCarpetBlock.getPropertyForFace($$6);
            WallSide wallSide = MossyCarpetBlock.canSupportAtFace(p_379555_, p_379912_, $$6) ? (p_379623_ ? WallSide.LOW : p_379720_.getValue($$7)) : ($$8 = WallSide.NONE);
            if ($$8 == WallSide.LOW) {
                if ($$4 == null) {
                    $$4 = p_379555_.getBlockState(p_379912_.above());
                }
                if ($$4.is(Blocks.PALE_MOSS_CARPET) && $$4.getValue($$7) != WallSide.NONE && !$$4.getValue(BASE).booleanValue()) {
                    $$8 = WallSide.TALL;
                }
                if (!p_379720_.getValue(BASE).booleanValue()) {
                    if ($$5 == null) {
                        $$5 = p_379555_.getBlockState(p_379912_.below());
                    }
                    if ($$5.is(Blocks.PALE_MOSS_CARPET) && $$5.getValue($$7) == WallSide.NONE) {
                        $$8 = WallSide.NONE;
                    }
                }
            }
            p_379720_ = (BlockState)p_379720_.setValue($$7, $$8);
        }
        return p_379720_;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_380111_) {
        return MossyCarpetBlock.getUpdatedState(this.defaultBlockState(), p_380111_.getLevel(), p_380111_.getClickedPos(), true);
    }

    public static void placeAt(LevelAccessor p_379453_, BlockPos p_380271_, RandomSource p_379424_, int p_380167_) {
        BlockState $$4 = Blocks.PALE_MOSS_CARPET.defaultBlockState();
        BlockState $$5 = MossyCarpetBlock.getUpdatedState($$4, p_379453_, p_380271_, true);
        p_379453_.setBlock(p_380271_, $$5, p_380167_);
        BlockState $$6 = MossyCarpetBlock.createTopperWithSideChance(p_379453_, p_380271_, p_379424_::nextBoolean);
        if (!$$6.isAir()) {
            p_379453_.setBlock(p_380271_.above(), $$6, p_380167_);
            BlockState $$7 = MossyCarpetBlock.getUpdatedState($$5, p_379453_, p_380271_, true);
            p_379453_.setBlock(p_380271_, $$7, p_380167_);
        }
    }

    @Override
    public void setPlacedBy(Level p_380310_, BlockPos p_380202_, BlockState p_379659_, @Nullable LivingEntity p_379877_, ItemStack p_380344_) {
        if (p_380310_.isClientSide) {
            return;
        }
        RandomSource $$5 = p_380310_.getRandom();
        BlockState $$6 = MossyCarpetBlock.createTopperWithSideChance(p_380310_, p_380202_, $$5::nextBoolean);
        if (!$$6.isAir()) {
            p_380310_.setBlock(p_380202_.above(), $$6, 3);
        }
    }

    private static BlockState createTopperWithSideChance(BlockGetter p_380187_, BlockPos p_380387_, BooleanSupplier p_380154_) {
        BlockPos $$3 = p_380387_.above();
        BlockState $$4 = p_380187_.getBlockState($$3);
        boolean $$5 = $$4.is(Blocks.PALE_MOSS_CARPET);
        if ($$5 && $$4.getValue(BASE).booleanValue() || !$$5 && !$$4.canBeReplaced()) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState $$6 = (BlockState)Blocks.PALE_MOSS_CARPET.defaultBlockState().setValue(BASE, false);
        BlockState $$7 = MossyCarpetBlock.getUpdatedState($$6, p_380187_, p_380387_.above(), true);
        for (Direction $$8 : Direction.Plane.HORIZONTAL) {
            EnumProperty<WallSide> $$9 = MossyCarpetBlock.getPropertyForFace($$8);
            if ($$7.getValue($$9) == WallSide.NONE || p_380154_.getAsBoolean()) continue;
            $$7 = (BlockState)$$7.setValue($$9, WallSide.NONE);
        }
        if (MossyCarpetBlock.hasFaces($$7) && $$7 != $$4) {
            return $$7;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected BlockState updateShape(BlockState p_379698_, LevelReader p_379600_, ScheduledTickAccess p_380394_, BlockPos p_380051_, Direction p_380408_, BlockPos p_380380_, BlockState p_379613_, RandomSource p_379309_) {
        if (!p_379698_.canSurvive(p_379600_, p_380051_)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState $$8 = MossyCarpetBlock.getUpdatedState(p_379698_, p_379600_, p_380051_, false);
        if (!MossyCarpetBlock.hasFaces($$8)) {
            return Blocks.AIR.defaultBlockState();
        }
        return $$8;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_379510_) {
        p_379510_.add(BASE, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected BlockState rotate(BlockState p_379325_, Rotation p_380164_) {
        return switch (p_380164_) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)p_379325_.setValue(NORTH, p_379325_.getValue(SOUTH))).setValue(EAST, p_379325_.getValue(WEST))).setValue(SOUTH, p_379325_.getValue(NORTH))).setValue(WEST, p_379325_.getValue(EAST));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)p_379325_.setValue(NORTH, p_379325_.getValue(EAST))).setValue(EAST, p_379325_.getValue(SOUTH))).setValue(SOUTH, p_379325_.getValue(WEST))).setValue(WEST, p_379325_.getValue(NORTH));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)p_379325_.setValue(NORTH, p_379325_.getValue(WEST))).setValue(EAST, p_379325_.getValue(NORTH))).setValue(SOUTH, p_379325_.getValue(EAST))).setValue(WEST, p_379325_.getValue(SOUTH));
            default -> p_379325_;
        };
    }

    @Override
    protected BlockState mirror(BlockState p_379462_, Mirror p_380184_) {
        return switch (p_380184_) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)p_379462_.setValue(NORTH, p_379462_.getValue(SOUTH))).setValue(SOUTH, p_379462_.getValue(NORTH));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)p_379462_.setValue(EAST, p_379462_.getValue(WEST))).setValue(WEST, p_379462_.getValue(EAST));
            default -> super.mirror(p_379462_, p_380184_);
        };
    }

    @Nullable
    public static EnumProperty<WallSide> getPropertyForFace(Direction p_379421_) {
        return PROPERTY_BY_DIRECTION.get(p_379421_);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader p_379909_, BlockPos p_379807_, BlockState p_379358_) {
        return p_379358_.getValue(BASE) != false && !MossyCarpetBlock.createTopperWithSideChance(p_379909_, p_379807_, () -> true).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level p_380168_, RandomSource p_380045_, BlockPos p_380299_, BlockState p_379595_) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel p_379402_, RandomSource p_379670_, BlockPos p_379387_, BlockState p_379934_) {
        BlockState $$4 = MossyCarpetBlock.createTopperWithSideChance(p_379402_, p_379387_, () -> true);
        if (!$$4.isAir()) {
            p_379402_.setBlock(p_379387_.above(), $$4, 3);
        }
    }
}

