/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(p_368428_ -> p_368428_.group((App)Biome.Precipitation.CODEC.fieldOf("precipitation").forGetter(p_304371_ -> p_304371_.precipitationType), (App)CauldronInteraction.CODEC.fieldOf("interactions").forGetter(p_304369_ -> p_304369_.interactions), LayeredCauldronBlock.propertiesCodec()).apply((Applicative)p_368428_, LayeredCauldronBlock::new));
    public static final int MIN_FILL_LEVEL = 1;
    public static final int MAX_FILL_LEVEL = 3;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_CAULDRON;
    private static final int BASE_CONTENT_HEIGHT = 6;
    private static final double HEIGHT_PER_LEVEL = 3.0;
    private static final VoxelShape[] FILLED_SHAPES = Util.make(() -> Block.boxes(2, p_423403_ -> Shapes.or(AbstractCauldronBlock.SHAPE, Block.column(12.0, 4.0, LayeredCauldronBlock.getPixelContentHeight(p_423403_ + 1)))));
    private final Biome.Precipitation precipitationType;

    public MapCodec<LayeredCauldronBlock> codec() {
        return CODEC;
    }

    public LayeredCauldronBlock(Biome.Precipitation p_304591_, CauldronInteraction.InteractionMap p_304761_, BlockBehaviour.Properties p_153522_) {
        super(p_153522_, p_304761_);
        this.precipitationType = p_304591_;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LEVEL, 1));
    }

    @Override
    public boolean isFull(BlockState p_153555_) {
        return p_153555_.getValue(LEVEL) == 3;
    }

    @Override
    protected boolean canReceiveStalactiteDrip(Fluid p_153551_) {
        return p_153551_ == Fluids.WATER && this.precipitationType == Biome.Precipitation.RAIN;
    }

    @Override
    protected double getContentHeight(BlockState p_153528_) {
        return LayeredCauldronBlock.getPixelContentHeight(p_153528_.getValue(LEVEL)) / 16.0;
    }

    private static double getPixelContentHeight(int p_423661_) {
        return 6.0 + (double)p_423661_ * 3.0;
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState p_423555_, BlockGetter p_423560_, BlockPos p_423649_, Entity p_423623_) {
        return FILLED_SHAPES[p_423555_.getValue(LEVEL) - 1];
    }

    @Override
    protected void entityInside(BlockState p_153534_, Level p_153535_, BlockPos p_153536_, Entity p_153537_, InsideBlockEffectApplier p_405060_) {
        if (p_153535_ instanceof ServerLevel) {
            ServerLevel $$5 = (ServerLevel)p_153535_;
            BlockPos $$6 = p_153536_.immutable();
            p_405060_.runBefore(InsideBlockEffectType.EXTINGUISH, p_423402_ -> {
                if (p_423402_.isOnFire() && p_423402_.mayInteract($$5, $$6)) {
                    this.handleEntityOnFireInside(p_153534_, p_153535_, $$6);
                }
            });
        }
        p_405060_.apply(InsideBlockEffectType.EXTINGUISH);
    }

    private void handleEntityOnFireInside(BlockState p_153556_, Level p_153557_, BlockPos p_153558_) {
        if (this.precipitationType == Biome.Precipitation.SNOW) {
            LayeredCauldronBlock.lowerFillLevel((BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue(LEVEL, p_153556_.getValue(LEVEL)), p_153557_, p_153558_);
        } else {
            LayeredCauldronBlock.lowerFillLevel(p_153556_, p_153557_, p_153558_);
        }
    }

    public static void lowerFillLevel(BlockState p_153560_, Level p_153561_, BlockPos p_153562_) {
        int $$3 = p_153560_.getValue(LEVEL) - 1;
        BlockState $$4 = $$3 == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)p_153560_.setValue(LEVEL, $$3);
        p_153561_.setBlockAndUpdate(p_153562_, $$4);
        p_153561_.gameEvent(GameEvent.BLOCK_CHANGE, p_153562_, GameEvent.Context.of($$4));
    }

    @Override
    public void handlePrecipitation(BlockState p_153539_, Level p_153540_, BlockPos p_153541_, Biome.Precipitation p_153542_) {
        if (!CauldronBlock.shouldHandlePrecipitation(p_153540_, p_153542_) || p_153539_.getValue(LEVEL) == 3 || p_153542_ != this.precipitationType) {
            return;
        }
        BlockState $$4 = (BlockState)p_153539_.cycle(LEVEL);
        p_153540_.setBlockAndUpdate(p_153541_, $$4);
        p_153540_.gameEvent(GameEvent.BLOCK_CHANGE, p_153541_, GameEvent.Context.of($$4));
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_153530_, Level p_153531_, BlockPos p_153532_) {
        return p_153530_.getValue(LEVEL);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_153549_) {
        p_153549_.add(LEVEL);
    }

    @Override
    protected void receiveStalactiteDrip(BlockState p_153544_, Level p_153545_, BlockPos p_153546_, Fluid p_153547_) {
        if (this.isFull(p_153544_)) {
            return;
        }
        BlockState $$4 = (BlockState)p_153544_.setValue(LEVEL, p_153544_.getValue(LEVEL) + 1);
        p_153545_.setBlockAndUpdate(p_153546_, $$4);
        p_153545_.gameEvent(GameEvent.BLOCK_CHANGE, p_153546_, GameEvent.Context.of($$4));
        p_153545_.levelEvent(1047, p_153546_, 0);
    }
}

