/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LadderBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<LadderBlock> CODEC = LadderBlock.simpleCodec(LadderBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(16.0, 13.0, 16.0));

    public MapCodec<LadderBlock> codec() {
        return CODEC;
    }

    protected LadderBlock(BlockBehaviour.Properties p_54345_) {
        super(p_54345_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState p_54372_, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        return SHAPES.get(p_54372_.getValue(FACING));
    }

    private boolean canAttachTo(BlockGetter p_54349_, BlockPos p_54350_, Direction p_54351_) {
        BlockState $$3 = p_54349_.getBlockState(p_54350_);
        return $$3.isFaceSturdy(p_54349_, p_54350_, p_54351_);
    }

    @Override
    protected boolean canSurvive(BlockState p_54353_, LevelReader p_54354_, BlockPos p_54355_) {
        Direction $$3 = p_54353_.getValue(FACING);
        return this.canAttachTo(p_54354_, p_54355_.relative($$3.getOpposite()), $$3);
    }

    @Override
    protected BlockState updateShape(BlockState p_54363_, LevelReader p_374096_, ScheduledTickAccess p_374237_, BlockPos p_54367_, Direction p_54364_, BlockPos p_54368_, BlockState p_54365_, RandomSource p_374476_) {
        if (p_54364_.getOpposite() == p_54363_.getValue(FACING) && !p_54363_.canSurvive(p_374096_, p_54367_)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (p_54363_.getValue(WATERLOGGED).booleanValue()) {
            p_374237_.scheduleTick(p_54367_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374096_));
        }
        return super.updateShape(p_54363_, p_374096_, p_374237_, p_54367_, p_54364_, p_54368_, p_54365_, p_374476_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_54347_) {
        BlockState $$1;
        if (!p_54347_.replacingClickedOnBlock() && ($$1 = p_54347_.getLevel().getBlockState(p_54347_.getClickedPos().relative(p_54347_.getClickedFace().getOpposite()))).is(this) && $$1.getValue(FACING) == p_54347_.getClickedFace()) {
            return null;
        }
        BlockState $$2 = this.defaultBlockState();
        Level $$3 = p_54347_.getLevel();
        BlockPos $$4 = p_54347_.getClickedPos();
        FluidState $$5 = p_54347_.getLevel().getFluidState(p_54347_.getClickedPos());
        for (Direction $$6 : p_54347_.getNearestLookingDirections()) {
            if (!$$6.getAxis().isHorizontal() || !($$2 = (BlockState)$$2.setValue(FACING, $$6.getOpposite())).canSurvive($$3, $$4)) continue;
            return (BlockState)$$2.setValue(WATERLOGGED, $$5.getType() == Fluids.WATER);
        }
        return null;
    }

    @Override
    protected BlockState rotate(BlockState p_54360_, Rotation p_54361_) {
        return (BlockState)p_54360_.setValue(FACING, p_54361_.rotate(p_54360_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_54357_, Mirror p_54358_) {
        return p_54357_.rotate(p_54358_.getRotation(p_54357_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54370_) {
        p_54370_.add(FACING, WATERLOGGED);
    }

    @Override
    protected FluidState getFluidState(BlockState p_54377_) {
        if (p_54377_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_54377_);
    }
}

