/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface BonemealableBlock {
    public boolean isValidBonemealTarget(LevelReader var1, BlockPos var2, BlockState var3);

    public boolean isBonemealSuccess(Level var1, RandomSource var2, BlockPos var3, BlockState var4);

    public void performBonemeal(ServerLevel var1, RandomSource var2, BlockPos var3, BlockState var4);

    public static boolean hasSpreadableNeighbourPos(LevelReader p_401785_, BlockPos p_401901_, BlockState p_401773_) {
        return BonemealableBlock.getSpreadableNeighbourPos(Direction.Plane.HORIZONTAL.stream().toList(), p_401785_, p_401901_, p_401773_).isPresent();
    }

    public static Optional<BlockPos> findSpreadableNeighbourPos(Level p_401928_, BlockPos p_401865_, BlockState p_401938_) {
        return BonemealableBlock.getSpreadableNeighbourPos(Direction.Plane.HORIZONTAL.shuffledCopy(p_401928_.random), p_401928_, p_401865_, p_401938_);
    }

    private static Optional<BlockPos> getSpreadableNeighbourPos(List<Direction> p_401891_, LevelReader p_401878_, BlockPos p_401894_, BlockState p_401830_) {
        for (Direction $$4 : p_401891_) {
            BlockPos $$5 = p_401894_.relative($$4);
            if (!p_401878_.isEmptyBlock($$5) || !p_401830_.canSurvive(p_401878_, $$5)) continue;
            return Optional.of($$5);
        }
        return Optional.empty();
    }

    default public BlockPos getParticlePos(BlockPos p_316301_) {
        return switch (this.getType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> p_316301_.above();
            case 1 -> p_316301_;
        };
    }

    default public Type getType() {
        return Type.GROWER;
    }

    public static enum Type {
        NEIGHBOR_SPREADER,
        GROWER;

    }
}

