/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseCoralFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseCoralWallFanBlock
extends BaseCoralFanBlock {
    public static final MapCodec<BaseCoralWallFanBlock> CODEC = BaseCoralWallFanBlock.simpleCodec(BaseCoralWallFanBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(16.0, 8.0, 5.0, 16.0));

    public MapCodec<? extends BaseCoralWallFanBlock> codec() {
        return CODEC;
    }

    protected BaseCoralWallFanBlock(BlockBehaviour.Properties p_49196_) {
        super(p_49196_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(WATERLOGGED, true));
    }

    @Override
    protected VoxelShape getShape(BlockState p_49219_, BlockGetter p_49220_, BlockPos p_49221_, CollisionContext p_49222_) {
        return SHAPES.get(p_49219_.getValue(FACING));
    }

    @Override
    protected BlockState rotate(BlockState p_49207_, Rotation p_49208_) {
        return (BlockState)p_49207_.setValue(FACING, p_49208_.rotate(p_49207_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_49204_, Mirror p_49205_) {
        return p_49204_.rotate(p_49205_.getRotation(p_49204_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49217_) {
        p_49217_.add(FACING, WATERLOGGED);
    }

    @Override
    protected BlockState updateShape(BlockState p_49210_, LevelReader p_374317_, ScheduledTickAccess p_374285_, BlockPos p_49214_, Direction p_49211_, BlockPos p_49215_, BlockState p_49212_, RandomSource p_374146_) {
        if (p_49210_.getValue(WATERLOGGED).booleanValue()) {
            p_374285_.scheduleTick(p_49214_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374317_));
        }
        if (p_49211_.getOpposite() == p_49210_.getValue(FACING) && !p_49210_.canSurvive(p_374317_, p_49214_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return p_49210_;
    }

    @Override
    protected boolean canSurvive(BlockState p_49200_, LevelReader p_49201_, BlockPos p_49202_) {
        Direction $$3 = p_49200_.getValue(FACING);
        BlockPos $$4 = p_49202_.relative($$3.getOpposite());
        BlockState $$5 = p_49201_.getBlockState($$4);
        return $$5.isFaceSturdy(p_49201_, $$4, $$3);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_49198_) {
        Direction[] $$4;
        BlockState $$1 = super.getStateForPlacement(p_49198_);
        Level $$2 = p_49198_.getLevel();
        BlockPos $$3 = p_49198_.getClickedPos();
        for (Direction $$5 : $$4 = p_49198_.getNearestLookingDirections()) {
            if (!$$5.getAxis().isHorizontal() || !($$1 = (BlockState)$$1.setValue(FACING, $$5.getOpposite())).canSurvive($$2, $$3)) continue;
            return $$1;
        }
        return null;
    }
}

