/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AmethystClusterBlock
extends AmethystBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<AmethystClusterBlock> CODEC = RecordCodecBuilder.mapCodec(p_367977_ -> p_367977_.group((App)Codec.FLOAT.fieldOf("height").forGetter(p_304411_ -> Float.valueOf(p_304411_.height)), (App)Codec.FLOAT.fieldOf("width").forGetter(p_393317_ -> Float.valueOf(p_393317_.width)), AmethystClusterBlock.propertiesCodec()).apply((Applicative)p_367977_, AmethystClusterBlock::new));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private final float height;
    private final float width;
    private final Map<Direction, VoxelShape> shapes;

    public MapCodec<AmethystClusterBlock> codec() {
        return CODEC;
    }

    public AmethystClusterBlock(float p_304949_, float p_304728_, BlockBehaviour.Properties p_152017_) {
        super(p_152017_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(WATERLOGGED, false)).setValue(FACING, Direction.UP));
        this.shapes = Shapes.rotateAll(Block.boxZ(p_304728_, 16.0f - p_304949_, 16.0));
        this.height = p_304949_;
        this.width = p_304728_;
    }

    @Override
    protected VoxelShape getShape(BlockState p_152021_, BlockGetter p_152022_, BlockPos p_152023_, CollisionContext p_152024_) {
        return this.shapes.get(p_152021_.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(BlockState p_152026_, LevelReader p_152027_, BlockPos p_152028_) {
        Direction $$3 = p_152026_.getValue(FACING);
        BlockPos $$4 = p_152028_.relative($$3.getOpposite());
        return p_152027_.getBlockState($$4).isFaceSturdy(p_152027_, $$4, $$3);
    }

    @Override
    protected BlockState updateShape(BlockState p_152036_, LevelReader p_374202_, ScheduledTickAccess p_374490_, BlockPos p_152040_, Direction p_152037_, BlockPos p_152041_, BlockState p_152038_, RandomSource p_374353_) {
        if (p_152036_.getValue(WATERLOGGED).booleanValue()) {
            p_374490_.scheduleTick(p_152040_, Fluids.WATER, Fluids.WATER.getTickDelay(p_374202_));
        }
        if (p_152037_ == p_152036_.getValue(FACING).getOpposite() && !p_152036_.canSurvive(p_374202_, p_152040_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_152036_, p_374202_, p_374490_, p_152040_, p_152037_, p_152041_, p_152038_, p_374353_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_152019_) {
        Level $$1 = p_152019_.getLevel();
        BlockPos $$2 = p_152019_.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(WATERLOGGED, $$1.getFluidState($$2).getType() == Fluids.WATER)).setValue(FACING, p_152019_.getClickedFace());
    }

    @Override
    protected BlockState rotate(BlockState p_152033_, Rotation p_152034_) {
        return (BlockState)p_152033_.setValue(FACING, p_152034_.rotate(p_152033_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_152030_, Mirror p_152031_) {
        return p_152030_.rotate(p_152031_.getRotation(p_152030_.getValue(FACING)));
    }

    @Override
    protected FluidState getFluidState(BlockState p_152045_) {
        if (p_152045_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_152045_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_152043_) {
        p_152043_.add(WATERLOGGED, FACING);
    }
}

