/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public class Climate {
    private static final boolean DEBUG_SLOW_BIOME_SEARCH = false;
    private static final float QUANTIZATION_FACTOR = 10000.0f;
    @VisibleForTesting
    protected static final int PARAMETER_COUNT = 7;

    public static TargetPoint target(float p_186782_, float p_186783_, float p_186784_, float p_186785_, float p_186786_, float p_186787_) {
        return new TargetPoint(Climate.quantizeCoord(p_186782_), Climate.quantizeCoord(p_186783_), Climate.quantizeCoord(p_186784_), Climate.quantizeCoord(p_186785_), Climate.quantizeCoord(p_186786_), Climate.quantizeCoord(p_186787_));
    }

    public static ParameterPoint parameters(float p_186789_, float p_186790_, float p_186791_, float p_186792_, float p_186793_, float p_186794_, float p_186795_) {
        return new ParameterPoint(Parameter.point(p_186789_), Parameter.point(p_186790_), Parameter.point(p_186791_), Parameter.point(p_186792_), Parameter.point(p_186793_), Parameter.point(p_186794_), Climate.quantizeCoord(p_186795_));
    }

    public static ParameterPoint parameters(Parameter p_186799_, Parameter p_186800_, Parameter p_186801_, Parameter p_186802_, Parameter p_186803_, Parameter p_186804_, float p_186805_) {
        return new ParameterPoint(p_186799_, p_186800_, p_186801_, p_186802_, p_186803_, p_186804_, Climate.quantizeCoord(p_186805_));
    }

    public static long quantizeCoord(float p_186780_) {
        return (long)(p_186780_ * 10000.0f);
    }

    public static float unquantizeCoord(long p_186797_) {
        return (float)p_186797_ / 10000.0f;
    }

    public static Sampler empty() {
        DensityFunction $$0 = DensityFunctions.zero();
        return new Sampler($$0, $$0, $$0, $$0, $$0, $$0, List.of());
    }

    public static BlockPos findSpawnPosition(List<ParameterPoint> p_207843_, Sampler p_207844_) {
        return new SpawnFinder(p_207843_, (Sampler)p_207844_).result.location();
    }

    public record TargetPoint(long temperature, long humidity, long continentalness, long erosion, long depth, long weirdness) {
        @VisibleForTesting
        protected long[] toParameterArray() {
            return new long[]{this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L};
        }
    }

    public record ParameterPoint(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, long offset) {
        public static final Codec<ParameterPoint> CODEC = RecordCodecBuilder.create(p_186885_ -> p_186885_.group((App)Parameter.CODEC.fieldOf("temperature").forGetter(p_186905_ -> p_186905_.temperature), (App)Parameter.CODEC.fieldOf("humidity").forGetter(p_186902_ -> p_186902_.humidity), (App)Parameter.CODEC.fieldOf("continentalness").forGetter(p_186897_ -> p_186897_.continentalness), (App)Parameter.CODEC.fieldOf("erosion").forGetter(p_186894_ -> p_186894_.erosion), (App)Parameter.CODEC.fieldOf("depth").forGetter(p_186891_ -> p_186891_.depth), (App)Parameter.CODEC.fieldOf("weirdness").forGetter(p_186888_ -> p_186888_.weirdness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::quantizeCoord, Climate::unquantizeCoord).forGetter(p_186881_ -> p_186881_.offset)).apply((Applicative)p_186885_, ParameterPoint::new));

        long fitness(TargetPoint p_186883_) {
            return Mth.square(this.temperature.distance(p_186883_.temperature)) + Mth.square(this.humidity.distance(p_186883_.humidity)) + Mth.square(this.continentalness.distance(p_186883_.continentalness)) + Mth.square(this.erosion.distance(p_186883_.erosion)) + Mth.square(this.depth.distance(p_186883_.depth)) + Mth.square(this.weirdness.distance(p_186883_.weirdness)) + Mth.square(this.offset);
        }

        protected List<Parameter> parameterSpace() {
            return ImmutableList.of((Object)this.temperature, (Object)this.humidity, (Object)this.continentalness, (Object)this.erosion, (Object)this.depth, (Object)this.weirdness, (Object)new Parameter(this.offset, this.offset));
        }
    }

    public record Parameter(long min, long max) {
        public static final Codec<Parameter> CODEC = ExtraCodecs.intervalCodec(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (p_275164_, p_275165_) -> {
            if (p_275164_.compareTo((Float)p_275165_) > 0) {
                return DataResult.error(() -> "Cannon construct interval, min > max (" + p_275164_ + " > " + p_275165_ + ")");
            }
            return DataResult.success((Object)new Parameter(Climate.quantizeCoord(p_275164_.floatValue()), Climate.quantizeCoord(p_275165_.floatValue())));
        }, p_186841_ -> Float.valueOf(Climate.unquantizeCoord(p_186841_.min())), p_186839_ -> Float.valueOf(Climate.unquantizeCoord(p_186839_.max())));

        public static Parameter point(float p_186821_) {
            return Parameter.span(p_186821_, p_186821_);
        }

        public static Parameter span(float p_186823_, float p_186824_) {
            if (p_186823_ > p_186824_) {
                throw new IllegalArgumentException("min > max: " + p_186823_ + " " + p_186824_);
            }
            return new Parameter(Climate.quantizeCoord(p_186823_), Climate.quantizeCoord(p_186824_));
        }

        public static Parameter span(Parameter p_186830_, Parameter p_186831_) {
            if (p_186830_.min() > p_186831_.max()) {
                throw new IllegalArgumentException("min > max: " + String.valueOf(p_186830_) + " " + String.valueOf(p_186831_));
            }
            return new Parameter(p_186830_.min(), p_186831_.max());
        }

        @Override
        public String toString() {
            return this.min == this.max ? String.format(Locale.ROOT, "%d", this.min) : String.format(Locale.ROOT, "[%d-%d]", this.min, this.max);
        }

        public long distance(long p_186826_) {
            long $$1 = p_186826_ - this.max;
            long $$2 = this.min - p_186826_;
            if ($$1 > 0L) {
                return $$1;
            }
            return Math.max($$2, 0L);
        }

        public long distance(Parameter p_186828_) {
            long $$1 = p_186828_.min() - this.max;
            long $$2 = this.min - p_186828_.max();
            if ($$1 > 0L) {
                return $$1;
            }
            return Math.max($$2, 0L);
        }

        public Parameter span(@Nullable Parameter p_186837_) {
            return p_186837_ == null ? this : new Parameter(Math.min(this.min, p_186837_.min()), Math.max(this.max, p_186837_.max()));
        }
    }

    public record Sampler(DensityFunction temperature, DensityFunction humidity, DensityFunction continentalness, DensityFunction erosion, DensityFunction depth, DensityFunction weirdness, List<ParameterPoint> spawnTarget) {
        public TargetPoint sample(int p_186975_, int p_186976_, int p_186977_) {
            int $$3 = QuartPos.toBlock(p_186975_);
            int $$4 = QuartPos.toBlock(p_186976_);
            int $$5 = QuartPos.toBlock(p_186977_);
            DensityFunction.SinglePointContext $$6 = new DensityFunction.SinglePointContext($$3, $$4, $$5);
            return Climate.target((float)this.temperature.compute($$6), (float)this.humidity.compute($$6), (float)this.continentalness.compute($$6), (float)this.erosion.compute($$6), (float)this.depth.compute($$6), (float)this.weirdness.compute($$6));
        }

        public BlockPos findSpawnPosition() {
            if (this.spawnTarget.isEmpty()) {
                return BlockPos.ZERO;
            }
            return Climate.findSpawnPosition(this.spawnTarget, this);
        }
    }

    static class SpawnFinder {
        private static final long MAX_RADIUS = 2048L;
        Result result;

        SpawnFinder(List<ParameterPoint> p_207872_, Sampler p_207873_) {
            this.result = SpawnFinder.getSpawnPositionAndFitness(p_207872_, p_207873_, 0, 0);
            this.radialSearch(p_207872_, p_207873_, 2048.0f, 512.0f);
            this.radialSearch(p_207872_, p_207873_, 512.0f, 32.0f);
        }

        private void radialSearch(List<ParameterPoint> p_207875_, Sampler p_207876_, float p_207877_, float p_207878_) {
            float $$4 = 0.0f;
            float $$5 = p_207878_;
            BlockPos $$6 = this.result.location();
            while ($$5 <= p_207877_) {
                int $$8;
                int $$7 = $$6.getX() + (int)(Math.sin($$4) * (double)$$5);
                Result $$9 = SpawnFinder.getSpawnPositionAndFitness(p_207875_, p_207876_, $$7, $$8 = $$6.getZ() + (int)(Math.cos($$4) * (double)$$5));
                if ($$9.fitness() < this.result.fitness()) {
                    this.result = $$9;
                }
                if (!((double)($$4 += p_207878_ / $$5) > Math.PI * 2)) continue;
                $$4 = 0.0f;
                $$5 += p_207878_;
            }
        }

        private static Result getSpawnPositionAndFitness(List<ParameterPoint> p_207880_, Sampler p_207881_, int p_207882_, int p_207883_) {
            TargetPoint $$4 = p_207881_.sample(QuartPos.fromBlock(p_207882_), 0, QuartPos.fromBlock(p_207883_));
            TargetPoint $$5 = new TargetPoint($$4.temperature(), $$4.humidity(), $$4.continentalness(), $$4.erosion(), 0L, $$4.weirdness());
            long $$6 = Long.MAX_VALUE;
            for (ParameterPoint $$7 : p_207880_) {
                $$6 = Math.min($$6, $$7.fitness($$5));
            }
            long $$8 = Mth.square((long)p_207882_) + Mth.square((long)p_207883_);
            long $$9 = $$6 * Mth.square(2048L) + $$8;
            return new Result(new BlockPos(p_207882_, 0, p_207883_), $$9);
        }

        record Result(BlockPos location, long fitness) {
        }
    }

    public static class ParameterList<T> {
        private final List<Pair<ParameterPoint, T>> values;
        private final RTree<T> index;

        public static <T> Codec<ParameterList<T>> codec(MapCodec<T> p_275523_) {
            return ExtraCodecs.nonEmptyList(RecordCodecBuilder.create(p_275233_ -> p_275233_.group((App)ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)p_275523_.forGetter(Pair::getSecond)).apply((Applicative)p_275233_, Pair::of)).listOf()).xmap(ParameterList::new, ParameterList::values);
        }

        public ParameterList(List<Pair<ParameterPoint, T>> p_186849_) {
            this.values = p_186849_;
            this.index = RTree.create(p_186849_);
        }

        public List<Pair<ParameterPoint, T>> values() {
            return this.values;
        }

        public T findValue(TargetPoint p_204253_) {
            return this.findValueIndex(p_204253_);
        }

        @VisibleForTesting
        public T findValueBruteForce(TargetPoint p_204255_) {
            Iterator<Pair<ParameterPoint, T>> $$1 = this.values().iterator();
            Pair<ParameterPoint, T> $$2 = $$1.next();
            long $$3 = ((ParameterPoint)$$2.getFirst()).fitness(p_204255_);
            Object $$4 = $$2.getSecond();
            while ($$1.hasNext()) {
                Pair<ParameterPoint, T> $$5 = $$1.next();
                long $$6 = ((ParameterPoint)$$5.getFirst()).fitness(p_204255_);
                if ($$6 >= $$3) continue;
                $$3 = $$6;
                $$4 = $$5.getSecond();
            }
            return (T)$$4;
        }

        public T findValueIndex(TargetPoint p_186852_) {
            return this.findValueIndex(p_186852_, RTree.Node::distance);
        }

        protected T findValueIndex(TargetPoint p_186854_, DistanceMetric<T> p_186855_) {
            return this.index.search(p_186854_, p_186855_);
        }
    }

    protected static final class RTree<T> {
        private static final int CHILDREN_PER_NODE = 6;
        private final Node<T> root;
        private final ThreadLocal<Leaf<T>> lastResult = new ThreadLocal();

        private RTree(Node<T> p_186913_) {
            this.root = p_186913_;
        }

        public static <T> RTree<T> create(List<Pair<ParameterPoint, T>> p_186936_) {
            if (p_186936_.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int $$1 = ((ParameterPoint)p_186936_.get(0).getFirst()).parameterSpace().size();
            if ($$1 != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + $$1);
            }
            List $$2 = p_186936_.stream().map(p_186934_ -> new Leaf<Object>((ParameterPoint)p_186934_.getFirst(), p_186934_.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new RTree<T>(RTree.build($$1, $$2));
        }

        private static <T> Node<T> build(int p_186921_, List<? extends Node<T>> p_186922_) {
            if (p_186922_.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (p_186922_.size() == 1) {
                return p_186922_.get(0);
            }
            if (p_186922_.size() <= 6) {
                p_186922_.sort(Comparator.comparingLong(p_186916_ -> {
                    long $$2 = 0L;
                    for (int $$3 = 0; $$3 < p_186921_; ++$$3) {
                        Parameter $$4 = p_186916_.parameterSpace[$$3];
                        $$2 += Math.abs(($$4.min() + $$4.max()) / 2L);
                    }
                    return $$2;
                }));
                return new SubTree(p_186922_);
            }
            long $$2 = Long.MAX_VALUE;
            int $$3 = -1;
            List<SubTree<T>> $$4 = null;
            for (int $$5 = 0; $$5 < p_186921_; ++$$5) {
                RTree.sort(p_186922_, p_186921_, $$5, false);
                List<SubTree<T>> $$6 = RTree.bucketize(p_186922_);
                long $$7 = 0L;
                for (SubTree<T> $$8 : $$6) {
                    $$7 += RTree.cost($$8.parameterSpace);
                }
                if ($$2 <= $$7) continue;
                $$2 = $$7;
                $$3 = $$5;
                $$4 = $$6;
            }
            RTree.sort($$4, p_186921_, $$3, true);
            return new SubTree($$4.stream().map(p_186919_ -> RTree.build(p_186921_, Arrays.asList(p_186919_.children))).collect(Collectors.toList()));
        }

        private static <T> void sort(List<? extends Node<T>> p_186938_, int p_186939_, int p_186940_, boolean p_186941_) {
            Comparator<Node<Node<T>>> $$4 = RTree.comparator(p_186940_, p_186941_);
            for (int $$5 = 1; $$5 < p_186939_; ++$$5) {
                $$4 = $$4.thenComparing(RTree.comparator((p_186940_ + $$5) % p_186939_, p_186941_));
            }
            p_186938_.sort($$4);
        }

        private static <T> Comparator<Node<T>> comparator(int p_186924_, boolean p_186925_) {
            return Comparator.comparingLong(p_186929_ -> {
                Parameter $$3 = p_186929_.parameterSpace[p_186924_];
                long $$4 = ($$3.min() + $$3.max()) / 2L;
                return p_186925_ ? Math.abs($$4) : $$4;
            });
        }

        private static <T> List<SubTree<T>> bucketize(List<? extends Node<T>> p_186945_) {
            ArrayList $$1 = Lists.newArrayList();
            ArrayList $$2 = Lists.newArrayList();
            int $$3 = (int)Math.pow(6.0, Math.floor(Math.log((double)p_186945_.size() - 0.01) / Math.log(6.0)));
            for (Node<T> $$4 : p_186945_) {
                $$2.add($$4);
                if ($$2.size() < $$3) continue;
                $$1.add(new SubTree($$2));
                $$2 = Lists.newArrayList();
            }
            if (!$$2.isEmpty()) {
                $$1.add(new SubTree($$2));
            }
            return $$1;
        }

        private static long cost(Parameter[] p_186943_) {
            long $$1 = 0L;
            for (Parameter $$2 : p_186943_) {
                $$1 += Math.abs($$2.max() - $$2.min());
            }
            return $$1;
        }

        static <T> List<Parameter> buildParameterSpace(List<? extends Node<T>> p_186947_) {
            if (p_186947_.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int $$1 = 7;
            ArrayList $$2 = Lists.newArrayList();
            for (int $$3 = 0; $$3 < 7; ++$$3) {
                $$2.add(null);
            }
            for (Node<T> $$4 : p_186947_) {
                for (int $$5 = 0; $$5 < 7; ++$$5) {
                    $$2.set($$5, $$4.parameterSpace[$$5].span((Parameter)$$2.get($$5)));
                }
            }
            return $$2;
        }

        public T search(TargetPoint p_186931_, DistanceMetric<T> p_186932_) {
            long[] $$2 = p_186931_.toParameterArray();
            Leaf<T> $$3 = this.root.search($$2, this.lastResult.get(), p_186932_);
            this.lastResult.set($$3);
            return $$3.value;
        }

        static abstract class Node<T> {
            protected final Parameter[] parameterSpace;

            protected Node(List<Parameter> p_186958_) {
                this.parameterSpace = p_186958_.toArray(new Parameter[0]);
            }

            protected abstract Leaf<T> search(long[] var1, @Nullable Leaf<T> var2, DistanceMetric<T> var3);

            protected long distance(long[] p_186960_) {
                long $$1 = 0L;
                for (int $$2 = 0; $$2 < 7; ++$$2) {
                    $$1 += Mth.square(this.parameterSpace[$$2].distance(p_186960_[$$2]));
                }
                return $$1;
            }

            public String toString() {
                return Arrays.toString(this.parameterSpace);
            }
        }

        static final class SubTree<T>
        extends Node<T> {
            final Node<T>[] children;

            protected SubTree(List<? extends Node<T>> p_186967_) {
                this(RTree.buildParameterSpace(p_186967_), p_186967_);
            }

            protected SubTree(List<Parameter> p_186969_, List<? extends Node<T>> p_186970_) {
                super(p_186969_);
                this.children = p_186970_.toArray(new Node[0]);
            }

            @Override
            protected Leaf<T> search(long[] p_186972_, @Nullable Leaf<T> p_186973_, DistanceMetric<T> p_186974_) {
                long $$3 = p_186973_ == null ? Long.MAX_VALUE : p_186974_.distance(p_186973_, p_186972_);
                Leaf<T> $$4 = p_186973_;
                for (Node<T> $$5 : this.children) {
                    long $$8;
                    long $$6 = p_186974_.distance($$5, p_186972_);
                    if ($$3 <= $$6) continue;
                    Leaf<T> $$7 = $$5.search(p_186972_, $$4, p_186974_);
                    long l = $$8 = $$5 == $$7 ? $$6 : p_186974_.distance($$7, p_186972_);
                    if ($$3 <= $$8) continue;
                    $$3 = $$8;
                    $$4 = $$7;
                }
                return $$4;
            }
        }

        static final class Leaf<T>
        extends Node<T> {
            final T value;

            Leaf(ParameterPoint p_186950_, T p_186951_) {
                super(p_186950_.parameterSpace());
                this.value = p_186951_;
            }

            @Override
            protected Leaf<T> search(long[] p_186953_, @Nullable Leaf<T> p_186954_, DistanceMetric<T> p_186955_) {
                return this;
            }
        }
    }

    static interface DistanceMetric<T> {
        public long distance(RTree.Node<T> var1, long[] var2);
    }
}

