/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureManager {
    private final LevelAccessor level;
    private final WorldOptions worldOptions;
    private final StructureCheck structureCheck;

    public StructureManager(LevelAccessor p_249675_, WorldOptions p_248820_, StructureCheck p_249103_) {
        this.level = p_249675_;
        this.worldOptions = p_248820_;
        this.structureCheck = p_249103_;
    }

    public StructureManager forWorldGenRegion(WorldGenRegion p_220469_) {
        if (p_220469_.getLevel() != this.level) {
            throw new IllegalStateException("Using invalid structure manager (source level: " + String.valueOf(p_220469_.getLevel()) + ", region: " + String.valueOf(p_220469_));
        }
        return new StructureManager(p_220469_, this.worldOptions, this.structureCheck);
    }

    public List<StructureStart> startsForStructure(ChunkPos p_220478_, Predicate<Structure> p_220479_) {
        Map<Structure, LongSet> $$2 = this.level.getChunk(p_220478_.x, p_220478_.z, ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
        ImmutableList.Builder $$3 = ImmutableList.builder();
        for (Map.Entry<Structure, LongSet> $$4 : $$2.entrySet()) {
            Structure $$5 = $$4.getKey();
            if (!p_220479_.test($$5)) continue;
            this.fillStartsForStructure($$5, $$4.getValue(), arg_0 -> ((ImmutableList.Builder)$$3).add(arg_0));
        }
        return $$3.build();
    }

    public List<StructureStart> startsForStructure(SectionPos p_220505_, Structure p_220506_) {
        LongSet $$2 = this.level.getChunk(p_220505_.x(), p_220505_.z(), ChunkStatus.STRUCTURE_REFERENCES).getReferencesForStructure(p_220506_);
        ImmutableList.Builder $$3 = ImmutableList.builder();
        this.fillStartsForStructure(p_220506_, $$2, arg_0 -> ((ImmutableList.Builder)$$3).add(arg_0));
        return $$3.build();
    }

    public void fillStartsForStructure(Structure p_220481_, LongSet p_220482_, Consumer<StructureStart> p_220483_) {
        LongIterator longIterator = p_220482_.iterator();
        while (longIterator.hasNext()) {
            long $$3 = (Long)longIterator.next();
            SectionPos $$4 = SectionPos.of(new ChunkPos($$3), this.level.getMinSectionY());
            StructureStart $$5 = this.getStartForStructure($$4, p_220481_, this.level.getChunk($$4.x(), $$4.z(), ChunkStatus.STRUCTURE_STARTS));
            if ($$5 == null || !$$5.isValid()) continue;
            p_220483_.accept($$5);
        }
    }

    @Nullable
    public StructureStart getStartForStructure(SectionPos p_220513_, Structure p_220514_, StructureAccess p_220515_) {
        return p_220515_.getStartForStructure(p_220514_);
    }

    public void setStartForStructure(SectionPos p_220517_, Structure p_220518_, StructureStart p_220519_, StructureAccess p_220520_) {
        p_220520_.setStartForStructure(p_220518_, p_220519_);
    }

    public void addReferenceForStructure(SectionPos p_220508_, Structure p_220509_, long p_220510_, StructureAccess p_220511_) {
        p_220511_.addReferenceForStructure(p_220509_, p_220510_);
    }

    public boolean shouldGenerateStructures() {
        return this.worldOptions.generateStructures();
    }

    public StructureStart getStructureAt(BlockPos p_220495_, Structure p_220496_) {
        for (StructureStart $$2 : this.startsForStructure(SectionPos.of(p_220495_), p_220496_)) {
            if (!$$2.getBoundingBox().isInside(p_220495_)) continue;
            return $$2;
        }
        return StructureStart.INVALID_START;
    }

    public StructureStart getStructureWithPieceAt(BlockPos p_220492_, TagKey<Structure> p_220493_) {
        return this.getStructureWithPieceAt(p_220492_, (Holder<Structure> p_330125_) -> p_330125_.is(p_220493_));
    }

    public StructureStart getStructureWithPieceAt(BlockPos p_331369_, HolderSet<Structure> p_330290_) {
        return this.getStructureWithPieceAt(p_331369_, p_330290_::contains);
    }

    public StructureStart getStructureWithPieceAt(BlockPos p_220489_, Predicate<Holder<Structure>> p_332144_) {
        HolderLookup.RegistryLookup $$2 = this.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (StructureStart $$3 : this.startsForStructure(new ChunkPos(p_220489_), arg_0 -> StructureManager.lambda$getStructureWithPieceAt$1((Registry)$$2, p_332144_, arg_0))) {
            if (!this.structureHasPieceAt(p_220489_, $$3)) continue;
            return $$3;
        }
        return StructureStart.INVALID_START;
    }

    public StructureStart getStructureWithPieceAt(BlockPos p_220525_, Structure p_220526_) {
        for (StructureStart $$2 : this.startsForStructure(SectionPos.of(p_220525_), p_220526_)) {
            if (!this.structureHasPieceAt(p_220525_, $$2)) continue;
            return $$2;
        }
        return StructureStart.INVALID_START;
    }

    public boolean structureHasPieceAt(BlockPos p_220498_, StructureStart p_220499_) {
        for (StructurePiece $$2 : p_220499_.getPieces()) {
            if (!$$2.getBoundingBox().isInside(p_220498_)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyStructureAt(BlockPos p_220487_) {
        SectionPos $$1 = SectionPos.of(p_220487_);
        return this.level.getChunk($$1.x(), $$1.z(), ChunkStatus.STRUCTURE_REFERENCES).hasAnyStructureReferences();
    }

    public Map<Structure, LongSet> getAllStructuresAt(BlockPos p_220523_) {
        SectionPos $$1 = SectionPos.of(p_220523_);
        return this.level.getChunk($$1.x(), $$1.z(), ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
    }

    public StructureCheckResult checkStructurePresence(ChunkPos p_220474_, Structure p_220475_, StructurePlacement p_321768_, boolean p_220476_) {
        return this.structureCheck.checkStart(p_220474_, p_220475_, p_321768_, p_220476_);
    }

    public void addReference(StructureStart p_220485_) {
        p_220485_.addReference();
        this.structureCheck.incrementReference(p_220485_.getChunkPos(), p_220485_.getStructure());
    }

    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    private static /* synthetic */ boolean lambda$getStructureWithPieceAt$1(Registry p_367974_, Predicate p_367975_, Structure p_367976_) {
        return p_367974_.get(p_367974_.getId(p_367976_)).map(p_367975_::test).orElse(false);
    }
}

