/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.block.entity.FuelValues;

public interface SlotDisplay {
    public static final Codec<SlotDisplay> CODEC = BuiltInRegistries.SLOT_DISPLAY.byNameCodec().dispatch(SlotDisplay::type, Type::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotDisplay> STREAM_CODEC = ByteBufCodecs.registry(Registries.SLOT_DISPLAY).dispatch(SlotDisplay::type, Type::streamCodec);

    public <T> Stream<T> resolve(ContextMap var1, DisplayContentsFactory<T> var2);

    public Type<? extends SlotDisplay> type();

    default public boolean isEnabled(FeatureFlagSet p_379569_) {
        return true;
    }

    default public List<ItemStack> resolveForStacks(ContextMap p_380953_) {
        return this.resolve(p_380953_, ItemStackContentsFactory.INSTANCE).toList();
    }

    default public ItemStack resolveForFirstStack(ContextMap p_381094_) {
        return this.resolve(p_381094_, ItemStackContentsFactory.INSTANCE).findFirst().orElse(ItemStack.EMPTY);
    }

    public static class ItemStackContentsFactory
    implements DisplayContentsFactory.ForStacks<ItemStack> {
        public static final ItemStackContentsFactory INSTANCE = new ItemStackContentsFactory();

        @Override
        public ItemStack forStack(ItemStack p_381043_) {
            return p_381043_;
        }

        @Override
        public /* synthetic */ Object forStack(ItemStack itemStack) {
            return this.forStack(itemStack);
        }
    }

    public record WithRemainder(SlotDisplay input, SlotDisplay remainder) implements SlotDisplay
    {
        public static final MapCodec<WithRemainder> MAP_CODEC = RecordCodecBuilder.mapCodec(p_380938_ -> p_380938_.group((App)CODEC.fieldOf("input").forGetter(WithRemainder::input), (App)CODEC.fieldOf("remainder").forGetter(WithRemainder::remainder)).apply((Applicative)p_380938_, WithRemainder::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WithRemainder> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, WithRemainder::input, STREAM_CODEC, WithRemainder::remainder, WithRemainder::new);
        public static final Type<WithRemainder> TYPE = new Type<WithRemainder>(MAP_CODEC, STREAM_CODEC);

        public Type<WithRemainder> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381035_, DisplayContentsFactory<T> p_380959_) {
            if (p_380959_ instanceof DisplayContentsFactory.ForRemainders) {
                DisplayContentsFactory.ForRemainders $$2 = (DisplayContentsFactory.ForRemainders)p_380959_;
                List $$3 = this.remainder.resolve(p_381035_, p_380959_).toList();
                return this.input.resolve(p_381035_, p_380959_).map(p_381158_ -> $$2.addRemainder(p_381158_, $$3));
            }
            return this.input.resolve(p_381035_, p_380959_);
        }

        @Override
        public boolean isEnabled(FeatureFlagSet p_381096_) {
            return this.input.isEnabled(p_381096_) && this.remainder.isEnabled(p_381096_);
        }
    }

    public record Composite(List<SlotDisplay> contents) implements SlotDisplay
    {
        public static final MapCodec<Composite> MAP_CODEC = RecordCodecBuilder.mapCodec(p_379498_ -> p_379498_.group((App)CODEC.listOf().fieldOf("contents").forGetter(Composite::contents)).apply((Applicative)p_379498_, Composite::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Composite> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC.apply(ByteBufCodecs.list()), Composite::contents, Composite::new);
        public static final Type<Composite> TYPE = new Type<Composite>(MAP_CODEC, STREAM_CODEC);

        public Type<Composite> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381068_, DisplayContentsFactory<T> p_380997_) {
            return this.contents.stream().flatMap(p_380856_ -> p_380856_.resolve(p_381068_, p_380997_));
        }

        @Override
        public boolean isEnabled(FeatureFlagSet p_379563_) {
            return this.contents.stream().allMatch(p_380321_ -> p_380321_.isEnabled(p_379563_));
        }
    }

    public record TagSlotDisplay(TagKey<Item> tag) implements SlotDisplay
    {
        public static final MapCodec<TagSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(p_379704_ -> p_379704_.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(TagSlotDisplay::tag)).apply((Applicative)p_379704_, TagSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TagSlotDisplay> STREAM_CODEC = StreamCodec.composite(TagKey.streamCodec(Registries.ITEM), TagSlotDisplay::tag, TagSlotDisplay::new);
        public static final Type<TagSlotDisplay> TYPE = new Type<TagSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        public Type<TagSlotDisplay> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381013_, DisplayContentsFactory<T> p_381072_) {
            if (p_381072_ instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks $$2 = (DisplayContentsFactory.ForStacks)p_381072_;
                HolderLookup.Provider $$3 = p_381013_.getOptional(SlotDisplayContext.REGISTRIES);
                if ($$3 != null) {
                    return $$3.lookupOrThrow(Registries.ITEM).get(this.tag).map(p_380858_ -> p_380858_.stream().map($$2::forStack)).stream().flatMap(p_380859_ -> p_380859_);
                }
            }
            return Stream.empty();
        }
    }

    public record ItemStackSlotDisplay(ItemStack stack) implements SlotDisplay
    {
        public static final MapCodec<ItemStackSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(p_379658_ -> p_379658_.group((App)ItemStack.STRICT_CODEC.fieldOf("item").forGetter(ItemStackSlotDisplay::stack)).apply((Applicative)p_379658_, ItemStackSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackSlotDisplay> STREAM_CODEC = StreamCodec.composite(ItemStack.STREAM_CODEC, ItemStackSlotDisplay::stack, ItemStackSlotDisplay::new);
        public static final Type<ItemStackSlotDisplay> TYPE = new Type<ItemStackSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        public Type<ItemStackSlotDisplay> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381143_, DisplayContentsFactory<T> p_381015_) {
            if (p_381015_ instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks $$2 = (DisplayContentsFactory.ForStacks)p_381015_;
                return Stream.of($$2.forStack(this.stack));
            }
            return Stream.empty();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object p_379392_) {
            if (this == p_379392_) return true;
            if (!(p_379392_ instanceof ItemStackSlotDisplay)) return false;
            ItemStackSlotDisplay $$1 = (ItemStackSlotDisplay)p_379392_;
            if (!ItemStack.matches(this.stack, $$1.stack)) return false;
            return true;
        }

        @Override
        public boolean isEnabled(FeatureFlagSet p_380009_) {
            return this.stack.getItem().isEnabled(p_380009_);
        }
    }

    public record ItemSlotDisplay(Holder<Item> item) implements SlotDisplay
    {
        public static final MapCodec<ItemSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(p_381584_ -> p_381584_.group((App)Item.CODEC.fieldOf("item").forGetter(ItemSlotDisplay::item)).apply((Applicative)p_381584_, ItemSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemSlotDisplay> STREAM_CODEC = StreamCodec.composite(Item.STREAM_CODEC, ItemSlotDisplay::item, ItemSlotDisplay::new);
        public static final Type<ItemSlotDisplay> TYPE = new Type<ItemSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        public ItemSlotDisplay(Item p_379935_) {
            this(p_379935_.builtInRegistryHolder());
        }

        public Type<ItemSlotDisplay> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381162_, DisplayContentsFactory<T> p_381086_) {
            if (p_381086_ instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks $$2 = (DisplayContentsFactory.ForStacks)p_381086_;
                return Stream.of($$2.forStack(this.item));
            }
            return Stream.empty();
        }

        @Override
        public boolean isEnabled(FeatureFlagSet p_379445_) {
            return this.item.value().isEnabled(p_379445_);
        }
    }

    public record SmithingTrimDemoSlotDisplay(SlotDisplay base, SlotDisplay material, Holder<TrimPattern> pattern) implements SlotDisplay
    {
        public static final MapCodec<SmithingTrimDemoSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(p_399430_ -> p_399430_.group((App)CODEC.fieldOf("base").forGetter(SmithingTrimDemoSlotDisplay::base), (App)CODEC.fieldOf("material").forGetter(SmithingTrimDemoSlotDisplay::material), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(SmithingTrimDemoSlotDisplay::pattern)).apply((Applicative)p_399430_, SmithingTrimDemoSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimDemoSlotDisplay> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, SmithingTrimDemoSlotDisplay::base, STREAM_CODEC, SmithingTrimDemoSlotDisplay::material, TrimPattern.STREAM_CODEC, SmithingTrimDemoSlotDisplay::pattern, SmithingTrimDemoSlotDisplay::new);
        public static final Type<SmithingTrimDemoSlotDisplay> TYPE = new Type<SmithingTrimDemoSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        public Type<SmithingTrimDemoSlotDisplay> type() {
            return TYPE;
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381017_, DisplayContentsFactory<T> p_381079_) {
            if (p_381079_ instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks $$2 = (DisplayContentsFactory.ForStacks)p_381079_;
                HolderLookup.Provider $$3 = p_381017_.getOptional(SlotDisplayContext.REGISTRIES);
                if ($$3 != null) {
                    RandomSource $$4 = RandomSource.create(System.identityHashCode(this));
                    List<ItemStack> $$5 = this.base.resolveForStacks(p_381017_);
                    if ($$5.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> $$6 = this.material.resolveForStacks(p_381017_);
                    if ($$6.isEmpty()) {
                        return Stream.empty();
                    }
                    return Stream.generate(() -> {
                        ItemStack $$4 = (ItemStack)Util.getRandom($$5, $$4);
                        ItemStack $$5 = (ItemStack)Util.getRandom($$6, $$4);
                        return SmithingTrimRecipe.applyTrim($$3, $$4, $$5, this.pattern);
                    }).limit(256L).filter(p_381123_ -> !p_381123_.isEmpty()).limit(16L).map($$2::forStack);
                }
            }
            return Stream.empty();
        }
    }

    public static class AnyFuel
    implements SlotDisplay {
        public static final AnyFuel INSTANCE = new AnyFuel();
        public static final MapCodec<AnyFuel> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
        public static final StreamCodec<RegistryFriendlyByteBuf, AnyFuel> STREAM_CODEC = StreamCodec.unit(INSTANCE);
        public static final Type<AnyFuel> TYPE = new Type<AnyFuel>(MAP_CODEC, STREAM_CODEC);

        private AnyFuel() {
        }

        public Type<AnyFuel> type() {
            return TYPE;
        }

        public String toString() {
            return "<any fuel>";
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_380999_, DisplayContentsFactory<T> p_381006_) {
            if (p_381006_ instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks $$2 = (DisplayContentsFactory.ForStacks)p_381006_;
                FuelValues $$3 = p_380999_.getOptional(SlotDisplayContext.FUEL_VALUES);
                if ($$3 != null) {
                    return $$3.fuelItems().stream().map($$2::forStack);
                }
            }
            return Stream.empty();
        }
    }

    public static class Empty
    implements SlotDisplay {
        public static final Empty INSTANCE = new Empty();
        public static final MapCodec<Empty> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
        public static final StreamCodec<RegistryFriendlyByteBuf, Empty> STREAM_CODEC = StreamCodec.unit(INSTANCE);
        public static final Type<Empty> TYPE = new Type<Empty>(MAP_CODEC, STREAM_CODEC);

        private Empty() {
        }

        public Type<Empty> type() {
            return TYPE;
        }

        public String toString() {
            return "<empty>";
        }

        @Override
        public <T> Stream<T> resolve(ContextMap p_381154_, DisplayContentsFactory<T> p_380978_) {
            return Stream.empty();
        }
    }

    public record Type<T extends SlotDisplay>(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
    }
}

