/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;

public final class ShapedRecipePattern {
    private static final int MAX_SIZE = 3;
    public static final char EMPTY_SLOT = ' ';
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, p_344423_ -> p_344423_.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, p_360067_ -> p_360067_.width, ByteBufCodecs.VAR_INT, p_360066_ -> p_360066_.height, Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), p_360065_ -> p_360065_.ingredients, ShapedRecipePattern::createFromNetwork);
    private final int width;
    private final int height;
    private final List<Optional<Ingredient>> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public ShapedRecipePattern(int p_311959_, int p_312714_, List<Optional<Ingredient>> p_360908_, Optional<Data> p_312427_) {
        this.width = p_311959_;
        this.height = p_312714_;
        this.ingredients = p_360908_;
        this.data = p_312427_;
        this.ingredientCount = (int)p_360908_.stream().flatMap(Optional::stream).count();
        this.symmetrical = Util.isSymmetrical(p_311959_, p_312714_, p_360908_);
    }

    private static ShapedRecipePattern createFromNetwork(Integer p_363312_, Integer p_363884_, List<Optional<Ingredient>> p_364060_) {
        return new ShapedRecipePattern(p_363312_, p_363884_, p_364060_, Optional.empty());
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> p_312851_, String ... p_312645_) {
        return ShapedRecipePattern.of(p_312851_, List.of(p_312645_));
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> p_312370_, List<String> p_312701_) {
        Data $$2 = new Data(p_312370_, p_312701_);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack($$2).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(Data p_312037_) {
        String[] $$1 = ShapedRecipePattern.shrink(p_312037_.pattern);
        int $$2 = $$1[0].length();
        int $$3 = $$1.length;
        ArrayList<Optional<Ingredient>> $$4 = new ArrayList<Optional<Ingredient>>($$2 * $$3);
        CharArraySet $$5 = new CharArraySet(p_312037_.key.keySet());
        for (String $$6 : $$1) {
            for (int $$7 = 0; $$7 < $$6.length(); ++$$7) {
                Optional<Ingredient> $$11;
                char $$8 = $$6.charAt($$7);
                if ($$8 == ' ') {
                    Optional $$9 = Optional.empty();
                } else {
                    Ingredient $$10 = p_312037_.key.get(Character.valueOf($$8));
                    if ($$10 == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + $$8 + "' but it's not defined in the key");
                    }
                    $$11 = Optional.of($$10);
                }
                $$5.remove($$8);
                $$4.add($$11);
            }
        }
        if (!$$5.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.lambda$unpack$7((CharSet)$$5));
        }
        return DataResult.success((Object)new ShapedRecipePattern($$2, $$3, $$4, Optional.of(p_312037_)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> p_311893_) {
        int $$1 = Integer.MAX_VALUE;
        int $$2 = 0;
        int $$3 = 0;
        int $$4 = 0;
        for (int $$5 = 0; $$5 < p_311893_.size(); ++$$5) {
            String $$6 = p_311893_.get($$5);
            $$1 = Math.min($$1, ShapedRecipePattern.firstNonEmpty($$6));
            int $$7 = ShapedRecipePattern.lastNonEmpty($$6);
            $$2 = Math.max($$2, $$7);
            if ($$7 < 0) {
                if ($$3 == $$5) {
                    ++$$3;
                }
                ++$$4;
                continue;
            }
            $$4 = 0;
        }
        if (p_311893_.size() == $$4) {
            return new String[0];
        }
        String[] $$8 = new String[p_311893_.size() - $$4 - $$3];
        for (int $$9 = 0; $$9 < $$8.length; ++$$9) {
            $$8[$$9] = p_311893_.get($$9 + $$3).substring($$1, $$2 + 1);
        }
        return $$8;
    }

    private static int firstNonEmpty(String p_312343_) {
        int $$1;
        for ($$1 = 0; $$1 < p_312343_.length() && p_312343_.charAt($$1) == ' '; ++$$1) {
        }
        return $$1;
    }

    private static int lastNonEmpty(String p_311944_) {
        int $$1;
        for ($$1 = p_311944_.length() - 1; $$1 >= 0 && p_311944_.charAt($$1) == ' '; --$$1) {
        }
        return $$1;
    }

    public boolean matches(CraftingInput p_345063_) {
        if (p_345063_.ingredientCount() != this.ingredientCount) {
            return false;
        }
        if (p_345063_.width() == this.width && p_345063_.height() == this.height) {
            if (!this.symmetrical && this.matches(p_345063_, true)) {
                return true;
            }
            if (this.matches(p_345063_, false)) {
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingInput p_345835_, boolean p_344990_) {
        for (int $$2 = 0; $$2 < this.height; ++$$2) {
            for (int $$3 = 0; $$3 < this.width; ++$$3) {
                Optional<Ingredient> $$5;
                if (p_344990_) {
                    Optional<Ingredient> $$4 = this.ingredients.get(this.width - $$3 - 1 + $$2 * this.width);
                } else {
                    $$5 = this.ingredients.get($$3 + $$2 * this.width);
                }
                ItemStack $$6 = p_345835_.getItem($$3, $$2);
                if (Ingredient.testOptionalIngredient($$5, $$6)) continue;
                return false;
            }
        }
        return true;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public List<Optional<Ingredient>> ingredients() {
        return this.ingredients;
    }

    private static /* synthetic */ String lambda$unpack$7(CharSet p_339534_) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(p_339534_);
    }

    public record Data(Map<Character, Ingredient> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(p_312085_ -> {
            if (p_312085_.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (p_312085_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int $$1 = ((String)p_312085_.getFirst()).length();
            for (String $$2 : p_312085_) {
                if ($$2.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if ($$1 == $$2.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_312085_);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(p_312250_ -> {
            if (p_312250_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_312250_ + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(p_312250_)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf(p_312250_.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(p_360068_ -> p_360068_.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, Ingredient.CODEC).fieldOf("key").forGetter(p_312509_ -> p_312509_.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(p_312713_ -> p_312713_.pattern)).apply((Applicative)p_360068_, Data::new));
    }
}

