/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BookContent;
import net.minecraft.world.item.component.TooltipProvider;

public record WrittenBookContent(Filterable<String> title, String author, int generation, List<Filterable<Component>> pages, boolean resolved) implements BookContent<Component, WrittenBookContent>,
TooltipProvider
{
    public static final WrittenBookContent EMPTY = new WrittenBookContent(Filterable.passThrough(""), "", 0, List.of(), true);
    public static final int PAGE_LENGTH = Short.MAX_VALUE;
    public static final int TITLE_LENGTH = 16;
    public static final int TITLE_MAX_LENGTH = 32;
    public static final int MAX_GENERATION = 3;
    public static final int MAX_CRAFTABLE_GENERATION = 2;
    public static final Codec<Component> CONTENT_CODEC = ComponentSerialization.flatRestrictedCodec(Short.MAX_VALUE);
    public static final Codec<List<Filterable<Component>>> PAGES_CODEC = WrittenBookContent.pagesCodec(CONTENT_CODEC);
    public static final Codec<WrittenBookContent> CODEC = RecordCodecBuilder.create(p_331461_ -> p_331461_.group((App)Filterable.codec(Codec.string((int)0, (int)32)).fieldOf("title").forGetter(WrittenBookContent::title), (App)Codec.STRING.fieldOf("author").forGetter(WrittenBookContent::author), (App)ExtraCodecs.intRange(0, 3).optionalFieldOf("generation", (Object)0).forGetter(WrittenBookContent::generation), (App)PAGES_CODEC.optionalFieldOf("pages", List.of()).forGetter(WrittenBookContent::pages), (App)Codec.BOOL.optionalFieldOf("resolved", (Object)false).forGetter(WrittenBookContent::resolved)).apply((Applicative)p_331461_, WrittenBookContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WrittenBookContent> STREAM_CODEC = StreamCodec.composite(Filterable.streamCodec(ByteBufCodecs.stringUtf8(32)), WrittenBookContent::title, ByteBufCodecs.STRING_UTF8, WrittenBookContent::author, ByteBufCodecs.VAR_INT, WrittenBookContent::generation, Filterable.streamCodec(ComponentSerialization.STREAM_CODEC).apply(ByteBufCodecs.list()), WrittenBookContent::pages, ByteBufCodecs.BOOL, WrittenBookContent::resolved, WrittenBookContent::new);

    public WrittenBookContent {
        if (generation < 0 || generation > 3) {
            throw new IllegalArgumentException("Generation was " + generation + ", but must be between 0 and 3");
        }
    }

    private static Codec<Filterable<Component>> pageCodec(Codec<Component> p_335677_) {
        return Filterable.codec(p_335677_);
    }

    public static Codec<List<Filterable<Component>>> pagesCodec(Codec<Component> p_335930_) {
        return WrittenBookContent.pageCodec(p_335930_).listOf();
    }

    @Nullable
    public WrittenBookContent tryCraftCopy() {
        if (this.generation >= 2) {
            return null;
        }
        return new WrittenBookContent(this.title, this.author, this.generation + 1, this.pages, this.resolved);
    }

    public static boolean resolveForItem(ItemStack p_394373_, CommandSourceStack p_393899_, @Nullable Player p_393825_) {
        WrittenBookContent $$3 = p_394373_.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if ($$3 != null && !$$3.resolved()) {
            WrittenBookContent $$4 = $$3.resolve(p_393899_, p_393825_);
            if ($$4 != null) {
                p_394373_.set(DataComponents.WRITTEN_BOOK_CONTENT, $$4);
                return true;
            }
            p_394373_.set(DataComponents.WRITTEN_BOOK_CONTENT, $$3.markResolved());
        }
        return false;
    }

    @Nullable
    public WrittenBookContent resolve(CommandSourceStack p_330312_, @Nullable Player p_331808_) {
        if (this.resolved) {
            return null;
        }
        ImmutableList.Builder $$2 = ImmutableList.builderWithExpectedSize((int)this.pages.size());
        for (Filterable<Component> $$3 : this.pages) {
            Optional<Filterable<Component>> $$4 = WrittenBookContent.resolvePage(p_330312_, p_331808_, $$3);
            if ($$4.isEmpty()) {
                return null;
            }
            $$2.add($$4.get());
        }
        return new WrittenBookContent(this.title, this.author, this.generation, (List<Filterable<Component>>)$$2.build(), true);
    }

    public WrittenBookContent markResolved() {
        return new WrittenBookContent(this.title, this.author, this.generation, this.pages, true);
    }

    private static Optional<Filterable<Component>> resolvePage(CommandSourceStack p_330620_, @Nullable Player p_330555_, Filterable<Component> p_330218_) {
        return p_330218_.resolve(p_331526_ -> {
            try {
                MutableComponent $$3 = ComponentUtils.updateForEntity(p_330620_, p_331526_, (Entity)p_330555_, 0);
                if (WrittenBookContent.isPageTooLarge($$3, p_330620_.registryAccess())) {
                    return Optional.empty();
                }
                return Optional.of($$3);
            }
            catch (Exception $$4) {
                return Optional.of(p_331526_);
            }
        });
    }

    private static boolean isPageTooLarge(Component p_331458_, HolderLookup.Provider p_331039_) {
        DataResult $$2 = ComponentSerialization.CODEC.encodeStart(p_331039_.createSerializationContext(JsonOps.INSTANCE), (Object)p_331458_);
        return $$2.isSuccess() && GsonHelper.encodesLongerThan((JsonElement)$$2.getOrThrow(), Short.MAX_VALUE);
    }

    public List<Component> getPages(boolean p_330387_) {
        return Lists.transform(this.pages, p_332134_ -> (Component)p_332134_.get(p_330387_));
    }

    @Override
    public WrittenBookContent withReplacedPages(List<Filterable<Component>> p_333901_) {
        return new WrittenBookContent(this.title, this.author, this.generation, p_333901_, false);
    }

    @Override
    public void addToTooltip(Item.TooltipContext p_393666_, Consumer<Component> p_393982_, TooltipFlag p_394366_, DataComponentGetter p_400256_) {
        if (!StringUtil.isBlank(this.author)) {
            p_393982_.accept(Component.translatable("book.byAuthor", this.author).withStyle(ChatFormatting.GRAY));
        }
        p_393982_.accept(Component.translatable("book.generation." + this.generation).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public /* synthetic */ Object withReplacedPages(List list) {
        return this.withReplacedPages(list);
    }
}

