/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public record JukeboxPlayable(EitherHolder<JukeboxSong> song) implements TooltipProvider
{
    public static final Codec<JukeboxPlayable> CODEC = EitherHolder.codec(Registries.JUKEBOX_SONG, JukeboxSong.CODEC).xmap(JukeboxPlayable::new, JukeboxPlayable::song);
    public static final StreamCodec<RegistryFriendlyByteBuf, JukeboxPlayable> STREAM_CODEC = StreamCodec.composite(EitherHolder.streamCodec(Registries.JUKEBOX_SONG, JukeboxSong.STREAM_CODEC), JukeboxPlayable::song, JukeboxPlayable::new);

    @Override
    public void addToTooltip(Item.TooltipContext p_350489_, Consumer<Component> p_350818_, TooltipFlag p_350358_, DataComponentGetter p_399685_) {
        HolderLookup.Provider $$4 = p_350489_.registries();
        if ($$4 != null) {
            this.song.unwrap($$4).ifPresent(p_350916_ -> {
                MutableComponent $$2 = ((JukeboxSong)p_350916_.value()).description().copy();
                ComponentUtils.mergeStyles($$2, Style.EMPTY.withColor(ChatFormatting.GRAY));
                p_350818_.accept($$2);
            });
        }
    }

    public static InteractionResult tryInsertIntoJukebox(Level p_350560_, BlockPos p_350567_, ItemStack p_350531_, Player p_350807_) {
        JukeboxPlayable $$4 = p_350531_.get(DataComponents.JUKEBOX_PLAYABLE);
        if ($$4 == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockState $$5 = p_350560_.getBlockState(p_350567_);
        if (!$$5.is(Blocks.JUKEBOX) || $$5.getValue(JukeboxBlock.HAS_RECORD).booleanValue()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!p_350560_.isClientSide) {
            ItemStack $$6 = p_350531_.consumeAndReturn(1, p_350807_);
            BlockEntity blockEntity = p_350560_.getBlockEntity(p_350567_);
            if (blockEntity instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity $$7 = (JukeboxBlockEntity)blockEntity;
                $$7.setTheItem($$6);
                p_350560_.gameEvent(GameEvent.BLOCK_CHANGE, p_350567_, GameEvent.Context.of(p_350807_, $$5));
            }
            p_350807_.awardStat(Stats.PLAY_RECORD);
        }
        return InteractionResult.SUCCESS;
    }
}

