/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class HangingEntityItem
extends Item {
    private static final Component TOOLTIP_RANDOM_VARIANT = Component.translatable("painting.random").withStyle(ChatFormatting.GRAY);
    private final EntityType<? extends HangingEntity> type;

    public HangingEntityItem(EntityType<? extends HangingEntity> p_41324_, Item.Properties p_41325_) {
        super(p_41325_);
        this.type = p_41324_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InteractionResult useOn(UseOnContext p_41331_) {
        void $$11;
        BlockPos $$1 = p_41331_.getClickedPos();
        Direction $$2 = p_41331_.getClickedFace();
        BlockPos $$3 = $$1.relative($$2);
        Player $$4 = p_41331_.getPlayer();
        ItemStack $$5 = p_41331_.getItemInHand();
        if ($$4 != null && !this.mayPlace($$4, $$2, $$5, $$3)) {
            return InteractionResult.FAIL;
        }
        Level $$6 = p_41331_.getLevel();
        if (this.type == EntityType.PAINTING) {
            Optional<Painting> $$7 = Painting.create($$6, $$3, $$2);
            if ($$7.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            HangingEntity $$8 = $$7.get();
        } else if (this.type == EntityType.ITEM_FRAME) {
            ItemFrame $$9 = new ItemFrame($$6, $$3, $$2);
        } else if (this.type == EntityType.GLOW_ITEM_FRAME) {
            GlowItemFrame $$10 = new GlowItemFrame($$6, $$3, $$2);
        } else {
            return InteractionResult.SUCCESS;
        }
        EntityType.createDefaultStackConfig($$6, $$5, $$4).accept($$11);
        if ($$11.survives()) {
            if (!$$6.isClientSide) {
                $$11.playPlacementSound();
                $$6.gameEvent((Entity)$$4, GameEvent.ENTITY_PLACE, $$11.position());
                $$6.addFreshEntity((Entity)$$11);
            }
            $$5.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player p_41326_, Direction p_41327_, ItemStack p_41328_, BlockPos p_41329_) {
        return !p_41327_.getAxis().isVertical() && p_41326_.mayUseItemAt(p_41329_, p_41327_, p_41328_);
    }

    @Override
    public void appendHoverText(ItemStack p_270235_, Item.TooltipContext p_339644_, TooltipDisplay p_400204_, Consumer<Component> p_400127_, TooltipFlag p_270170_) {
        if (this.type == EntityType.PAINTING && p_400204_.shows(DataComponents.PAINTING_VARIANT)) {
            Holder<PaintingVariant> $$5 = p_270235_.get(DataComponents.PAINTING_VARIANT);
            if ($$5 != null) {
                $$5.value().title().ifPresent(p_400127_);
                $$5.value().author().ifPresent(p_400127_);
                p_400127_.accept(Component.translatable("painting.dimensions", $$5.value().width(), $$5.value().height()));
            } else if (p_270170_.isCreative()) {
                p_400127_.accept(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

