/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketItem
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties p_41209_) {
        super(p_41209_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_41216_) {
        Level $$1 = p_41216_.getLevel();
        Player $$2 = p_41216_.getPlayer();
        if ($$2 != null && $$2.isFallFlying()) {
            return InteractionResult.PASS;
        }
        if ($$1 instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)$$1;
            ItemStack $$4 = p_41216_.getItemInHand();
            Vec3 $$5 = p_41216_.getClickLocation();
            Direction $$6 = p_41216_.getClickedFace();
            Projectile.spawnProjectile(new FireworkRocketEntity($$1, p_41216_.getPlayer(), $$5.x + (double)$$6.getStepX() * 0.15, $$5.y + (double)$$6.getStepY() * 0.15, $$5.z + (double)$$6.getStepZ() * 0.15, $$4), $$3, $$4);
            $$4.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level p_41218_, Player p_41219_, InteractionHand p_41220_) {
        if (p_41219_.isFallFlying()) {
            ItemStack $$3 = p_41219_.getItemInHand(p_41220_);
            if (p_41218_ instanceof ServerLevel) {
                ServerLevel $$4 = (ServerLevel)p_41218_;
                if (p_41219_.dropAllLeashConnections(null)) {
                    p_41218_.playSound(null, p_41219_, SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                Projectile.spawnProjectile(new FireworkRocketEntity(p_41218_, $$3, p_41219_), $$4, $$3);
                $$3.consume(1, p_41219_);
                p_41219_.awardStat(Stats.ITEM_USED.get(this));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public Projectile asProjectile(Level p_338390_, Position p_338574_, ItemStack p_338487_, Direction p_338368_) {
        return new FireworkRocketEntity(p_338390_, p_338487_.copyWithCount(1), p_338574_.x(), p_338574_.y(), p_338574_.z(), true);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(FireworkRocketItem::getEntityJustOutsideOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3 getEntityJustOutsideOfBlockPos(BlockSource p_371687_, Direction p_371656_) {
        return p_371687_.center().add((double)p_371656_.getStepX() * 0.5000099999997474, (double)p_371656_.getStepY() * 0.5000099999997474, (double)p_371656_.getStepZ() * 0.5000099999997474);
    }
}

