/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class CompassItem
extends Item {
    private static final Component LODESTONE_COMPASS_NAME = Component.translatable("item.minecraft.lodestone_compass");

    public CompassItem(Item.Properties p_40718_) {
        super(p_40718_);
    }

    @Override
    public boolean isFoil(ItemStack p_40739_) {
        return p_40739_.has(DataComponents.LODESTONE_TRACKER) || super.isFoil(p_40739_);
    }

    @Override
    public void inventoryTick(ItemStack p_40720_, ServerLevel p_401770_, Entity p_40722_, @Nullable EquipmentSlot p_401781_) {
        LodestoneTracker $$5;
        LodestoneTracker $$4 = p_40720_.get(DataComponents.LODESTONE_TRACKER);
        if ($$4 != null && ($$5 = $$4.tick(p_401770_)) != $$4) {
            p_40720_.set(DataComponents.LODESTONE_TRACKER, $$5);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext p_40726_) {
        BlockPos $$1 = p_40726_.getClickedPos();
        Level $$2 = p_40726_.getLevel();
        if ($$2.getBlockState($$1).is(Blocks.LODESTONE)) {
            $$2.playSound(null, $$1, SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
            Player $$3 = p_40726_.getPlayer();
            ItemStack $$4 = p_40726_.getItemInHand();
            boolean $$5 = !$$3.hasInfiniteMaterials() && $$4.getCount() == 1;
            LodestoneTracker $$6 = new LodestoneTracker(Optional.of(GlobalPos.of($$2.dimension(), $$1)), true);
            if ($$5) {
                $$4.set(DataComponents.LODESTONE_TRACKER, $$6);
            } else {
                ItemStack $$7 = $$4.transmuteCopy(Items.COMPASS, 1);
                $$4.consume(1, $$3);
                $$7.set(DataComponents.LODESTONE_TRACKER, $$6);
                if (!$$3.getInventory().add($$7)) {
                    $$3.drop($$7, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(p_40726_);
    }

    @Override
    public Component getName(ItemStack p_371723_) {
        return p_371723_.has(DataComponents.LODESTONE_TRACKER) ? LODESTONE_COMPASS_NAME : super.getName(p_371723_);
    }
}

