/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class HorseInventoryMenu
extends AbstractContainerMenu {
    private static final ResourceLocation SADDLE_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/saddle");
    private static final ResourceLocation LLAMA_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/llama_armor");
    private static final ResourceLocation ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/horse_armor");
    private final Container horseContainer;
    private final AbstractHorse horse;
    private static final int SLOT_SADDLE = 0;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;

    public HorseInventoryMenu(int p_39656_, Inventory p_39657_, Container p_39658_, final AbstractHorse p_39659_, int p_352384_) {
        super(null, p_39656_);
        this.horseContainer = p_39658_;
        this.horse = p_39659_;
        p_39658_.startOpen(p_39657_.player);
        Container $$5 = p_39659_.createEquipmentSlotContainer(EquipmentSlot.SADDLE);
        this.addSlot(new ArmorSlot(this, $$5, p_39659_, EquipmentSlot.SADDLE, 0, 8, 18, SADDLE_SLOT_SPRITE){

            @Override
            public boolean isActive() {
                return p_39659_.canUseSlot(EquipmentSlot.SADDLE) && p_39659_.getType().is(EntityTypeTags.CAN_EQUIP_SADDLE);
            }
        });
        final boolean $$6 = p_39659_ instanceof Llama;
        ResourceLocation $$7 = $$6 ? LLAMA_ARMOR_SLOT_SPRITE : ARMOR_SLOT_SPRITE;
        Container $$8 = p_39659_.createEquipmentSlotContainer(EquipmentSlot.BODY);
        this.addSlot(new ArmorSlot(this, $$8, p_39659_, EquipmentSlot.BODY, 0, 8, 36, $$7){

            @Override
            public boolean isActive() {
                return p_39659_.canUseSlot(EquipmentSlot.BODY) && (p_39659_.getType().is(EntityTypeTags.CAN_WEAR_HORSE_ARMOR) || $$6);
            }
        });
        if (p_352384_ > 0) {
            for (int $$9 = 0; $$9 < 3; ++$$9) {
                for (int $$10 = 0; $$10 < p_352384_; ++$$10) {
                    this.addSlot(new Slot(p_39658_, $$10 + $$9 * p_352384_, 80 + $$10 * 18, 18 + $$9 * 18));
                }
            }
        }
        this.addStandardInventorySlots(p_39657_, 8, 84);
    }

    @Override
    public boolean stillValid(Player p_39661_) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(p_39661_) && this.horse.isAlive() && p_39661_.canInteractWithEntity(this.horse, 4.0);
    }

    @Override
    public ItemStack quickMoveStack(Player p_39665_, int p_39666_) {
        ItemStack $$2 = ItemStack.EMPTY;
        Slot $$3 = (Slot)this.slots.get(p_39666_);
        if ($$3 != null && $$3.hasItem()) {
            ItemStack $$4 = $$3.getItem();
            $$2 = $$4.copy();
            int $$5 = 2 + this.horseContainer.getContainerSize();
            if (p_39666_ < $$5) {
                if (!this.moveItemStackTo($$4, $$5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace($$4) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo($$4, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace($$4) && !this.getSlot(0).hasItem()) {
                if (!this.moveItemStackTo($$4, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.horseContainer.getContainerSize() == 0 || !this.moveItemStackTo($$4, 2, $$5, false)) {
                int $$6;
                int $$7 = $$6 = $$5 + 27;
                int $$8 = $$7 + 9;
                if (p_39666_ >= $$7 && p_39666_ < $$8 ? !this.moveItemStackTo($$4, $$5, $$6, false) : (p_39666_ >= $$5 && p_39666_ < $$6 ? !this.moveItemStackTo($$4, $$7, $$8, false) : !this.moveItemStackTo($$4, $$7, $$6, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$3.setByPlayer(ItemStack.EMPTY);
            } else {
                $$3.setChanged();
            }
        }
        return $$2;
    }

    @Override
    public void removed(Player p_39663_) {
        super.removed(p_39663_);
        this.horseContainer.stopOpen(p_39663_);
    }
}

