/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3;

public class Raids
extends SavedData {
    private static final String RAID_FILE_ID = "raids";
    public static final Codec<Raids> CODEC = RecordCodecBuilder.create(p_400930_ -> p_400930_.group((App)RaidWithId.CODEC.listOf().optionalFieldOf(RAID_FILE_ID, List.of()).forGetter(p_400932_ -> p_400932_.raidMap.int2ObjectEntrySet().stream().map(RaidWithId::from).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(p_400933_ -> p_400933_.nextId), (App)Codec.INT.fieldOf("tick").forGetter(p_400931_ -> p_400931_.tick)).apply((Applicative)p_400930_, Raids::new));
    public static final SavedDataType<Raids> TYPE = new SavedDataType<Raids>("raids", Raids::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    public static final SavedDataType<Raids> TYPE_END = new SavedDataType<Raids>("raids_end", Raids::new, CODEC, DataFixTypes.SAVED_DATA_RAIDS);
    private final Int2ObjectMap<Raid> raidMap = new Int2ObjectOpenHashMap();
    private int nextId = 1;
    private int tick;

    public static SavedDataType<Raids> getType(Holder<DimensionType> p_401277_) {
        if (p_401277_.is(BuiltinDimensionTypes.END)) {
            return TYPE_END;
        }
        return TYPE;
    }

    public Raids() {
        this.setDirty();
    }

    private Raids(List<RaidWithId> p_401252_, int p_401028_, int p_401314_) {
        for (RaidWithId $$3 : p_401252_) {
            this.raidMap.put($$3.id, (Object)$$3.raid);
        }
        this.nextId = p_401028_;
        this.tick = p_401314_;
    }

    @Nullable
    public Raid get(int p_37959_) {
        return (Raid)this.raidMap.get(p_37959_);
    }

    public OptionalInt getId(Raid p_401241_) {
        for (Int2ObjectMap.Entry $$1 : this.raidMap.int2ObjectEntrySet()) {
            if ($$1.getValue() != p_401241_) continue;
            return OptionalInt.of($$1.getIntKey());
        }
        return OptionalInt.empty();
    }

    public void tick(ServerLevel p_401204_) {
        ++this.tick;
        ObjectIterator $$1 = this.raidMap.values().iterator();
        while ($$1.hasNext()) {
            Raid $$2 = (Raid)$$1.next();
            if (p_401204_.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                $$2.stop();
            }
            if ($$2.isStopped()) {
                $$1.remove();
                this.setDirty();
                continue;
            }
            $$2.tick(p_401204_);
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
        DebugPackets.sendRaids(p_401204_, (Collection<Raid>)this.raidMap.values());
    }

    public static boolean canJoinRaid(Raider p_37966_) {
        return p_37966_.isAlive() && p_37966_.canJoinRaid() && p_37966_.getNoActionTime() <= 2400;
    }

    @Nullable
    public Raid createOrExtendRaid(ServerPlayer p_37964_, BlockPos p_338602_) {
        BlockPos $$10;
        if (p_37964_.isSpectator()) {
            return null;
        }
        ServerLevel $$2 = p_37964_.level();
        if ($$2.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        DimensionType $$3 = $$2.dimensionType();
        if (!$$3.hasRaids()) {
            return null;
        }
        List<PoiRecord> $$4 = $$2.getPoiManager().getInRange(p_219845_ -> p_219845_.is(PoiTypeTags.VILLAGE), p_338602_, 64, PoiManager.Occupancy.IS_OCCUPIED).toList();
        int $$5 = 0;
        Vec3 $$6 = Vec3.ZERO;
        for (PoiRecord $$7 : $$4) {
            BlockPos $$8 = $$7.getPos();
            $$6 = $$6.add($$8.getX(), $$8.getY(), $$8.getZ());
            ++$$5;
        }
        if ($$5 > 0) {
            $$6 = $$6.scale(1.0 / (double)$$5);
            BlockPos $$9 = BlockPos.containing($$6);
        } else {
            $$10 = p_338602_;
        }
        Raid $$11 = this.getOrCreateRaid($$2, $$10);
        if (!$$11.isStarted() && !this.raidMap.containsValue((Object)$$11)) {
            this.raidMap.put(this.getUniqueId(), (Object)$$11);
        }
        if (!$$11.isStarted() || $$11.getRaidOmenLevel() < $$11.getMaxRaidOmenLevel()) {
            $$11.absorbRaidOmen(p_37964_);
        }
        this.setDirty();
        return $$11;
    }

    private Raid getOrCreateRaid(ServerLevel p_37961_, BlockPos p_37962_) {
        Raid $$2 = p_37961_.getRaidAt(p_37962_);
        return $$2 != null ? $$2 : new Raid(p_37962_, p_37961_.getDifficulty());
    }

    public static Raids load(CompoundTag p_150237_) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_150237_).resultOrPartial().orElseGet(Raids::new);
    }

    private int getUniqueId() {
        return ++this.nextId;
    }

    @Nullable
    public Raid getNearbyRaid(BlockPos p_37971_, int p_37972_) {
        Raid $$2 = null;
        double $$3 = p_37972_;
        for (Raid $$4 : this.raidMap.values()) {
            double $$5 = $$4.getCenter().distSqr(p_37971_);
            if (!$$4.isActive() || !($$5 < $$3)) continue;
            $$2 = $$4;
            $$3 = $$5;
        }
        return $$2;
    }

    record RaidWithId(int id, Raid raid) {
        public static final Codec<RaidWithId> CODEC = RecordCodecBuilder.create(p_401087_ -> p_401087_.group((App)Codec.INT.fieldOf("id").forGetter(RaidWithId::id), (App)Raid.MAP_CODEC.forGetter(RaidWithId::raid)).apply((Applicative)p_401087_, RaidWithId::new));

        public static RaidWithId from(Int2ObjectMap.Entry<Raid> p_401228_) {
            return new RaidWithId(p_401228_.getIntKey(), (Raid)p_401228_.getValue());
        }
    }
}

