/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class ThrownSplashPotion
extends AbstractThrownPotion {
    public ThrownSplashPotion(EntityType<? extends ThrownSplashPotion> p_400190_, Level p_399722_) {
        super((EntityType<? extends AbstractThrownPotion>)p_400190_, p_399722_);
    }

    public ThrownSplashPotion(Level p_399777_, LivingEntity p_400264_, ItemStack p_400186_) {
        super(EntityType.SPLASH_POTION, p_399777_, p_400264_, p_400186_);
    }

    public ThrownSplashPotion(Level p_400144_, double p_400061_, double p_400032_, double p_399549_, ItemStack p_400218_) {
        super(EntityType.SPLASH_POTION, p_400144_, p_400061_, p_400032_, p_399549_, p_400218_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    public void onHitAsPotion(ServerLevel p_399483_, ItemStack p_400156_, HitResult p_422131_) {
        PotionContents $$3 = p_400156_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        float $$4 = p_400156_.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffectInstance> $$5 = $$3.getAllEffects();
        AABB $$6 = this.getBoundingBox().move(p_422131_.getLocation().subtract(this.position()));
        AABB $$7 = $$6.inflate(4.0, 2.0, 4.0);
        List<LivingEntity> $$8 = this.level().getEntitiesOfClass(LivingEntity.class, $$7);
        float $$9 = ProjectileUtil.computeMargin(this);
        if (!$$8.isEmpty()) {
            Entity $$10 = this.getEffectSource();
            for (LivingEntity $$11 : $$8) {
                double $$12;
                if (!$$11.isAffectedByPotions() || !(($$12 = $$6.distanceToSqr($$11.getBoundingBox().inflate($$9))) < 16.0)) continue;
                double $$13 = 1.0 - Math.sqrt($$12) / 4.0;
                for (MobEffectInstance $$14 : $$5) {
                    Holder<MobEffect> $$15 = $$14.getEffect();
                    if ($$15.value().isInstantenous()) {
                        $$15.value().applyInstantenousEffect(p_399483_, this, this.getOwner(), $$11, $$14.getAmplifier(), $$13);
                        continue;
                    }
                    int $$16 = $$14.mapDuration(p_400103_ -> (int)($$13 * (double)p_400103_ * (double)$$4 + 0.5));
                    MobEffectInstance $$17 = new MobEffectInstance($$15, $$16, $$14.getAmplifier(), $$14.isAmbient(), $$14.isVisible());
                    if ($$17.endsWithin(20)) continue;
                    $$11.addEffect($$17, $$10);
                }
            }
        }
    }
}

