/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class FishingHook
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource syncronizedRandom = RandomSource.create();
    private boolean biting;
    private int outOfWaterTime;
    private static final int MAX_OUT_OF_WATER_TIME = 10;
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(FishingHook.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(FishingHook.class, EntityDataSerializers.BOOLEAN);
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    @Nullable
    private Entity hookedIn;
    private FishHookState currentState = FishHookState.FLYING;
    private final int luck;
    private final int lureSpeed;
    private final InterpolationHandler interpolationHandler = new InterpolationHandler(this);

    private FishingHook(EntityType<? extends FishingHook> p_150141_, Level p_150142_, int p_150143_, int p_150144_) {
        super((EntityType<? extends Projectile>)p_150141_, p_150142_);
        this.luck = Math.max(0, p_150143_);
        this.lureSpeed = Math.max(0, p_150144_);
    }

    public FishingHook(EntityType<? extends FishingHook> p_150138_, Level p_150139_) {
        this(p_150138_, p_150139_, 0, 0);
    }

    public FishingHook(Player p_37106_, Level p_37107_, int p_37108_, int p_37109_) {
        this(EntityType.FISHING_BOBBER, p_37107_, p_37108_, p_37109_);
        this.setOwner(p_37106_);
        float $$4 = p_37106_.getXRot();
        float $$5 = p_37106_.getYRot();
        float $$6 = Mth.cos(-$$5 * ((float)Math.PI / 180) - (float)Math.PI);
        float $$7 = Mth.sin(-$$5 * ((float)Math.PI / 180) - (float)Math.PI);
        float $$8 = -Mth.cos(-$$4 * ((float)Math.PI / 180));
        float $$9 = Mth.sin(-$$4 * ((float)Math.PI / 180));
        double $$10 = p_37106_.getX() - (double)$$7 * 0.3;
        double $$11 = p_37106_.getEyeY();
        double $$12 = p_37106_.getZ() - (double)$$6 * 0.3;
        this.snapTo($$10, $$11, $$12, $$5, $$4);
        Vec3 $$13 = new Vec3(-$$7, Mth.clamp(-($$9 / $$8), -5.0f, 5.0f), -$$6);
        double $$14 = $$13.length();
        $$13 = $$13.multiply(0.6 / $$14 + this.random.triangle(0.5, 0.0103365), 0.6 / $$14 + this.random.triangle(0.5, 0.0103365), 0.6 / $$14 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement($$13);
        this.setYRot((float)(Mth.atan2($$13.x, $$13.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2($$13.y, $$13.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    @Nonnull
    public InterpolationHandler getInterpolation() {
        return this.interpolationHandler;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326397_) {
        p_326397_.define(DATA_HOOKED_ENTITY, 0);
        p_326397_.define(DATA_BITING, false);
    }

    @Override
    protected boolean shouldBounceOnWorldBorder() {
        return true;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_37153_) {
        if (DATA_HOOKED_ENTITY.equals(p_37153_)) {
            int $$1 = this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = $$1 > 0 ? this.level().getEntity($$1 - 1) : null;
        }
        if (DATA_BITING.equals(p_37153_)) {
            this.biting = this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat(this.syncronizedRandom, 0.6f, 1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(p_37153_);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_37125_) {
        double $$1 = 64.0;
        return p_37125_ < 4096.0;
    }

    @Override
    public void tick() {
        boolean $$4;
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        this.getInterpolation().interpolate();
        super.tick();
        Player $$0 = this.getPlayerOwner();
        if ($$0 == null) {
            this.discard();
            return;
        }
        if (!this.level().isClientSide && this.shouldStopFishing($$0)) {
            return;
        }
        if (this.onGround()) {
            ++this.life;
            if (this.life >= 1200) {
                this.discard();
                return;
            }
        } else {
            this.life = 0;
        }
        float $$1 = 0.0f;
        BlockPos $$2 = this.blockPosition();
        FluidState $$3 = this.level().getFluidState($$2);
        if ($$3.is(FluidTags.WATER)) {
            $$1 = $$3.getHeight(this.level(), $$2);
        }
        boolean bl = $$4 = $$1 > 0.0f;
        if (this.currentState == FishHookState.FLYING) {
            if (this.hookedIn != null) {
                this.setDeltaMovement(Vec3.ZERO);
                this.currentState = FishHookState.HOOKED_IN_ENTITY;
                return;
            }
            if ($$4) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                this.currentState = FishHookState.BOBBING;
                return;
            }
            this.checkCollision();
        } else {
            if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                if (this.hookedIn != null) {
                    if (this.hookedIn.isRemoved() || this.hookedIn.level().dimension() != this.level().dimension()) {
                        this.setHookedEntity(null);
                        this.currentState = FishHookState.FLYING;
                    } else {
                        this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
                    }
                }
                return;
            }
            if (this.currentState == FishHookState.BOBBING) {
                Vec3 $$5 = this.getDeltaMovement();
                double $$6 = this.getY() + $$5.y - (double)$$2.getY() - (double)$$1;
                if (Math.abs($$6) < 0.01) {
                    $$6 += Math.signum($$6) * 0.1;
                }
                this.setDeltaMovement($$5.x * 0.9, $$5.y - $$6 * (double)this.random.nextFloat() * 0.2, $$5.z * 0.9);
                this.openWater = this.nibble > 0 || this.timeUntilHooked > 0 ? this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater($$2) : true;
                if ($$4) {
                    this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                    if (this.biting) {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                    }
                    if (!this.level().isClientSide) {
                        this.catchingFish($$2);
                    }
                } else {
                    this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                }
            }
        }
        if (!$$3.is(FluidTags.WATER) && !this.onGround() && this.hookedIn == null) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.applyEffectsFromBlocks();
        this.updateRotation();
        if (this.currentState == FishHookState.FLYING && (this.onGround() || this.horizontalCollision)) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        double $$7 = 0.92;
        this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
        this.reapplyPosition();
    }

    private boolean shouldStopFishing(Player p_37137_) {
        ItemStack $$1 = p_37137_.getMainHandItem();
        ItemStack $$2 = p_37137_.getOffhandItem();
        boolean $$3 = $$1.is(Items.FISHING_ROD);
        boolean $$4 = $$2.is(Items.FISHING_ROD);
        if (p_37137_.isRemoved() || !p_37137_.isAlive() || !$$3 && !$$4 || this.distanceToSqr(p_37137_) > 1024.0) {
            this.discard();
            return true;
        }
        return false;
    }

    private void checkCollision() {
        HitResult $$0 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        this.hitTargetOrDeflectSelf($$0);
    }

    @Override
    protected boolean canHitEntity(Entity p_37135_) {
        return super.canHitEntity(p_37135_) || p_37135_.isAlive() && p_37135_ instanceof ItemEntity;
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37144_) {
        super.onHitEntity(p_37144_);
        if (!this.level().isClientSide) {
            this.setHookedEntity(p_37144_.getEntity());
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult p_37142_) {
        super.onHitBlock(p_37142_);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(p_37142_.distanceTo(this)));
    }

    private void setHookedEntity(@Nullable Entity p_150158_) {
        this.hookedIn = p_150158_;
        this.getEntityData().set(DATA_HOOKED_ENTITY, p_150158_ == null ? 0 : p_150158_.getId() + 1);
    }

    private void catchingFish(BlockPos p_37146_) {
        ServerLevel $$1 = (ServerLevel)this.level();
        int $$2 = 1;
        BlockPos $$3 = p_37146_.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt($$3)) {
            ++$$2;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSky($$3)) {
            --$$2;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= $$2;
            if (this.timeUntilHooked > 0) {
                double $$9;
                double $$8;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float $$4 = this.fishAngle * ((float)Math.PI / 180);
                float $$5 = Mth.sin($$4);
                float $$6 = Mth.cos($$4);
                double $$7 = this.getX() + (double)($$5 * (float)this.timeUntilHooked * 0.1f);
                BlockState $$10 = $$1.getBlockState(BlockPos.containing($$7, ($$8 = (double)((float)Mth.floor(this.getY()) + 1.0f)) - 1.0, $$9 = this.getZ() + (double)($$6 * (float)this.timeUntilHooked * 0.1f)));
                if ($$10.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        $$1.sendParticles(ParticleTypes.BUBBLE, $$7, $$8 - (double)0.1f, $$9, 1, $$5, 0.1, $$6, 0.0);
                    }
                    float $$11 = $$5 * 0.04f;
                    float $$12 = $$6 * 0.04f;
                    $$1.sendParticles(ParticleTypes.FISHING, $$7, $$8, $$9, 0, $$12, 0.01, -$$11, 1.0);
                    $$1.sendParticles(ParticleTypes.FISHING, $$7, $$8, $$9, 0, -$$12, 0.01, $$11, 1.0);
                }
            } else {
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double $$13 = this.getY() + 0.5;
                $$1.sendParticles(ParticleTypes.BUBBLE, this.getX(), $$13, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                $$1.sendParticles(ParticleTypes.FISHING, this.getX(), $$13, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                this.nibble = Mth.nextInt(this.random, 20, 40);
                this.getEntityData().set(DATA_BITING, true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= $$2;
            float $$14 = 0.15f;
            if (this.timeUntilLured < 20) {
                $$14 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                $$14 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                $$14 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < $$14) {
                double $$19;
                double $$18;
                float $$15 = Mth.nextFloat(this.random, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float $$16 = Mth.nextFloat(this.random, 25.0f, 60.0f);
                double $$17 = this.getX() + (double)(Mth.sin($$15) * $$16) * 0.1;
                BlockState $$20 = $$1.getBlockState(BlockPos.containing($$17, ($$18 = (double)((float)Mth.floor(this.getY()) + 1.0f)) - 1.0, $$19 = this.getZ() + (double)(Mth.cos($$15) * $$16) * 0.1));
                if ($$20.is(Blocks.WATER)) {
                    $$1.sendParticles(ParticleTypes.SPLASH, $$17, $$18, $$19, 2 + this.random.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat(this.random, 0.0f, 360.0f);
                this.timeUntilHooked = Mth.nextInt(this.random, 20, 80);
            }
        } else {
            this.timeUntilLured = Mth.nextInt(this.random, 100, 600);
            this.timeUntilLured -= this.lureSpeed;
        }
    }

    private boolean calculateOpenWater(BlockPos p_37159_) {
        OpenWaterType $$1 = OpenWaterType.INVALID;
        for (int $$2 = -1; $$2 <= 2; ++$$2) {
            OpenWaterType $$3 = this.getOpenWaterTypeForArea(p_37159_.offset(-2, $$2, -2), p_37159_.offset(2, $$2, 2));
            switch ($$3.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if ($$1 != OpenWaterType.INVALID) break;
                    return false;
                }
                case 1: {
                    if ($$1 != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            $$1 = $$3;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.betweenClosedStream(p_37148_, p_37149_).map(this::getOpenWaterTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos p_37164_) {
        BlockState $$1 = this.level().getBlockState(p_37164_);
        if ($$1.isAir() || $$1.is(Blocks.LILY_PAD)) {
            return OpenWaterType.ABOVE_WATER;
        }
        FluidState $$2 = $$1.getFluidState();
        if ($$2.is(FluidTags.WATER) && $$2.isSource() && $$1.getCollisionShape(this.level(), p_37164_).isEmpty()) {
            return OpenWaterType.INSIDE_WATER;
        }
        return OpenWaterType.INVALID;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422703_) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_422660_) {
    }

    public int retrieve(ItemStack p_37157_) {
        Player $$1 = this.getPlayerOwner();
        if (this.level().isClientSide || $$1 == null || this.shouldStopFishing($$1)) {
            return 0;
        }
        int $$2 = 0;
        if (this.hookedIn != null) {
            this.pullEntity(this.hookedIn);
            CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)$$1, p_37157_, this, Collections.emptyList());
            this.level().broadcastEntityEvent(this, (byte)31);
            $$2 = this.hookedIn instanceof ItemEntity ? 3 : 5;
        } else if (this.nibble > 0) {
            LootParams $$3 = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.TOOL, p_37157_).withParameter(LootContextParams.THIS_ENTITY, this).withLuck((float)this.luck + $$1.getLuck()).create(LootContextParamSets.FISHING);
            LootTable $$4 = this.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
            ObjectArrayList<ItemStack> $$5 = $$4.getRandomItems($$3);
            CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)$$1, p_37157_, this, (Collection<ItemStack>)$$5);
            for (ItemStack $$6 : $$5) {
                ItemEntity $$7 = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), $$6);
                double $$8 = $$1.getX() - this.getX();
                double $$9 = $$1.getY() - this.getY();
                double $$10 = $$1.getZ() - this.getZ();
                double $$11 = 0.1;
                $$7.setDeltaMovement($$8 * 0.1, $$9 * 0.1 + Math.sqrt(Math.sqrt($$8 * $$8 + $$9 * $$9 + $$10 * $$10)) * 0.08, $$10 * 0.1);
                this.level().addFreshEntity($$7);
                $$1.level().addFreshEntity(new ExperienceOrb($$1.level(), $$1.getX(), $$1.getY() + 0.5, $$1.getZ() + 0.5, this.random.nextInt(6) + 1));
                if (!$$6.is(ItemTags.FISHES)) continue;
                $$1.awardStat(Stats.FISH_CAUGHT, 1);
            }
            $$2 = 1;
        }
        if (this.onGround()) {
            $$2 = 2;
        }
        this.discard();
        return $$2;
    }

    @Override
    public void handleEntityEvent(byte p_37123_) {
        Player $$1;
        Entity entity;
        if (p_37123_ == 31 && this.level().isClientSide && (entity = this.hookedIn) instanceof Player && ($$1 = (Player)entity).isLocalPlayer()) {
            this.pullEntity(this.hookedIn);
        }
        super.handleEntityEvent(p_37123_);
    }

    protected void pullEntity(Entity p_150156_) {
        Entity $$1 = this.getOwner();
        if ($$1 == null) {
            return;
        }
        Vec3 $$2 = new Vec3($$1.getX() - this.getX(), $$1.getY() - this.getY(), $$1.getZ() - this.getZ()).scale(0.1);
        p_150156_.setDeltaMovement(p_150156_.getDeltaMovement().add($$2));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void remove(Entity.RemovalReason p_150146_) {
        this.updateOwnerInfo(null);
        super.remove(p_150146_);
    }

    @Override
    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    @Override
    public void setOwner(@Nullable Entity p_150154_) {
        super.setOwner(p_150154_);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable FishingHook p_150148_) {
        Player $$1 = this.getPlayerOwner();
        if ($$1 != null) {
            $$1.fishing = p_150148_;
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Player $$1;
        Entity $$0 = this.getOwner();
        return $$0 instanceof Player ? ($$1 = (Player)$$0) : null;
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedIn;
    }

    @Override
    public boolean canUsePortal(boolean p_352895_) {
        return false;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352092_) {
        Entity $$1 = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, p_352092_, $$1 == null ? this.getId() : $$1.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_150150_) {
        super.recreateFromPacket(p_150150_);
        if (this.getPlayerOwner() == null) {
            int $$1 = p_150150_.getData();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level().getEntity($$1), (Object)$$1);
            this.discard();
        }
    }

    static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

