/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;

public class WanderingTraderSpawner
implements CustomSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.create();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public WanderingTraderSpawner(ServerLevelData p_35914_) {
        this.serverLevelData = p_35914_;
        this.tickDelay = 1200;
        this.spawnDelay = p_35914_.getWanderingTraderSpawnDelay();
        this.spawnChance = p_35914_.getWanderingTraderSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            p_35914_.setWanderingTraderSpawnDelay(this.spawnDelay);
            this.spawnChance = 25;
            p_35914_.setWanderingTraderSpawnChance(this.spawnChance);
        }
    }

    @Override
    public void tick(ServerLevel p_35922_, boolean p_35923_, boolean p_35924_) {
        if (!p_35922_.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
            return;
        }
        if (--this.tickDelay > 0) {
            return;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        this.serverLevelData.setWanderingTraderSpawnDelay(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return;
        }
        this.spawnDelay = 24000;
        if (!p_35922_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        int $$3 = this.spawnChance;
        this.spawnChance = Mth.clamp(this.spawnChance + 25, 25, 75);
        this.serverLevelData.setWanderingTraderSpawnChance(this.spawnChance);
        if (this.random.nextInt(100) > $$3) {
            return;
        }
        if (this.spawn(p_35922_)) {
            this.spawnChance = 25;
        }
    }

    private boolean spawn(ServerLevel p_35916_) {
        ServerPlayer $$1 = p_35916_.getRandomPlayer();
        if ($$1 == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPos $$2 = $$1.blockPosition();
        int $$3 = 48;
        PoiManager $$4 = p_35916_.getPoiManager();
        Optional<BlockPos> $$5 = $$4.find(p_219713_ -> p_219713_.is(PoiTypes.MEETING), p_219711_ -> true, $$2, 48, PoiManager.Occupancy.ANY);
        BlockPos $$6 = $$5.orElse($$2);
        BlockPos $$7 = this.findSpawnPositionNear(p_35916_, $$6, 48);
        if ($$7 != null && this.hasEnoughSpace(p_35916_, $$7)) {
            if (p_35916_.getBiome($$7).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                return false;
            }
            WanderingTrader $$8 = EntityType.WANDERING_TRADER.spawn(p_35916_, $$7, EntitySpawnReason.EVENT);
            if ($$8 != null) {
                for (int $$9 = 0; $$9 < 2; ++$$9) {
                    this.tryToSpawnLlamaFor(p_35916_, $$8, 4);
                }
                this.serverLevelData.setWanderingTraderId($$8.getUUID());
                $$8.setDespawnDelay(48000);
                $$8.setWanderTarget($$6);
                $$8.setHomeTo($$6, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(ServerLevel p_35918_, WanderingTrader p_35919_, int p_35920_) {
        BlockPos $$3 = this.findSpawnPositionNear(p_35918_, p_35919_.blockPosition(), p_35920_);
        if ($$3 == null) {
            return;
        }
        TraderLlama $$4 = EntityType.TRADER_LLAMA.spawn(p_35918_, $$3, EntitySpawnReason.EVENT);
        if ($$4 == null) {
            return;
        }
        $$4.setLeashedTo(p_35919_, true);
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader p_35929_, BlockPos p_35930_, int p_35931_) {
        BlockPos $$3 = null;
        SpawnPlacementType $$4 = SpawnPlacements.getPlacementType(EntityType.WANDERING_TRADER);
        for (int $$5 = 0; $$5 < 10; ++$$5) {
            int $$7;
            int $$8;
            int $$6 = p_35930_.getX() + this.random.nextInt(p_35931_ * 2) - p_35931_;
            BlockPos $$9 = new BlockPos($$6, $$8 = p_35929_.getHeight(Heightmap.Types.WORLD_SURFACE, $$6, $$7 = p_35930_.getZ() + this.random.nextInt(p_35931_ * 2) - p_35931_), $$7);
            if (!$$4.isSpawnPositionOk(p_35929_, $$9, EntityType.WANDERING_TRADER)) continue;
            $$3 = $$9;
            break;
        }
        return $$3;
    }

    private boolean hasEnoughSpace(BlockGetter p_35926_, BlockPos p_35927_) {
        for (BlockPos $$2 : BlockPos.betweenClosed(p_35927_, p_35927_.offset(1, 2, 1))) {
            if (p_35926_.getBlockState($$2).getCollisionShape(p_35926_, $$2).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

