/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public record VillagerData(Holder<VillagerType> type, Holder<VillagerProfession> profession, int level) {
    public static final int MIN_VILLAGER_LEVEL = 1;
    public static final int MAX_VILLAGER_LEVEL = 5;
    private static final int[] NEXT_LEVEL_XP_THRESHOLDS = new int[]{0, 10, 70, 150, 250};
    public static final Codec<VillagerData> CODEC = RecordCodecBuilder.create(p_396859_ -> p_396859_.group((App)BuiltInRegistries.VILLAGER_TYPE.holderByNameCodec().fieldOf("type").orElseGet(() -> BuiltInRegistries.VILLAGER_TYPE.getOrThrow(VillagerType.PLAINS)).forGetter(p_396857_ -> p_396857_.type), (App)BuiltInRegistries.VILLAGER_PROFESSION.holderByNameCodec().fieldOf("profession").orElseGet(() -> BuiltInRegistries.VILLAGER_PROFESSION.getOrThrow(VillagerProfession.NONE)).forGetter(p_396858_ -> p_396858_.profession), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(p_150020_ -> p_150020_.level)).apply((Applicative)p_396859_, VillagerData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VillagerData> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.VILLAGER_TYPE), VillagerData::type, ByteBufCodecs.holderRegistry(Registries.VILLAGER_PROFESSION), VillagerData::profession, ByteBufCodecs.VAR_INT, VillagerData::level, VillagerData::new);

    public VillagerData {
        level = Math.max(1, level);
    }

    public VillagerData withType(Holder<VillagerType> p_396986_) {
        return new VillagerData(p_396986_, this.profession, this.level);
    }

    public VillagerData withType(HolderGetter.Provider p_397285_, ResourceKey<VillagerType> p_397400_) {
        return this.withType(p_397285_.getOrThrow(p_397400_));
    }

    public VillagerData withProfession(Holder<VillagerProfession> p_397154_) {
        return new VillagerData(this.type, p_397154_, this.level);
    }

    public VillagerData withProfession(HolderGetter.Provider p_397368_, ResourceKey<VillagerProfession> p_396992_) {
        return this.withProfession(p_397368_.getOrThrow(p_396992_));
    }

    public VillagerData withLevel(int p_397082_) {
        return new VillagerData(this.type, this.profession, p_397082_);
    }

    public static int getMinXpPerLevel(int p_35573_) {
        return VillagerData.canLevelUp(p_35573_) ? NEXT_LEVEL_XP_THRESHOLDS[p_35573_ - 1] : 0;
    }

    public static int getMaxXpPerLevel(int p_35578_) {
        return VillagerData.canLevelUp(p_35578_) ? NEXT_LEVEL_XP_THRESHOLDS[p_35578_] : 0;
    }

    public static boolean canLevelUp(int p_35583_) {
        return p_35583_ >= 1 && p_35583_ < 5;
    }
}

