/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.schedule.Activity;

public class HoglinAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds(5, 20);
    private static final int ATTACK_DURATION = 200;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_IDLING = 8;
    private static final int DESIRED_DISTANCE_FROM_PIGLIN_WHEN_RETREATING = 15;
    private static final int ATTACK_INTERVAL = 40;
    private static final int BABY_ATTACK_INTERVAL = 15;
    private static final int REPELLENT_PACIFY_TIME = 200;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of(5, 16);
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING_REPELLENT = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.3f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 0.6f;

    protected static Brain<?> makeBrain(Brain<Hoglin> p_34576_) {
        HoglinAi.initCoreActivity(p_34576_);
        HoglinAi.initIdleActivity(p_34576_);
        HoglinAi.initFightActivity(p_34576_);
        HoglinAi.initRetreatActivity(p_34576_);
        p_34576_.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        p_34576_.setDefaultActivity(Activity.IDLE);
        p_34576_.useDefaultActivity();
        return p_34576_;
    }

    private static void initCoreActivity(Brain<Hoglin> p_34592_) {
        p_34592_.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<Hoglin> p_34602_) {
        p_34602_.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of(BecomePassiveIfMemoryPresent.create(MemoryModuleType.NEAREST_REPELLENT, 200), (Object)new AnimalMakeLove(EntityType.HOGLIN, 0.6f, 2), SetWalkTargetAwayFrom.pos(MemoryModuleType.NEAREST_REPELLENT, 1.0f, 8, true), StartAttacking.create(HoglinAi::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(Hoglin::isAdult, SetWalkTargetAwayFrom.entity(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, 0.4f, 8, false)), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), BabyFollowAdult.create(ADULT_FOLLOW_RANGE, 0.6f), HoglinAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<Hoglin> p_34609_) {
        p_34609_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of(BecomePassiveIfMemoryPresent.create(MemoryModuleType.NEAREST_REPELLENT, 200), (Object)new AnimalMakeLove(EntityType.HOGLIN, 0.6f, 2), SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.0f), BehaviorBuilder.triggerIf(Hoglin::isAdult, MeleeAttack.create(40)), BehaviorBuilder.triggerIf(AgeableMob::isBaby, MeleeAttack.create(15)), StopAttackingIfTargetInvalid.create(), EraseMemoryIf.create(HoglinAi::isBreeding, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initRetreatActivity(Brain<Hoglin> p_34616_) {
        p_34616_.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, (ImmutableList<BehaviorControl<Hoglin>>)ImmutableList.of(SetWalkTargetAwayFrom.entity(MemoryModuleType.AVOID_TARGET, 1.3f, 15, false), HoglinAi.createIdleMovementBehaviors(), SetEntityLookTargetSometimes.create(8.0f, UniformInt.of(30, 60)), EraseMemoryIf.create(HoglinAi::wantsToStopFleeing, MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<Hoglin> createIdleMovementBehaviors() {
        return new RunOne<Hoglin>((List<Pair<BehaviorControl<Hoglin>, Integer>>)ImmutableList.of((Object)Pair.of(RandomStroll.stroll(0.4f), (Object)2), (Object)Pair.of(SetWalkTargetFromLookTarget.create(0.4f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    protected static void updateActivity(Hoglin p_34578_) {
        Brain<Hoglin> $$1 = p_34578_.getBrain();
        Activity $$2 = $$1.getActiveNonCoreActivity().orElse(null);
        $$1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        Activity $$3 = $$1.getActiveNonCoreActivity().orElse(null);
        if ($$2 != $$3) {
            HoglinAi.getSoundForCurrentActivity(p_34578_).ifPresent(p_34578_::makeSound);
        }
        p_34578_.setAggressive($$1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    protected static void onHitTarget(Hoglin p_34580_, LivingEntity p_34581_) {
        if (p_34580_.isBaby()) {
            return;
        }
        if (p_34581_.getType() == EntityType.PIGLIN && HoglinAi.piglinsOutnumberHoglins(p_34580_)) {
            HoglinAi.setAvoidTarget(p_34580_, p_34581_);
            HoglinAi.broadcastRetreat(p_34580_, p_34581_);
            return;
        }
        HoglinAi.broadcastAttackTarget(p_34580_, p_34581_);
    }

    private static void broadcastRetreat(Hoglin p_34606_, LivingEntity p_34607_) {
        HoglinAi.getVisibleAdultHoglins(p_34606_).forEach(p_34590_ -> HoglinAi.retreatFromNearestTarget(p_34590_, p_34607_));
    }

    private static void retreatFromNearestTarget(Hoglin p_34613_, LivingEntity p_34614_) {
        LivingEntity $$2 = p_34614_;
        Brain<Hoglin> $$3 = p_34613_.getBrain();
        $$2 = BehaviorUtils.getNearestTarget(p_34613_, $$3.getMemory(MemoryModuleType.AVOID_TARGET), $$2);
        $$2 = BehaviorUtils.getNearestTarget(p_34613_, $$3.getMemory(MemoryModuleType.ATTACK_TARGET), $$2);
        HoglinAi.setAvoidTarget(p_34613_, $$2);
    }

    private static void setAvoidTarget(Hoglin p_34620_, LivingEntity p_34621_) {
        p_34620_.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        p_34620_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_34620_.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, p_34621_, RETREAT_DURATION.sample(p_34620_.level().random));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(ServerLevel p_376560_, Hoglin p_34611_) {
        if (HoglinAi.isPacified(p_34611_) || HoglinAi.isBreeding(p_34611_)) {
            return Optional.empty();
        }
        return p_34611_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    static boolean isPosNearNearestRepellent(Hoglin p_34586_, BlockPos p_34587_) {
        Optional<BlockPos> $$2 = p_34586_.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return $$2.isPresent() && $$2.get().closerThan(p_34587_, 8.0);
    }

    private static boolean wantsToStopFleeing(Hoglin p_34618_) {
        return p_34618_.isAdult() && !HoglinAi.piglinsOutnumberHoglins(p_34618_);
    }

    private static boolean piglinsOutnumberHoglins(Hoglin p_34623_) {
        int $$2;
        if (p_34623_.isBaby()) {
            return false;
        }
        int $$1 = p_34623_.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0);
        return $$1 > ($$2 = p_34623_.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0) + 1);
    }

    protected static void wasHurtBy(ServerLevel p_376449_, Hoglin p_34596_, LivingEntity p_34597_) {
        Brain<Hoglin> $$3 = p_34596_.getBrain();
        $$3.eraseMemory(MemoryModuleType.PACIFIED);
        $$3.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (p_34596_.isBaby()) {
            HoglinAi.retreatFromNearestTarget(p_34596_, p_34597_);
            return;
        }
        HoglinAi.maybeRetaliate(p_376449_, p_34596_, p_34597_);
    }

    private static void maybeRetaliate(ServerLevel p_376686_, Hoglin p_34625_, LivingEntity p_34626_) {
        if (p_34625_.getBrain().isActive(Activity.AVOID) && p_34626_.getType() == EntityType.PIGLIN) {
            return;
        }
        if (p_34626_.getType() == EntityType.HOGLIN) {
            return;
        }
        if (BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(p_34625_, p_34626_, 4.0)) {
            return;
        }
        if (!Sensor.isEntityAttackable(p_376686_, p_34625_, p_34626_)) {
            return;
        }
        HoglinAi.setAttackTarget(p_34625_, p_34626_);
        HoglinAi.broadcastAttackTarget(p_34625_, p_34626_);
    }

    private static void setAttackTarget(Hoglin p_34630_, LivingEntity p_34631_) {
        Brain<Hoglin> $$2 = p_34630_.getBrain();
        $$2.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        $$2.eraseMemory(MemoryModuleType.BREED_TARGET);
        $$2.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, p_34631_, 200L);
    }

    private static void broadcastAttackTarget(Hoglin p_34635_, LivingEntity p_34636_) {
        HoglinAi.getVisibleAdultHoglins(p_34635_).forEach(p_34574_ -> HoglinAi.setAttackTargetIfCloserThanCurrent(p_34574_, p_34636_));
    }

    private static void setAttackTargetIfCloserThanCurrent(Hoglin p_34640_, LivingEntity p_34641_) {
        if (HoglinAi.isPacified(p_34640_)) {
            return;
        }
        Optional<LivingEntity> $$2 = p_34640_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        LivingEntity $$3 = BehaviorUtils.getNearestTarget(p_34640_, $$2, p_34641_);
        HoglinAi.setAttackTarget(p_34640_, $$3);
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Hoglin p_34594_) {
        return p_34594_.getBrain().getActiveNonCoreActivity().map(p_34600_ -> HoglinAi.getSoundForActivity(p_34594_, p_34600_));
    }

    private static SoundEvent getSoundForActivity(Hoglin p_34583_, Activity p_34584_) {
        if (p_34584_ == Activity.AVOID || p_34583_.isConverting()) {
            return SoundEvents.HOGLIN_RETREAT;
        }
        if (p_34584_ == Activity.FIGHT) {
            return SoundEvents.HOGLIN_ANGRY;
        }
        if (HoglinAi.isNearRepellent(p_34583_)) {
            return SoundEvents.HOGLIN_RETREAT;
        }
        return SoundEvents.HOGLIN_AMBIENT;
    }

    private static List<Hoglin> getVisibleAdultHoglins(Hoglin p_34628_) {
        return p_34628_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS).orElse((List<Hoglin>)ImmutableList.of());
    }

    private static boolean isNearRepellent(Hoglin p_34633_) {
        return p_34633_.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean isBreeding(Hoglin p_34638_) {
        return p_34638_.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }

    protected static boolean isPacified(Hoglin p_34604_) {
        return p_34604_.getBrain().hasMemoryValue(MemoryModuleType.PACIFIED);
    }
}

