/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ItemEntity
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemEntity.class, EntityDataSerializers.ITEM_STACK);
    private static final float FLOAT_HEIGHT = 0.1f;
    public static final float EYE_HEIGHT = 0.2125f;
    private static final int LIFETIME = 6000;
    private static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;
    private static final int INFINITE_LIFETIME = Short.MIN_VALUE;
    private static final int DEFAULT_HEALTH = 5;
    private static final short DEFAULT_AGE = 0;
    private static final short DEFAULT_PICKUP_DELAY = 0;
    private int age = 0;
    private int pickupDelay = 0;
    private int health = 5;
    @Nullable
    private EntityReference<Entity> thrower;
    @Nullable
    private UUID target;
    public final float bobOffs;

    public ItemEntity(EntityType<? extends ItemEntity> p_31991_, Level p_31992_) {
        super(p_31991_, p_31992_);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public ItemEntity(Level p_32001_, double p_32002_, double p_32003_, double p_32004_, ItemStack p_32005_) {
        this(p_32001_, p_32002_, p_32003_, p_32004_, p_32005_, p_32001_.random.nextDouble() * 0.2 - 0.1, 0.2, p_32001_.random.nextDouble() * 0.2 - 0.1);
    }

    public ItemEntity(Level p_149663_, double p_149664_, double p_149665_, double p_149666_, ItemStack p_149667_, double p_149668_, double p_149669_, double p_149670_) {
        this((EntityType<? extends ItemEntity>)EntityType.ITEM, p_149663_);
        this.setPos(p_149664_, p_149665_, p_149666_);
        this.setDeltaMovement(p_149668_, p_149669_, p_149670_);
        this.setItem(p_149667_);
    }

    private ItemEntity(ItemEntity p_31994_) {
        super(p_31994_.getType(), p_31994_.level());
        this.setItem(p_31994_.getItem().copy());
        this.copyPosition(p_31994_);
        this.age = p_31994_.age;
        this.bobOffs = p_31994_.bobOffs;
    }

    @Override
    public boolean dampensVibrations() {
        return this.getItem().is(ItemTags.DAMPENS_VIBRATIONS);
    }

    @Override
    @Nullable
    public Entity getOwner() {
        return EntityReference.get(this.thrower, this.level(), Entity.class);
    }

    @Override
    public void restoreFrom(Entity p_305965_) {
        super.restoreFrom(p_305965_);
        if (p_305965_ instanceof ItemEntity) {
            ItemEntity $$1 = (ItemEntity)p_305965_;
            this.thrower = $$1.thrower;
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326372_) {
        p_326372_.define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        double $$5;
        int $$4;
        if (this.getItem().isEmpty()) {
            this.discard();
            return;
        }
        super.tick();
        if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
            --this.pickupDelay;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        Vec3 $$0 = this.getDeltaMovement();
        if (this.isInWater() && this.getFluidHeight(FluidTags.WATER) > (double)0.1f) {
            this.setUnderwaterMovement();
        } else if (this.isInLava() && this.getFluidHeight(FluidTags.LAVA) > (double)0.1f) {
            this.setUnderLavaMovement();
        } else {
            this.applyGravity();
        }
        if (this.level().isClientSide) {
            this.noPhysics = false;
        } else {
            boolean bl = this.noPhysics = !this.level().noCollision(this, this.getBoundingBox().deflate(1.0E-7));
            if (this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
            }
        }
        if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            float $$1 = 0.98f;
            if (this.onGround()) {
                $$1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply($$1, 0.98, $$1));
            if (this.onGround()) {
                Vec3 $$2 = this.getDeltaMovement();
                if ($$2.y < 0.0) {
                    this.setDeltaMovement($$2.multiply(1.0, -0.5, 1.0));
                }
            }
        }
        boolean $$3 = Mth.floor(this.xo) != Mth.floor(this.getX()) || Mth.floor(this.yo) != Mth.floor(this.getY()) || Mth.floor(this.zo) != Mth.floor(this.getZ());
        int n = $$4 = $$3 ? 2 : 40;
        if (this.tickCount % $$4 == 0 && !this.level().isClientSide && this.isMergable()) {
            this.mergeWithNeighbours();
        }
        if (this.age != Short.MIN_VALUE) {
            ++this.age;
        }
        this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
        if (!this.level().isClientSide && ($$5 = this.getDeltaMovement().subtract($$0).lengthSqr()) > 0.01) {
            this.hasImpulse = true;
        }
        if (!this.level().isClientSide && this.age >= 6000) {
            this.discard();
        }
    }

    @Override
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void setUnderwaterMovement() {
        this.setFluidMovement(0.99f);
    }

    private void setUnderLavaMovement() {
        this.setFluidMovement(0.95f);
    }

    private void setFluidMovement(double p_376453_) {
        Vec3 $$1 = this.getDeltaMovement();
        this.setDeltaMovement($$1.x * p_376453_, $$1.y + (double)($$1.y < (double)0.06f ? 5.0E-4f : 0.0f), $$1.z * p_376453_);
    }

    private void mergeWithNeighbours() {
        if (!this.isMergable()) {
            return;
        }
        List<ItemEntity> $$0 = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(0.5, 0.0, 0.5), p_186268_ -> p_186268_ != this && p_186268_.isMergable());
        for (ItemEntity $$1 : $$0) {
            if (!$$1.isMergable()) continue;
            this.tryToMerge($$1);
            if (!this.isRemoved()) continue;
            break;
        }
    }

    private boolean isMergable() {
        ItemStack $$0 = this.getItem();
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.age != Short.MIN_VALUE && this.age < 6000 && $$0.getCount() < $$0.getMaxStackSize();
    }

    private void tryToMerge(ItemEntity p_32016_) {
        ItemStack $$1 = this.getItem();
        ItemStack $$2 = p_32016_.getItem();
        if (!Objects.equals(this.target, p_32016_.target) || !ItemEntity.areMergable($$1, $$2)) {
            return;
        }
        if ($$2.getCount() < $$1.getCount()) {
            ItemEntity.merge(this, $$1, p_32016_, $$2);
        } else {
            ItemEntity.merge(p_32016_, $$2, this, $$1);
        }
    }

    public static boolean areMergable(ItemStack p_32027_, ItemStack p_32028_) {
        if (p_32028_.getCount() + p_32027_.getCount() > p_32028_.getMaxStackSize()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents(p_32027_, p_32028_);
    }

    public static ItemStack merge(ItemStack p_32030_, ItemStack p_32031_, int p_32032_) {
        int $$3 = Math.min(Math.min(p_32030_.getMaxStackSize(), p_32032_) - p_32030_.getCount(), p_32031_.getCount());
        ItemStack $$4 = p_32030_.copyWithCount(p_32030_.getCount() + $$3);
        p_32031_.shrink($$3);
        return $$4;
    }

    private static void merge(ItemEntity p_32023_, ItemStack p_32024_, ItemStack p_32025_) {
        ItemStack $$3 = ItemEntity.merge(p_32024_, p_32025_, 64);
        p_32023_.setItem($$3);
    }

    private static void merge(ItemEntity p_32018_, ItemStack p_32019_, ItemEntity p_32020_, ItemStack p_32021_) {
        ItemEntity.merge(p_32018_, p_32019_, p_32021_);
        p_32018_.pickupDelay = Math.max(p_32018_.pickupDelay, p_32020_.pickupDelay);
        p_32018_.age = Math.min(p_32018_.age, p_32020_.age);
        if (p_32021_.isEmpty()) {
            p_32020_.discard();
        }
    }

    @Override
    public boolean fireImmune() {
        return !this.getItem().canBeHurtBy(this.damageSources().inFire()) || super.fireImmune();
    }

    @Override
    protected boolean shouldPlayLavaHurtSound() {
        if (this.health <= 0) {
            return true;
        }
        return this.tickCount % 10 == 0;
    }

    @Override
    public final boolean hurtClient(DamageSource p_376799_) {
        if (this.isInvulnerableToBase(p_376799_)) {
            return false;
        }
        return this.getItem().canBeHurtBy(p_376799_);
    }

    @Override
    public final boolean hurtServer(ServerLevel p_376942_, DamageSource p_376452_, float p_376562_) {
        if (this.isInvulnerableToBase(p_376452_)) {
            return false;
        }
        if (!p_376942_.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && p_376452_.getEntity() instanceof Mob) {
            return false;
        }
        if (!this.getItem().canBeHurtBy(p_376452_)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - p_376562_);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, p_376452_.getEntity());
        if (this.health <= 0) {
            this.getItem().onDestroyed(this);
            this.discard();
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion p_364217_) {
        if (p_364217_.shouldAffectBlocklikeEntities()) {
            return super.ignoreExplosion(p_364217_);
        }
        return true;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_421930_) {
        p_421930_.putShort("Health", (short)this.health);
        p_421930_.putShort("Age", (short)this.age);
        p_421930_.putShort("PickupDelay", (short)this.pickupDelay);
        EntityReference.store(this.thrower, p_421930_, "Thrower");
        p_421930_.storeNullable("Owner", UUIDUtil.CODEC, this.target);
        if (!this.getItem().isEmpty()) {
            p_421930_.store("Item", ItemStack.CODEC, this.getItem());
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421942_) {
        this.health = p_421942_.getShortOr("Health", (short)5);
        this.age = p_421942_.getShortOr("Age", (short)0);
        this.pickupDelay = p_421942_.getShortOr("PickupDelay", (short)0);
        this.target = p_421942_.read("Owner", UUIDUtil.CODEC).orElse(null);
        this.thrower = EntityReference.read(p_421942_, "Thrower");
        this.setItem(p_421942_.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    @Override
    public void playerTouch(Player p_32040_) {
        if (this.level().isClientSide) {
            return;
        }
        ItemStack $$1 = this.getItem();
        Item $$2 = $$1.getItem();
        int $$3 = $$1.getCount();
        if (this.pickupDelay == 0 && (this.target == null || this.target.equals(p_32040_.getUUID())) && p_32040_.getInventory().add($$1)) {
            p_32040_.take(this, $$3);
            if ($$1.isEmpty()) {
                this.discard();
                $$1.setCount($$3);
            }
            p_32040_.awardStat(Stats.ITEM_PICKED_UP.get($$2), $$3);
            p_32040_.onItemPickup(this);
        }
    }

    @Override
    public Component getName() {
        Component $$0 = this.getCustomName();
        if ($$0 != null) {
            return $$0;
        }
        return this.getItem().getItemName();
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition p_379799_) {
        Entity $$1 = super.teleport(p_379799_);
        if (!this.level().isClientSide && $$1 instanceof ItemEntity) {
            ItemEntity $$2 = (ItemEntity)$$1;
            $$2.mergeWithNeighbours();
        }
        return $$1;
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack p_32046_) {
        this.getEntityData().set(DATA_ITEM, p_32046_);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_32036_) {
        super.onSyncedDataUpdated(p_32036_);
        if (DATA_ITEM.equals(p_32036_)) {
            this.getItem().setEntityRepresentation(this);
        }
    }

    public void setTarget(@Nullable UUID p_266724_) {
        this.target = p_266724_;
    }

    public void setThrower(Entity p_306324_) {
        this.thrower = new EntityReference<Entity>(p_306324_);
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int p_32011_) {
        this.pickupDelay = p_32011_;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public void setUnlimitedLifetime() {
        this.age = Short.MIN_VALUE;
    }

    public void setExtendedLifetime() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setNeverPickUp();
        this.age = 5999;
    }

    public static float getSpin(float p_32009_, float p_361295_) {
        return p_32009_ / 20.0f + p_361295_;
    }

    public ItemEntity copy() {
        return new ItemEntity(this);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return 180.0f - ItemEntity.getSpin((float)this.getAge() + 0.5f, this.bobOffs) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess getSlot(int p_333779_) {
        if (p_333779_ == 0) {
            return SlotAccess.of(this::getItem, this::setItem);
        }
        return super.getSlot(p_333779_);
    }
}

