/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int checkInterval;
    protected BlockPos pos;

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> p_345070_, Level p_345079_) {
        super(p_345070_, p_345079_);
    }

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> p_345456_, Level p_345187_, BlockPos p_345816_) {
        this(p_345456_, p_345187_);
        this.pos = p_345816_;
    }

    protected abstract void recalculateBoundingBox();

    @Override
    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level;
            this.checkBelowWorld();
            if (this.checkInterval++ == 100) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    this.discard();
                    this.dropItem($$0, null);
                }
            }
        }
    }

    public abstract boolean survives();

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity p_346423_) {
        if (p_346423_ instanceof Player) {
            Player $$1 = (Player)p_346423_;
            if (!this.level().mayInteract($$1, this.pos)) {
                return true;
            }
            return this.hurtOrSimulate(this.damageSources().playerAttack($$1), 0.0f);
        }
        return false;
    }

    @Override
    public boolean hurtClient(DamageSource p_376476_) {
        return !this.isInvulnerableToBase(p_376476_);
    }

    @Override
    public boolean hurtServer(ServerLevel p_376632_, DamageSource p_376099_, float p_376549_) {
        if (this.isInvulnerableToBase(p_376099_)) {
            return false;
        }
        if (!p_376632_.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && p_376099_.getEntity() instanceof Mob) {
            return false;
        }
        if (!this.isRemoved()) {
            this.kill(p_376632_);
            this.markHurt();
            this.dropItem(p_376632_, p_376099_.getEntity());
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion p_360311_) {
        Entity $$1 = p_360311_.getDirectSourceEntity();
        if ($$1 != null && $$1.isInWater()) {
            return true;
        }
        if (p_360311_.shouldAffectBlocklikeEntities()) {
            return super.ignoreExplosion(p_360311_);
        }
        return true;
    }

    @Override
    public void move(MoverType p_345778_, Vec3 p_345301_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            if (!this.isRemoved() && p_345301_.lengthSqr() > 0.0) {
                this.kill($$2);
                this.dropItem($$2, null);
            }
        }
    }

    @Override
    public void push(double p_345288_, double p_346171_, double p_345389_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)level;
            if (!this.isRemoved() && p_345288_ * p_345288_ + p_346171_ * p_346171_ + p_345389_ * p_345389_ > 0.0) {
                this.kill($$3);
                this.dropItem($$3, null);
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422179_) {
        p_422179_.store("block_pos", BlockPos.CODEC, this.getPos());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421739_) {
        BlockPos $$1 = p_421739_.read("block_pos", BlockPos.CODEC).orElse(null);
        if ($$1 == null || !$$1.closerThan(this.blockPosition(), 16.0)) {
            LOGGER.error("Block-attached entity at invalid position: {}", (Object)$$1);
            return;
        }
        this.pos = $$1;
    }

    public abstract void dropItem(ServerLevel var1, @Nullable Entity var2);

    @Override
    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @Override
    public void setPos(double p_346360_, double p_344743_, double p_345636_) {
        this.pos = BlockPos.containing(p_346360_, p_344743_, p_345636_);
        this.recalculateBoundingBox();
        this.hasImpulse = true;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void thunderHit(ServerLevel p_345825_, LightningBolt p_346288_) {
    }

    @Override
    public void refreshDimensions() {
    }
}

