/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ArmorStand
extends LivingEntity {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.fixed(0.0f, 0.0f);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.defineId(ArmorStand.class, EntityDataSerializers.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_373856_ -> {
        AbstractMinecart $$1;
        return p_373856_ instanceof AbstractMinecart && ($$1 = (AbstractMinecart)p_373856_).isRideable();
    };
    private static final boolean DEFAULT_INVISIBLE = false;
    private static final int DEFAULT_DISABLED_SLOTS = 0;
    private static final boolean DEFAULT_SMALL = false;
    private static final boolean DEFAULT_SHOW_ARMS = false;
    private static final boolean DEFAULT_NO_BASE_PLATE = false;
    private static final boolean DEFAULT_MARKER = false;
    private boolean invisible = false;
    public long lastHit;
    private int disabledSlots = 0;

    public ArmorStand(EntityType<? extends ArmorStand> p_31553_, Level p_31554_) {
        super((EntityType<? extends LivingEntity>)p_31553_, p_31554_);
    }

    public ArmorStand(Level p_31556_, double p_31557_, double p_31558_, double p_31559_) {
        this((EntityType<? extends ArmorStand>)EntityType.ARMOR_STAND, p_31556_);
        this.setPos(p_31557_, p_31558_, p_31559_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ArmorStand.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    @Override
    public void refreshDimensions() {
        double $$0 = this.getX();
        double $$1 = this.getY();
        double $$2 = this.getZ();
        super.refreshDimensions();
        this.setPos($$0, $$1, $$2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326283_) {
        super.defineSynchedData(p_326283_);
        p_326283_.define(DATA_CLIENT_FLAGS, (byte)0);
        p_326283_.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        p_326283_.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        p_326283_.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        p_326283_.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        p_326283_.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        p_326283_.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_326077_) {
        return p_326077_ != EquipmentSlot.BODY && p_326077_ != EquipmentSlot.SADDLE && !this.isDisabled(p_326077_);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_422671_) {
        super.addAdditionalSaveData(p_422671_);
        p_422671_.putBoolean("Invisible", this.isInvisible());
        p_422671_.putBoolean("Small", this.isSmall());
        p_422671_.putBoolean("ShowArms", this.showArms());
        p_422671_.putInt("DisabledSlots", this.disabledSlots);
        p_422671_.putBoolean("NoBasePlate", !this.showBasePlate());
        if (this.isMarker()) {
            p_422671_.putBoolean("Marker", this.isMarker());
        }
        p_422671_.store("Pose", ArmorStandPose.CODEC, this.getArmorStandPose());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_421830_) {
        super.readAdditionalSaveData(p_421830_);
        this.setInvisible(p_421830_.getBooleanOr("Invisible", false));
        this.setSmall(p_421830_.getBooleanOr("Small", false));
        this.setShowArms(p_421830_.getBooleanOr("ShowArms", false));
        this.disabledSlots = p_421830_.getIntOr("DisabledSlots", 0);
        this.setNoBasePlate(p_421830_.getBooleanOr("NoBasePlate", false));
        this.setMarker(p_421830_.getBooleanOr("Marker", false));
        this.noPhysics = !this.hasPhysics();
        p_421830_.read("Pose", ArmorStandPose.CODEC).ifPresent(this::setArmorStandPose);
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity p_31564_) {
    }

    @Override
    protected void pushEntities() {
        List<Entity> $$0 = this.level().getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS);
        for (Entity $$1 : $$0) {
            if (!(this.distanceToSqr($$1) <= 0.2)) continue;
            $$1.push(this);
        }
    }

    @Override
    public InteractionResult interactAt(Player p_31594_, Vec3 p_31595_, InteractionHand p_31596_) {
        ItemStack $$3 = p_31594_.getItemInHand(p_31596_);
        if (this.isMarker() || $$3.is(Items.NAME_TAG)) {
            return InteractionResult.PASS;
        }
        if (p_31594_.isSpectator()) {
            return InteractionResult.SUCCESS;
        }
        if (p_31594_.level().isClientSide) {
            return InteractionResult.SUCCESS_SERVER;
        }
        EquipmentSlot $$4 = this.getEquipmentSlotForItem($$3);
        if ($$3.isEmpty()) {
            EquipmentSlot $$6;
            EquipmentSlot $$5 = this.getClickedSlot(p_31595_);
            EquipmentSlot equipmentSlot = $$6 = this.isDisabled($$5) ? $$4 : $$5;
            if (this.hasItemInSlot($$6) && this.swapItem(p_31594_, $$6, $$3, p_31596_)) {
                return InteractionResult.SUCCESS_SERVER;
            }
        } else {
            if (this.isDisabled($$4)) {
                return InteractionResult.FAIL;
            }
            if ($$4.getType() == EquipmentSlot.Type.HAND && !this.showArms()) {
                return InteractionResult.FAIL;
            }
            if (this.swapItem(p_31594_, $$4, $$3, p_31596_)) {
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 p_31660_) {
        EquipmentSlot $$1 = EquipmentSlot.MAINHAND;
        boolean $$2 = this.isSmall();
        double $$3 = p_31660_.y / (double)(this.getScale() * this.getAgeScale());
        EquipmentSlot $$4 = EquipmentSlot.FEET;
        if ($$3 >= 0.1) {
            double d = $$2 ? 0.8 : 0.45;
            if ($$3 < 0.1 + d && this.hasItemInSlot($$4)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = $$2 ? 0.3 : 0.0;
        if ($$3 >= 0.9 + d) {
            double d2 = $$2 ? 1.0 : 0.7;
            if ($$3 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if ($$3 >= 0.4) {
            double d3 = $$2 ? 1.0 : 0.8;
            if ($$3 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if ($$3 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) return $$1;
        if (!this.hasItemInSlot(EquipmentSlot.OFFHAND)) return $$1;
        return EquipmentSlot.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlot p_31627_) {
        return (this.disabledSlots & 1 << p_31627_.getFilterBit(0)) != 0 || p_31627_.getType() == EquipmentSlot.Type.HAND && !this.showArms();
    }

    private boolean swapItem(Player p_31589_, EquipmentSlot p_31590_, ItemStack p_31591_, InteractionHand p_31592_) {
        ItemStack $$4 = this.getItemBySlot(p_31590_);
        if (!$$4.isEmpty() && (this.disabledSlots & 1 << p_31590_.getFilterBit(8)) != 0) {
            return false;
        }
        if ($$4.isEmpty() && (this.disabledSlots & 1 << p_31590_.getFilterBit(16)) != 0) {
            return false;
        }
        if (p_31589_.hasInfiniteMaterials() && $$4.isEmpty() && !p_31591_.isEmpty()) {
            this.setItemSlot(p_31590_, p_31591_.copyWithCount(1));
            return true;
        }
        if (!p_31591_.isEmpty() && p_31591_.getCount() > 1) {
            if (!$$4.isEmpty()) {
                return false;
            }
            this.setItemSlot(p_31590_, p_31591_.split(1));
            return true;
        }
        this.setItemSlot(p_31590_, p_31591_);
        p_31589_.setItemInHand(p_31592_, $$4);
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel p_376183_, DamageSource p_31579_, float p_31580_) {
        if (this.isRemoved()) {
            return false;
        }
        if (!p_376183_.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && p_31579_.getEntity() instanceof Mob) {
            return false;
        }
        if (p_31579_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.kill(p_376183_);
            return false;
        }
        if (this.isInvulnerableTo(p_376183_, p_31579_) || this.invisible || this.isMarker()) {
            return false;
        }
        if (p_31579_.is(DamageTypeTags.IS_EXPLOSION)) {
            this.brokenByAnything(p_376183_, p_31579_);
            this.kill(p_376183_);
            return false;
        }
        if (p_31579_.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
            if (this.isOnFire()) {
                this.causeDamage(p_376183_, p_31579_, 0.15f);
            } else {
                this.igniteForSeconds(5.0f);
            }
            return false;
        }
        if (p_31579_.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
            this.causeDamage(p_376183_, p_31579_, 4.0f);
            return false;
        }
        boolean $$3 = p_31579_.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
        boolean $$4 = p_31579_.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
        if (!$$3 && !$$4) {
            return false;
        }
        Entity entity = p_31579_.getEntity();
        if (entity instanceof Player) {
            Player $$5 = (Player)entity;
            if (!$$5.getAbilities().mayBuild) {
                return false;
            }
        }
        if (p_31579_.isCreativePlayer()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.kill(p_376183_);
            return true;
        }
        long $$6 = p_376183_.getGameTime();
        if ($$6 - this.lastHit <= 5L || $$4) {
            this.brokenByPlayer(p_376183_, p_31579_);
            this.showBreakingParticles();
            this.kill(p_376183_);
        } else {
            p_376183_.broadcastEntityEvent(this, (byte)32);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, p_31579_.getEntity());
            this.lastHit = $$6;
        }
        return true;
    }

    @Override
    public void handleEntityEvent(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(p_31568_);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_31574_) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1) || $$1 == 0.0) {
            $$1 = 4.0;
        }
        return p_31574_ < ($$1 *= 64.0) * $$1;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(ServerLevel p_348633_, DamageSource p_31649_, float p_31650_) {
        float $$3 = this.getHealth();
        if (($$3 -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_348633_, p_31649_);
            this.kill(p_348633_);
        } else {
            this.setHealth($$3);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, p_31649_.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel p_348677_, DamageSource p_31647_) {
        ItemStack $$2 = new ItemStack(Items.ARMOR_STAND);
        $$2.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        Block.popResource(this.level(), this.blockPosition(), $$2);
        this.brokenByAnything(p_348677_, p_31647_);
    }

    private void brokenByAnything(ServerLevel p_348553_, DamageSource p_31654_) {
        this.playBrokenSound();
        this.dropAllDeathLoot(p_348553_, p_31654_);
        for (EquipmentSlot $$2 : EquipmentSlot.VALUES) {
            ItemStack $$3 = this.equipment.set($$2, ItemStack.EMPTY);
            if ($$3.isEmpty()) continue;
            Block.popResource(this.level(), this.blockPosition().above(), $$3);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected void tickHeadTurn(float p_31644_) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
    }

    @Override
    public void travel(Vec3 p_31656_) {
        if (!this.hasPhysics()) {
            return;
        }
        super.travel(p_31656_);
    }

    @Override
    public void setYBodyRot(float p_31670_) {
        this.yBodyRotO = this.yRotO = p_31670_;
        this.yHeadRotO = this.yHeadRot = p_31670_;
    }

    @Override
    public void setYHeadRot(float p_31668_) {
        this.yBodyRotO = this.yRotO = p_31668_;
        this.yHeadRotO = this.yHeadRot = p_31668_;
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean p_31663_) {
        this.invisible = p_31663_;
        super.setInvisible(p_31663_);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public void kill(ServerLevel p_376582_) {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion(Explosion p_312813_) {
        if (p_312813_.shouldAffectBlocklikeEntities()) {
            return this.isInvisible();
        }
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        if (this.isMarker()) {
            return PushReaction.IGNORE;
        }
        return super.getPistonPushReaction();
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    private void setSmall(boolean p_31604_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, p_31604_));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean p_31676_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, p_31676_));
    }

    public boolean showArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean p_31679_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, p_31679_));
    }

    public boolean showBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) == 0;
    }

    private void setMarker(boolean p_31682_) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, p_31682_));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte p_31570_, int p_31571_, boolean p_31572_) {
        p_31570_ = p_31572_ ? (byte)(p_31570_ | p_31571_) : (byte)(p_31570_ & ~p_31571_);
        return p_31570_;
    }

    public void setHeadPose(Rotations p_31598_) {
        this.entityData.set(DATA_HEAD_POSE, p_31598_);
    }

    public void setBodyPose(Rotations p_31617_) {
        this.entityData.set(DATA_BODY_POSE, p_31617_);
    }

    public void setLeftArmPose(Rotations p_31624_) {
        this.entityData.set(DATA_LEFT_ARM_POSE, p_31624_);
    }

    public void setRightArmPose(Rotations p_31629_) {
        this.entityData.set(DATA_RIGHT_ARM_POSE, p_31629_);
    }

    public void setLeftLegPose(Rotations p_31640_) {
        this.entityData.set(DATA_LEFT_LEG_POSE, p_31640_);
    }

    public void setRightLegPose(Rotations p_31652_) {
        this.entityData.set(DATA_RIGHT_LEG_POSE, p_31652_);
    }

    public Rotations getHeadPose() {
        return this.entityData.get(DATA_HEAD_POSE);
    }

    public Rotations getBodyPose() {
        return this.entityData.get(DATA_BODY_POSE);
    }

    public Rotations getLeftArmPose() {
        return this.entityData.get(DATA_LEFT_ARM_POSE);
    }

    public Rotations getRightArmPose() {
        return this.entityData.get(DATA_RIGHT_ARM_POSE);
    }

    public Rotations getLeftLegPose() {
        return this.entityData.get(DATA_LEFT_LEG_POSE);
    }

    public Rotations getRightLegPose() {
        return this.entityData.get(DATA_RIGHT_LEG_POSE);
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean skipAttackInteraction(Entity p_31687_) {
        if (!(p_31687_ instanceof Player)) return false;
        Player $$1 = (Player)p_31687_;
        if (this.level().mayInteract($$1, this.blockPosition())) return false;
        return true;
    }

    @Override
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_31636_) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(ServerLevel p_31576_, LightningBolt p_31577_) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31602_) {
        if (DATA_CLIENT_FLAGS.equals(p_31602_)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(p_31602_);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_31587_) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean p_31684_) {
        if (p_31684_) {
            return MARKER_DIMENSIONS;
        }
        return this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions();
    }

    @Override
    public Vec3 getLightProbePosition(float p_31665_) {
        if (this.isMarker()) {
            AABB $$1 = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPos $$2 = this.blockPosition();
            int $$3 = Integer.MIN_VALUE;
            for (BlockPos $$4 : BlockPos.betweenClosed(BlockPos.containing($$1.minX, $$1.minY, $$1.minZ), BlockPos.containing($$1.maxX, $$1.maxY, $$1.maxZ))) {
                int $$5 = Math.max(this.level().getBrightness(LightLayer.BLOCK, $$4), this.level().getBrightness(LightLayer.SKY, $$4));
                if ($$5 == 15) {
                    return Vec3.atCenterOf($$4);
                }
                if ($$5 <= $$3) continue;
                $$3 = $$5;
                $$2 = $$4.immutable();
            }
            return Vec3.atCenterOf($$2);
        }
        return super.getLightProbePosition(p_31665_);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }

    public void setArmorStandPose(ArmorStandPose p_422191_) {
        this.setHeadPose(p_422191_.head());
        this.setBodyPose(p_422191_.body());
        this.setLeftArmPose(p_422191_.leftArm());
        this.setRightArmPose(p_422191_.rightArm());
        this.setLeftLegPose(p_422191_.leftLeg());
        this.setRightLegPose(p_422191_.rightLeg());
    }

    public ArmorStandPose getArmorStandPose() {
        return new ArmorStandPose(this.getHeadPose(), this.getBodyPose(), this.getLeftArmPose(), this.getRightArmPose(), this.getLeftLegPose(), this.getRightLegPose());
    }

    public record ArmorStandPose(Rotations head, Rotations body, Rotations leftArm, Rotations rightArm, Rotations leftLeg, Rotations rightLeg) {
        public static final ArmorStandPose DEFAULT = new ArmorStandPose(DEFAULT_HEAD_POSE, DEFAULT_BODY_POSE, DEFAULT_LEFT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE, DEFAULT_LEFT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
        public static final Codec<ArmorStandPose> CODEC = RecordCodecBuilder.create(p_421686_ -> p_421686_.group((App)Rotations.CODEC.optionalFieldOf("Head", (Object)DEFAULT_HEAD_POSE).forGetter(ArmorStandPose::head), (App)Rotations.CODEC.optionalFieldOf("Body", (Object)DEFAULT_BODY_POSE).forGetter(ArmorStandPose::body), (App)Rotations.CODEC.optionalFieldOf("LeftArm", (Object)DEFAULT_LEFT_ARM_POSE).forGetter(ArmorStandPose::leftArm), (App)Rotations.CODEC.optionalFieldOf("RightArm", (Object)DEFAULT_RIGHT_ARM_POSE).forGetter(ArmorStandPose::rightArm), (App)Rotations.CODEC.optionalFieldOf("LeftLeg", (Object)DEFAULT_LEFT_LEG_POSE).forGetter(ArmorStandPose::leftLeg), (App)Rotations.CODEC.optionalFieldOf("RightLeg", (Object)DEFAULT_RIGHT_LEG_POSE).forGetter(ArmorStandPose::rightLeg)).apply((Applicative)p_421686_, ArmorStandPose::new));
    }
}

